/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.database.internal.http;

import com.google.common.base.Function;
import com.google.common.base.Optional;
import com.oracle.bmc.database.model.DatabaseUpgradeHistoryEntry;
import com.oracle.bmc.database.requests.GetDatabaseUpgradeHistoryEntryRequest;
import com.oracle.bmc.database.responses.GetDatabaseUpgradeHistoryEntryResponse;
import com.oracle.bmc.http.internal.HeaderUtils;
import com.oracle.bmc.http.internal.ResponseConversionFunctionFactory;
import com.oracle.bmc.http.internal.ResponseHelper;
import com.oracle.bmc.http.internal.RestClient;
import com.oracle.bmc.http.internal.WithHeaders;
import com.oracle.bmc.http.internal.WrappedInvocationBuilder;
import com.oracle.bmc.http.internal.WrappedWebTarget;
import com.oracle.bmc.util.internal.HttpUtils;
import java.util.List;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.Response;
import org.apache.commons.lang3.Validate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GetDatabaseUpgradeHistoryEntryConverter {
    private static final Logger LOG = LoggerFactory.getLogger(GetDatabaseUpgradeHistoryEntryConverter.class);
    private static final ResponseConversionFunctionFactory RESPONSE_CONVERSION_FACTORY = new ResponseConversionFunctionFactory();

    public static GetDatabaseUpgradeHistoryEntryRequest interceptRequest(GetDatabaseUpgradeHistoryEntryRequest request) {
        return request;
    }

    public static WrappedInvocationBuilder fromRequest(RestClient client, GetDatabaseUpgradeHistoryEntryRequest request) {
        Validate.notNull((Object)((Object)request), (String)"request instance is required", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)request.getDatabaseId(), (String)"databaseId must not be blank", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)request.getUpgradeHistoryEntryId(), (String)"upgradeHistoryEntryId must not be blank", (Object[])new Object[0]);
        WrappedWebTarget target = client.getBaseTarget().path("/20160918").path("databases").path(HttpUtils.encodePathSegment((String)request.getDatabaseId())).path("upgradeHistoryEntries").path(HttpUtils.encodePathSegment((String)request.getUpgradeHistoryEntryId()));
        WrappedInvocationBuilder ib = target.request();
        ib.accept(new String[]{"application/json"});
        if (request.getOpcRequestId() != null) {
            ib.header("opc-request-id", (Object)request.getOpcRequestId());
        }
        return ib;
    }

    public static Function<Response, GetDatabaseUpgradeHistoryEntryResponse> fromResponse() {
        Function<Response, GetDatabaseUpgradeHistoryEntryResponse> transformer = new Function<Response, GetDatabaseUpgradeHistoryEntryResponse>(){

            public GetDatabaseUpgradeHistoryEntryResponse apply(Response rawResponse) {
                LOG.trace("Transform function invoked for com.oracle.bmc.database.responses.GetDatabaseUpgradeHistoryEntryResponse");
                Function responseFn = RESPONSE_CONVERSION_FACTORY.create(DatabaseUpgradeHistoryEntry.class);
                WithHeaders response = (WithHeaders)responseFn.apply((Object)rawResponse);
                MultivaluedMap headers = response.getHeaders();
                GetDatabaseUpgradeHistoryEntryResponse.Builder builder = GetDatabaseUpgradeHistoryEntryResponse.builder().__httpStatusCode__(rawResponse.getStatus());
                builder.databaseUpgradeHistoryEntry((DatabaseUpgradeHistoryEntry)response.getItem());
                Optional opcRequestIdHeader = HeaderUtils.get((MultivaluedMap)headers, (String)"opc-request-id");
                if (opcRequestIdHeader.isPresent()) {
                    builder.opcRequestId((String)HeaderUtils.toValue((String)"opc-request-id", (String)((String)((List)opcRequestIdHeader.get()).get(0)), String.class));
                }
                GetDatabaseUpgradeHistoryEntryResponse responseWrapper = builder.build();
                ResponseHelper.closeResponseSilentlyIfNotBuffered((Response)rawResponse);
                return responseWrapper;
            }
        };
        return transformer;
    }
}

