/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.database.internal.http;

import com.google.common.base.Function;
import com.google.common.base.Optional;
import com.oracle.bmc.database.model.DbSystem;
import com.oracle.bmc.database.requests.GetDbSystemRequest;
import com.oracle.bmc.database.responses.GetDbSystemResponse;
import com.oracle.bmc.http.internal.HeaderUtils;
import com.oracle.bmc.http.internal.ResponseConversionFunctionFactory;
import com.oracle.bmc.http.internal.ResponseHelper;
import com.oracle.bmc.http.internal.RestClient;
import com.oracle.bmc.http.internal.WithHeaders;
import com.oracle.bmc.http.internal.WrappedInvocationBuilder;
import com.oracle.bmc.http.internal.WrappedWebTarget;
import com.oracle.bmc.util.internal.HttpUtils;
import java.util.List;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.Response;
import org.apache.commons.lang3.Validate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GetDbSystemConverter {
    private static final Logger LOG = LoggerFactory.getLogger(GetDbSystemConverter.class);
    private static final ResponseConversionFunctionFactory RESPONSE_CONVERSION_FACTORY = new ResponseConversionFunctionFactory();

    public static GetDbSystemRequest interceptRequest(GetDbSystemRequest request) {
        return request;
    }

    public static WrappedInvocationBuilder fromRequest(RestClient client, GetDbSystemRequest request) {
        Validate.notNull((Object)((Object)request), (String)"request instance is required", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)request.getDbSystemId(), (String)"dbSystemId must not be blank", (Object[])new Object[0]);
        WrappedWebTarget target = client.getBaseTarget().path("/20160918").path("dbSystems").path(HttpUtils.encodePathSegment((String)request.getDbSystemId()));
        WrappedInvocationBuilder ib = target.request();
        ib.accept(new String[]{"application/json"});
        return ib;
    }

    public static Function<Response, GetDbSystemResponse> fromResponse() {
        Function<Response, GetDbSystemResponse> transformer = new Function<Response, GetDbSystemResponse>(){

            public GetDbSystemResponse apply(Response rawResponse) {
                Optional opcRequestIdHeader;
                LOG.trace("Transform function invoked for com.oracle.bmc.database.responses.GetDbSystemResponse");
                Function responseFn = RESPONSE_CONVERSION_FACTORY.create(DbSystem.class);
                WithHeaders response = (WithHeaders)responseFn.apply((Object)rawResponse);
                MultivaluedMap headers = response.getHeaders();
                GetDbSystemResponse.Builder builder = GetDbSystemResponse.builder().__httpStatusCode__(rawResponse.getStatus());
                builder.dbSystem((DbSystem)response.getItem());
                Optional etagHeader = HeaderUtils.get((MultivaluedMap)headers, (String)"etag");
                if (etagHeader.isPresent()) {
                    builder.etag((String)HeaderUtils.toValue((String)"etag", (String)((String)((List)etagHeader.get()).get(0)), String.class));
                }
                if ((opcRequestIdHeader = HeaderUtils.get((MultivaluedMap)headers, (String)"opc-request-id")).isPresent()) {
                    builder.opcRequestId((String)HeaderUtils.toValue((String)"opc-request-id", (String)((String)((List)opcRequestIdHeader.get()).get(0)), String.class));
                }
                GetDbSystemResponse responseWrapper = builder.build();
                ResponseHelper.closeResponseSilentlyIfNotBuffered((Response)rawResponse);
                return responseWrapper;
            }
        };
        return transformer;
    }
}

