/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.database.internal.http;

import com.google.common.base.Function;
import com.google.common.base.Optional;
import com.oracle.bmc.database.model.ExternalDatabaseConnector;
import com.oracle.bmc.database.requests.GetExternalDatabaseConnectorRequest;
import com.oracle.bmc.database.responses.GetExternalDatabaseConnectorResponse;
import com.oracle.bmc.http.internal.HeaderUtils;
import com.oracle.bmc.http.internal.ResponseConversionFunctionFactory;
import com.oracle.bmc.http.internal.ResponseHelper;
import com.oracle.bmc.http.internal.RestClient;
import com.oracle.bmc.http.internal.WithHeaders;
import com.oracle.bmc.http.internal.WrappedInvocationBuilder;
import com.oracle.bmc.http.internal.WrappedWebTarget;
import com.oracle.bmc.util.internal.HttpUtils;
import java.util.List;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.Response;
import org.apache.commons.lang3.Validate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GetExternalDatabaseConnectorConverter {
    private static final Logger LOG = LoggerFactory.getLogger(GetExternalDatabaseConnectorConverter.class);
    private static final ResponseConversionFunctionFactory RESPONSE_CONVERSION_FACTORY = new ResponseConversionFunctionFactory();

    public static GetExternalDatabaseConnectorRequest interceptRequest(GetExternalDatabaseConnectorRequest request) {
        return request;
    }

    public static WrappedInvocationBuilder fromRequest(RestClient client, GetExternalDatabaseConnectorRequest request) {
        Validate.notNull((Object)((Object)request), (String)"request instance is required", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)request.getExternalDatabaseConnectorId(), (String)"externalDatabaseConnectorId must not be blank", (Object[])new Object[0]);
        WrappedWebTarget target = client.getBaseTarget().path("/20160918").path("externaldatabaseconnectors").path(HttpUtils.encodePathSegment((String)request.getExternalDatabaseConnectorId()));
        WrappedInvocationBuilder ib = target.request();
        ib.accept(new String[]{"application/json"});
        if (request.getOpcRequestId() != null) {
            ib.header("opc-request-id", (Object)request.getOpcRequestId());
        }
        return ib;
    }

    public static Function<Response, GetExternalDatabaseConnectorResponse> fromResponse() {
        Function<Response, GetExternalDatabaseConnectorResponse> transformer = new Function<Response, GetExternalDatabaseConnectorResponse>(){

            public GetExternalDatabaseConnectorResponse apply(Response rawResponse) {
                Optional opcRequestIdHeader;
                LOG.trace("Transform function invoked for com.oracle.bmc.database.responses.GetExternalDatabaseConnectorResponse");
                Function responseFn = RESPONSE_CONVERSION_FACTORY.create(ExternalDatabaseConnector.class);
                WithHeaders response = (WithHeaders)responseFn.apply((Object)rawResponse);
                MultivaluedMap headers = response.getHeaders();
                GetExternalDatabaseConnectorResponse.Builder builder = GetExternalDatabaseConnectorResponse.builder().__httpStatusCode__(rawResponse.getStatus());
                builder.externalDatabaseConnector((ExternalDatabaseConnector)response.getItem());
                Optional etagHeader = HeaderUtils.get((MultivaluedMap)headers, (String)"etag");
                if (etagHeader.isPresent()) {
                    builder.etag((String)HeaderUtils.toValue((String)"etag", (String)((String)((List)etagHeader.get()).get(0)), String.class));
                }
                if ((opcRequestIdHeader = HeaderUtils.get((MultivaluedMap)headers, (String)"opc-request-id")).isPresent()) {
                    builder.opcRequestId((String)HeaderUtils.toValue((String)"opc-request-id", (String)((String)((List)opcRequestIdHeader.get()).get(0)), String.class));
                }
                GetExternalDatabaseConnectorResponse responseWrapper = builder.build();
                ResponseHelper.closeResponseSilentlyIfNotBuffered((Response)rawResponse);
                return responseWrapper;
            }
        };
        return transformer;
    }
}

