/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.database.requests;

import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import com.oracle.bmc.util.internal.Consumer;
import java.beans.ConstructorProperties;
import javax.ws.rs.client.Invocation;

public class DeleteDatabaseRequest
extends BmcRequest<Void> {
    private String databaseId;
    private String ifMatch;
    private Boolean performFinalBackup;
    private String opcRequestId;

    @ConstructorProperties(value={"databaseId", "ifMatch", "performFinalBackup", "opcRequestId"})
    DeleteDatabaseRequest(String databaseId, String ifMatch, Boolean performFinalBackup, String opcRequestId) {
        this.databaseId = databaseId;
        this.ifMatch = ifMatch;
        this.performFinalBackup = performFinalBackup;
        this.opcRequestId = opcRequestId;
    }

    public static Builder builder() {
        return new Builder();
    }

    public String getDatabaseId() {
        return this.databaseId;
    }

    public String getIfMatch() {
        return this.ifMatch;
    }

    public Boolean getPerformFinalBackup() {
        return this.performFinalBackup;
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    public static class Builder
    implements BmcRequest.Builder<DeleteDatabaseRequest, Void> {
        private String databaseId;
        private String ifMatch;
        private Boolean performFinalBackup;
        private String opcRequestId;
        private Consumer<Invocation.Builder> invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;

        public Builder invocationCallback(Consumer<Invocation.Builder> invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(DeleteDatabaseRequest o) {
            this.databaseId(o.getDatabaseId());
            this.ifMatch(o.getIfMatch());
            this.performFinalBackup(o.getPerformFinalBackup());
            this.opcRequestId(o.getOpcRequestId());
            this.invocationCallback((Consumer<Invocation.Builder>)o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public DeleteDatabaseRequest build() {
            DeleteDatabaseRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        Builder() {
        }

        public Builder databaseId(String databaseId) {
            this.databaseId = databaseId;
            return this;
        }

        public Builder ifMatch(String ifMatch) {
            this.ifMatch = ifMatch;
            return this;
        }

        public Builder performFinalBackup(Boolean performFinalBackup) {
            this.performFinalBackup = performFinalBackup;
            return this;
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public DeleteDatabaseRequest buildWithoutInvocationCallback() {
            return new DeleteDatabaseRequest(this.databaseId, this.ifMatch, this.performFinalBackup, this.opcRequestId);
        }

        public String toString() {
            return "DeleteDatabaseRequest.Builder(databaseId=" + this.databaseId + ", ifMatch=" + this.ifMatch + ", performFinalBackup=" + this.performFinalBackup + ", opcRequestId=" + this.opcRequestId + ")";
        }
    }
}

