/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.database.requests;

import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import com.oracle.bmc.util.internal.Consumer;
import java.beans.ConstructorProperties;
import javax.ws.rs.client.Invocation;

public class GetConsoleConnectionRequest
extends BmcRequest<Void> {
    private String dbNodeId;
    private String consoleConnectionId;

    @ConstructorProperties(value={"dbNodeId", "consoleConnectionId"})
    GetConsoleConnectionRequest(String dbNodeId, String consoleConnectionId) {
        this.dbNodeId = dbNodeId;
        this.consoleConnectionId = consoleConnectionId;
    }

    public static Builder builder() {
        return new Builder();
    }

    public String getDbNodeId() {
        return this.dbNodeId;
    }

    public String getConsoleConnectionId() {
        return this.consoleConnectionId;
    }

    public static class Builder
    implements BmcRequest.Builder<GetConsoleConnectionRequest, Void> {
        private String dbNodeId;
        private String consoleConnectionId;
        private Consumer<Invocation.Builder> invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;

        public Builder invocationCallback(Consumer<Invocation.Builder> invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(GetConsoleConnectionRequest o) {
            this.dbNodeId(o.getDbNodeId());
            this.consoleConnectionId(o.getConsoleConnectionId());
            this.invocationCallback((Consumer<Invocation.Builder>)o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public GetConsoleConnectionRequest build() {
            GetConsoleConnectionRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        Builder() {
        }

        public Builder dbNodeId(String dbNodeId) {
            this.dbNodeId = dbNodeId;
            return this;
        }

        public Builder consoleConnectionId(String consoleConnectionId) {
            this.consoleConnectionId = consoleConnectionId;
            return this;
        }

        public GetConsoleConnectionRequest buildWithoutInvocationCallback() {
            return new GetConsoleConnectionRequest(this.dbNodeId, this.consoleConnectionId);
        }

        public String toString() {
            return "GetConsoleConnectionRequest.Builder(dbNodeId=" + this.dbNodeId + ", consoleConnectionId=" + this.consoleConnectionId + ")";
        }
    }
}

