/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.database.requests;

import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import com.oracle.bmc.util.internal.Consumer;
import java.beans.ConstructorProperties;
import javax.ws.rs.client.Invocation;

public class GetDbHomePatchRequest
extends BmcRequest<Void> {
    private String dbHomeId;
    private String patchId;

    @ConstructorProperties(value={"dbHomeId", "patchId"})
    GetDbHomePatchRequest(String dbHomeId, String patchId) {
        this.dbHomeId = dbHomeId;
        this.patchId = patchId;
    }

    public static Builder builder() {
        return new Builder();
    }

    public String getDbHomeId() {
        return this.dbHomeId;
    }

    public String getPatchId() {
        return this.patchId;
    }

    public static class Builder
    implements BmcRequest.Builder<GetDbHomePatchRequest, Void> {
        private String dbHomeId;
        private String patchId;
        private Consumer<Invocation.Builder> invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;

        public Builder invocationCallback(Consumer<Invocation.Builder> invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(GetDbHomePatchRequest o) {
            this.dbHomeId(o.getDbHomeId());
            this.patchId(o.getPatchId());
            this.invocationCallback((Consumer<Invocation.Builder>)o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public GetDbHomePatchRequest build() {
            GetDbHomePatchRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        Builder() {
        }

        public Builder dbHomeId(String dbHomeId) {
            this.dbHomeId = dbHomeId;
            return this;
        }

        public Builder patchId(String patchId) {
            this.patchId = patchId;
            return this;
        }

        public GetDbHomePatchRequest buildWithoutInvocationCallback() {
            return new GetDbHomePatchRequest(this.dbHomeId, this.patchId);
        }

        public String toString() {
            return "GetDbHomePatchRequest.Builder(dbHomeId=" + this.dbHomeId + ", patchId=" + this.patchId + ")";
        }
    }
}

