/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.database.requests;

import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import com.oracle.bmc.util.internal.Consumer;
import java.beans.ConstructorProperties;
import javax.ws.rs.client.Invocation;

public class GetDbSystemRequest
extends BmcRequest<Void> {
    private String dbSystemId;

    @ConstructorProperties(value={"dbSystemId"})
    GetDbSystemRequest(String dbSystemId) {
        this.dbSystemId = dbSystemId;
    }

    public static Builder builder() {
        return new Builder();
    }

    public String getDbSystemId() {
        return this.dbSystemId;
    }

    public static class Builder
    implements BmcRequest.Builder<GetDbSystemRequest, Void> {
        private String dbSystemId;
        private Consumer<Invocation.Builder> invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;

        public Builder invocationCallback(Consumer<Invocation.Builder> invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(GetDbSystemRequest o) {
            this.dbSystemId(o.getDbSystemId());
            this.invocationCallback((Consumer<Invocation.Builder>)o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public GetDbSystemRequest build() {
            GetDbSystemRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        Builder() {
        }

        public Builder dbSystemId(String dbSystemId) {
            this.dbSystemId = dbSystemId;
            return this;
        }

        public GetDbSystemRequest buildWithoutInvocationCallback() {
            return new GetDbSystemRequest(this.dbSystemId);
        }

        public String toString() {
            return "GetDbSystemRequest.Builder(dbSystemId=" + this.dbSystemId + ")";
        }
    }
}

