/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.database.requests;

import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import com.oracle.bmc.util.internal.Consumer;
import java.beans.ConstructorProperties;
import javax.ws.rs.client.Invocation;

public class GetKeyStoreRequest
extends BmcRequest<Void> {
    private String keyStoreId;
    private String opcRequestId;

    @ConstructorProperties(value={"keyStoreId", "opcRequestId"})
    GetKeyStoreRequest(String keyStoreId, String opcRequestId) {
        this.keyStoreId = keyStoreId;
        this.opcRequestId = opcRequestId;
    }

    public static Builder builder() {
        return new Builder();
    }

    public String getKeyStoreId() {
        return this.keyStoreId;
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    public static class Builder
    implements BmcRequest.Builder<GetKeyStoreRequest, Void> {
        private String keyStoreId;
        private String opcRequestId;
        private Consumer<Invocation.Builder> invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;

        public Builder invocationCallback(Consumer<Invocation.Builder> invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(GetKeyStoreRequest o) {
            this.keyStoreId(o.getKeyStoreId());
            this.opcRequestId(o.getOpcRequestId());
            this.invocationCallback((Consumer<Invocation.Builder>)o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public GetKeyStoreRequest build() {
            GetKeyStoreRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        Builder() {
        }

        public Builder keyStoreId(String keyStoreId) {
            this.keyStoreId = keyStoreId;
            return this;
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public GetKeyStoreRequest buildWithoutInvocationCallback() {
            return new GetKeyStoreRequest(this.keyStoreId, this.opcRequestId);
        }

        public String toString() {
            return "GetKeyStoreRequest.Builder(keyStoreId=" + this.keyStoreId + ", opcRequestId=" + this.opcRequestId + ")";
        }
    }
}

