/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.database.requests;

import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import com.oracle.bmc.util.internal.Consumer;
import java.beans.ConstructorProperties;
import javax.ws.rs.client.Invocation;

public class ListAutonomousDatabaseDataguardAssociationsRequest
extends BmcRequest<Void> {
    private String autonomousDatabaseId;
    private Integer limit;
    private String page;

    @ConstructorProperties(value={"autonomousDatabaseId", "limit", "page"})
    ListAutonomousDatabaseDataguardAssociationsRequest(String autonomousDatabaseId, Integer limit, String page) {
        this.autonomousDatabaseId = autonomousDatabaseId;
        this.limit = limit;
        this.page = page;
    }

    public static Builder builder() {
        return new Builder();
    }

    public String getAutonomousDatabaseId() {
        return this.autonomousDatabaseId;
    }

    public Integer getLimit() {
        return this.limit;
    }

    public String getPage() {
        return this.page;
    }

    public static class Builder
    implements BmcRequest.Builder<ListAutonomousDatabaseDataguardAssociationsRequest, Void> {
        private String autonomousDatabaseId;
        private Integer limit;
        private String page;
        private Consumer<Invocation.Builder> invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;

        public Builder invocationCallback(Consumer<Invocation.Builder> invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(ListAutonomousDatabaseDataguardAssociationsRequest o) {
            this.autonomousDatabaseId(o.getAutonomousDatabaseId());
            this.limit(o.getLimit());
            this.page(o.getPage());
            this.invocationCallback((Consumer<Invocation.Builder>)o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public ListAutonomousDatabaseDataguardAssociationsRequest build() {
            ListAutonomousDatabaseDataguardAssociationsRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        Builder() {
        }

        public Builder autonomousDatabaseId(String autonomousDatabaseId) {
            this.autonomousDatabaseId = autonomousDatabaseId;
            return this;
        }

        public Builder limit(Integer limit) {
            this.limit = limit;
            return this;
        }

        public Builder page(String page) {
            this.page = page;
            return this;
        }

        public ListAutonomousDatabaseDataguardAssociationsRequest buildWithoutInvocationCallback() {
            return new ListAutonomousDatabaseDataguardAssociationsRequest(this.autonomousDatabaseId, this.limit, this.page);
        }

        public String toString() {
            return "ListAutonomousDatabaseDataguardAssociationsRequest.Builder(autonomousDatabaseId=" + this.autonomousDatabaseId + ", limit=" + this.limit + ", page=" + this.page + ")";
        }
    }
}

