/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.database.requests;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import com.oracle.bmc.util.internal.Consumer;
import java.beans.ConstructorProperties;
import java.util.HashMap;
import java.util.Map;
import javax.ws.rs.client.Invocation;

public class ListCloudVmClusterUpdateHistoryEntriesRequest
extends BmcRequest<Void> {
    private String cloudVmClusterId;
    private UpdateType updateType;
    private Integer limit;
    private String page;
    private String opcRequestId;

    @ConstructorProperties(value={"cloudVmClusterId", "updateType", "limit", "page", "opcRequestId"})
    ListCloudVmClusterUpdateHistoryEntriesRequest(String cloudVmClusterId, UpdateType updateType, Integer limit, String page, String opcRequestId) {
        this.cloudVmClusterId = cloudVmClusterId;
        this.updateType = updateType;
        this.limit = limit;
        this.page = page;
        this.opcRequestId = opcRequestId;
    }

    public static Builder builder() {
        return new Builder();
    }

    public String getCloudVmClusterId() {
        return this.cloudVmClusterId;
    }

    public UpdateType getUpdateType() {
        return this.updateType;
    }

    public Integer getLimit() {
        return this.limit;
    }

    public String getPage() {
        return this.page;
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    public static class Builder
    implements BmcRequest.Builder<ListCloudVmClusterUpdateHistoryEntriesRequest, Void> {
        private String cloudVmClusterId;
        private UpdateType updateType;
        private Integer limit;
        private String page;
        private String opcRequestId;
        private Consumer<Invocation.Builder> invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;

        public Builder invocationCallback(Consumer<Invocation.Builder> invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(ListCloudVmClusterUpdateHistoryEntriesRequest o) {
            this.cloudVmClusterId(o.getCloudVmClusterId());
            this.updateType(o.getUpdateType());
            this.limit(o.getLimit());
            this.page(o.getPage());
            this.opcRequestId(o.getOpcRequestId());
            this.invocationCallback((Consumer<Invocation.Builder>)o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public ListCloudVmClusterUpdateHistoryEntriesRequest build() {
            ListCloudVmClusterUpdateHistoryEntriesRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        Builder() {
        }

        public Builder cloudVmClusterId(String cloudVmClusterId) {
            this.cloudVmClusterId = cloudVmClusterId;
            return this;
        }

        public Builder updateType(UpdateType updateType) {
            this.updateType = updateType;
            return this;
        }

        public Builder limit(Integer limit) {
            this.limit = limit;
            return this;
        }

        public Builder page(String page) {
            this.page = page;
            return this;
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public ListCloudVmClusterUpdateHistoryEntriesRequest buildWithoutInvocationCallback() {
            return new ListCloudVmClusterUpdateHistoryEntriesRequest(this.cloudVmClusterId, this.updateType, this.limit, this.page, this.opcRequestId);
        }

        public String toString() {
            return "ListCloudVmClusterUpdateHistoryEntriesRequest.Builder(cloudVmClusterId=" + this.cloudVmClusterId + ", updateType=" + (Object)((Object)this.updateType) + ", limit=" + this.limit + ", page=" + this.page + ", opcRequestId=" + this.opcRequestId + ")";
        }
    }

    public static enum UpdateType {
        GiUpgrade("GI_UPGRADE"),
        GiPatch("GI_PATCH"),
        OsUpdate("OS_UPDATE");

        private final String value;
        private static Map<String, UpdateType> map;

        private UpdateType(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static UpdateType create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            throw new IllegalArgumentException("Invalid UpdateType: " + key);
        }

        static {
            map = new HashMap<String, UpdateType>();
            for (UpdateType v : UpdateType.values()) {
                map.put(v.getValue(), v);
            }
        }
    }
}

