/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.database.requests;

import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import com.oracle.bmc.util.internal.Consumer;
import java.beans.ConstructorProperties;
import javax.ws.rs.client.Invocation;

public class ListContainerDatabasePatchesRequest
extends BmcRequest<Void> {
    private String autonomousContainerDatabaseId;
    private String compartmentId;
    private Integer limit;
    private String page;

    @ConstructorProperties(value={"autonomousContainerDatabaseId", "compartmentId", "limit", "page"})
    ListContainerDatabasePatchesRequest(String autonomousContainerDatabaseId, String compartmentId, Integer limit, String page) {
        this.autonomousContainerDatabaseId = autonomousContainerDatabaseId;
        this.compartmentId = compartmentId;
        this.limit = limit;
        this.page = page;
    }

    public static Builder builder() {
        return new Builder();
    }

    public String getAutonomousContainerDatabaseId() {
        return this.autonomousContainerDatabaseId;
    }

    public String getCompartmentId() {
        return this.compartmentId;
    }

    public Integer getLimit() {
        return this.limit;
    }

    public String getPage() {
        return this.page;
    }

    public static class Builder
    implements BmcRequest.Builder<ListContainerDatabasePatchesRequest, Void> {
        private String autonomousContainerDatabaseId;
        private String compartmentId;
        private Integer limit;
        private String page;
        private Consumer<Invocation.Builder> invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;

        public Builder invocationCallback(Consumer<Invocation.Builder> invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(ListContainerDatabasePatchesRequest o) {
            this.autonomousContainerDatabaseId(o.getAutonomousContainerDatabaseId());
            this.compartmentId(o.getCompartmentId());
            this.limit(o.getLimit());
            this.page(o.getPage());
            this.invocationCallback((Consumer<Invocation.Builder>)o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public ListContainerDatabasePatchesRequest build() {
            ListContainerDatabasePatchesRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        Builder() {
        }

        public Builder autonomousContainerDatabaseId(String autonomousContainerDatabaseId) {
            this.autonomousContainerDatabaseId = autonomousContainerDatabaseId;
            return this;
        }

        public Builder compartmentId(String compartmentId) {
            this.compartmentId = compartmentId;
            return this;
        }

        public Builder limit(Integer limit) {
            this.limit = limit;
            return this;
        }

        public Builder page(String page) {
            this.page = page;
            return this;
        }

        public ListContainerDatabasePatchesRequest buildWithoutInvocationCallback() {
            return new ListContainerDatabasePatchesRequest(this.autonomousContainerDatabaseId, this.compartmentId, this.limit, this.page);
        }

        public String toString() {
            return "ListContainerDatabasePatchesRequest.Builder(autonomousContainerDatabaseId=" + this.autonomousContainerDatabaseId + ", compartmentId=" + this.compartmentId + ", limit=" + this.limit + ", page=" + this.page + ")";
        }
    }
}

