/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.database.requests;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import com.oracle.bmc.database.model.DatabaseSoftwareImageSummary;
import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import com.oracle.bmc.util.internal.Consumer;
import java.beans.ConstructorProperties;
import java.util.HashMap;
import java.util.Map;
import javax.ws.rs.client.Invocation;

public class ListDatabaseSoftwareImagesRequest
extends BmcRequest<Void> {
    private String compartmentId;
    private Integer limit;
    private String page;
    private SortBy sortBy;
    private SortOrder sortOrder;
    private DatabaseSoftwareImageSummary.LifecycleState lifecycleState;
    private String displayName;
    private DatabaseSoftwareImageSummary.ImageType imageType;
    private DatabaseSoftwareImageSummary.ImageShapeFamily imageShapeFamily;
    private Boolean isUpgradeSupported;

    @ConstructorProperties(value={"compartmentId", "limit", "page", "sortBy", "sortOrder", "lifecycleState", "displayName", "imageType", "imageShapeFamily", "isUpgradeSupported"})
    ListDatabaseSoftwareImagesRequest(String compartmentId, Integer limit, String page, SortBy sortBy, SortOrder sortOrder, DatabaseSoftwareImageSummary.LifecycleState lifecycleState, String displayName, DatabaseSoftwareImageSummary.ImageType imageType, DatabaseSoftwareImageSummary.ImageShapeFamily imageShapeFamily, Boolean isUpgradeSupported) {
        this.compartmentId = compartmentId;
        this.limit = limit;
        this.page = page;
        this.sortBy = sortBy;
        this.sortOrder = sortOrder;
        this.lifecycleState = lifecycleState;
        this.displayName = displayName;
        this.imageType = imageType;
        this.imageShapeFamily = imageShapeFamily;
        this.isUpgradeSupported = isUpgradeSupported;
    }

    public static Builder builder() {
        return new Builder();
    }

    public String getCompartmentId() {
        return this.compartmentId;
    }

    public Integer getLimit() {
        return this.limit;
    }

    public String getPage() {
        return this.page;
    }

    public SortBy getSortBy() {
        return this.sortBy;
    }

    public SortOrder getSortOrder() {
        return this.sortOrder;
    }

    public DatabaseSoftwareImageSummary.LifecycleState getLifecycleState() {
        return this.lifecycleState;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public DatabaseSoftwareImageSummary.ImageType getImageType() {
        return this.imageType;
    }

    public DatabaseSoftwareImageSummary.ImageShapeFamily getImageShapeFamily() {
        return this.imageShapeFamily;
    }

    public Boolean getIsUpgradeSupported() {
        return this.isUpgradeSupported;
    }

    public static class Builder
    implements BmcRequest.Builder<ListDatabaseSoftwareImagesRequest, Void> {
        private String compartmentId;
        private Integer limit;
        private String page;
        private SortBy sortBy;
        private SortOrder sortOrder;
        private DatabaseSoftwareImageSummary.LifecycleState lifecycleState;
        private String displayName;
        private DatabaseSoftwareImageSummary.ImageType imageType;
        private DatabaseSoftwareImageSummary.ImageShapeFamily imageShapeFamily;
        private Boolean isUpgradeSupported;
        private Consumer<Invocation.Builder> invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;

        public Builder invocationCallback(Consumer<Invocation.Builder> invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(ListDatabaseSoftwareImagesRequest o) {
            this.compartmentId(o.getCompartmentId());
            this.limit(o.getLimit());
            this.page(o.getPage());
            this.sortBy(o.getSortBy());
            this.sortOrder(o.getSortOrder());
            this.lifecycleState(o.getLifecycleState());
            this.displayName(o.getDisplayName());
            this.imageType(o.getImageType());
            this.imageShapeFamily(o.getImageShapeFamily());
            this.isUpgradeSupported(o.getIsUpgradeSupported());
            this.invocationCallback((Consumer<Invocation.Builder>)o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public ListDatabaseSoftwareImagesRequest build() {
            ListDatabaseSoftwareImagesRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        Builder() {
        }

        public Builder compartmentId(String compartmentId) {
            this.compartmentId = compartmentId;
            return this;
        }

        public Builder limit(Integer limit) {
            this.limit = limit;
            return this;
        }

        public Builder page(String page) {
            this.page = page;
            return this;
        }

        public Builder sortBy(SortBy sortBy) {
            this.sortBy = sortBy;
            return this;
        }

        public Builder sortOrder(SortOrder sortOrder) {
            this.sortOrder = sortOrder;
            return this;
        }

        public Builder lifecycleState(DatabaseSoftwareImageSummary.LifecycleState lifecycleState) {
            this.lifecycleState = lifecycleState;
            return this;
        }

        public Builder displayName(String displayName) {
            this.displayName = displayName;
            return this;
        }

        public Builder imageType(DatabaseSoftwareImageSummary.ImageType imageType) {
            this.imageType = imageType;
            return this;
        }

        public Builder imageShapeFamily(DatabaseSoftwareImageSummary.ImageShapeFamily imageShapeFamily) {
            this.imageShapeFamily = imageShapeFamily;
            return this;
        }

        public Builder isUpgradeSupported(Boolean isUpgradeSupported) {
            this.isUpgradeSupported = isUpgradeSupported;
            return this;
        }

        public ListDatabaseSoftwareImagesRequest buildWithoutInvocationCallback() {
            return new ListDatabaseSoftwareImagesRequest(this.compartmentId, this.limit, this.page, this.sortBy, this.sortOrder, this.lifecycleState, this.displayName, this.imageType, this.imageShapeFamily, this.isUpgradeSupported);
        }

        public String toString() {
            return "ListDatabaseSoftwareImagesRequest.Builder(compartmentId=" + this.compartmentId + ", limit=" + this.limit + ", page=" + this.page + ", sortBy=" + (Object)((Object)this.sortBy) + ", sortOrder=" + (Object)((Object)this.sortOrder) + ", lifecycleState=" + (Object)((Object)this.lifecycleState) + ", displayName=" + this.displayName + ", imageType=" + (Object)((Object)this.imageType) + ", imageShapeFamily=" + (Object)((Object)this.imageShapeFamily) + ", isUpgradeSupported=" + this.isUpgradeSupported + ")";
        }
    }

    public static enum SortOrder {
        Asc("ASC"),
        Desc("DESC");

        private final String value;
        private static Map<String, SortOrder> map;

        private SortOrder(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static SortOrder create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            throw new IllegalArgumentException("Invalid SortOrder: " + key);
        }

        static {
            map = new HashMap<String, SortOrder>();
            for (SortOrder v : SortOrder.values()) {
                map.put(v.getValue(), v);
            }
        }
    }

    public static enum SortBy {
        Timecreated("TIMECREATED"),
        Displayname("DISPLAYNAME");

        private final String value;
        private static Map<String, SortBy> map;

        private SortBy(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static SortBy create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            throw new IllegalArgumentException("Invalid SortBy: " + key);
        }

        static {
            map = new HashMap<String, SortBy>();
            for (SortBy v : SortBy.values()) {
                map.put(v.getValue(), v);
            }
        }
    }
}

