/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.database.requests;

import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import com.oracle.bmc.util.internal.Consumer;
import java.beans.ConstructorProperties;
import javax.ws.rs.client.Invocation;

public class ListDbSystemPatchesRequest
extends BmcRequest<Void> {
    private String dbSystemId;
    private Integer limit;
    private String page;

    @ConstructorProperties(value={"dbSystemId", "limit", "page"})
    ListDbSystemPatchesRequest(String dbSystemId, Integer limit, String page) {
        this.dbSystemId = dbSystemId;
        this.limit = limit;
        this.page = page;
    }

    public static Builder builder() {
        return new Builder();
    }

    public String getDbSystemId() {
        return this.dbSystemId;
    }

    public Integer getLimit() {
        return this.limit;
    }

    public String getPage() {
        return this.page;
    }

    public static class Builder
    implements BmcRequest.Builder<ListDbSystemPatchesRequest, Void> {
        private String dbSystemId;
        private Integer limit;
        private String page;
        private Consumer<Invocation.Builder> invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;

        public Builder invocationCallback(Consumer<Invocation.Builder> invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(ListDbSystemPatchesRequest o) {
            this.dbSystemId(o.getDbSystemId());
            this.limit(o.getLimit());
            this.page(o.getPage());
            this.invocationCallback((Consumer<Invocation.Builder>)o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public ListDbSystemPatchesRequest build() {
            ListDbSystemPatchesRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        Builder() {
        }

        public Builder dbSystemId(String dbSystemId) {
            this.dbSystemId = dbSystemId;
            return this;
        }

        public Builder limit(Integer limit) {
            this.limit = limit;
            return this;
        }

        public Builder page(String page) {
            this.page = page;
            return this;
        }

        public ListDbSystemPatchesRequest buildWithoutInvocationCallback() {
            return new ListDbSystemPatchesRequest(this.dbSystemId, this.limit, this.page);
        }

        public String toString() {
            return "ListDbSystemPatchesRequest.Builder(dbSystemId=" + this.dbSystemId + ", limit=" + this.limit + ", page=" + this.page + ")";
        }
    }
}

