/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.database.requests;

import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import com.oracle.bmc.util.internal.Consumer;
import java.beans.ConstructorProperties;
import javax.ws.rs.client.Invocation;

public class RestartAutonomousDatabaseRequest
extends BmcRequest<Void> {
    private String autonomousDatabaseId;
    private String ifMatch;

    @ConstructorProperties(value={"autonomousDatabaseId", "ifMatch"})
    RestartAutonomousDatabaseRequest(String autonomousDatabaseId, String ifMatch) {
        this.autonomousDatabaseId = autonomousDatabaseId;
        this.ifMatch = ifMatch;
    }

    public static Builder builder() {
        return new Builder();
    }

    public String getAutonomousDatabaseId() {
        return this.autonomousDatabaseId;
    }

    public String getIfMatch() {
        return this.ifMatch;
    }

    public static class Builder
    implements BmcRequest.Builder<RestartAutonomousDatabaseRequest, Void> {
        private String autonomousDatabaseId;
        private String ifMatch;
        private Consumer<Invocation.Builder> invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;

        public Builder invocationCallback(Consumer<Invocation.Builder> invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(RestartAutonomousDatabaseRequest o) {
            this.autonomousDatabaseId(o.getAutonomousDatabaseId());
            this.ifMatch(o.getIfMatch());
            this.invocationCallback((Consumer<Invocation.Builder>)o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public RestartAutonomousDatabaseRequest build() {
            RestartAutonomousDatabaseRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        Builder() {
        }

        public Builder autonomousDatabaseId(String autonomousDatabaseId) {
            this.autonomousDatabaseId = autonomousDatabaseId;
            return this;
        }

        public Builder ifMatch(String ifMatch) {
            this.ifMatch = ifMatch;
            return this;
        }

        public RestartAutonomousDatabaseRequest buildWithoutInvocationCallback() {
            return new RestartAutonomousDatabaseRequest(this.autonomousDatabaseId, this.ifMatch);
        }

        public String toString() {
            return "RestartAutonomousDatabaseRequest.Builder(autonomousDatabaseId=" + this.autonomousDatabaseId + ", ifMatch=" + this.ifMatch + ")";
        }
    }
}

