/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.databasemanagement.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.databasemanagement.model.DatabaseSubType;
import com.oracle.bmc.databasemanagement.model.Job;
import com.oracle.bmc.databasemanagement.model.JobDatabase;
import com.oracle.bmc.databasemanagement.model.JobExecutionResultLocation;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@JsonDeserialize(builder=Builder.class)
@JsonTypeInfo(use=JsonTypeInfo.Id.NAME, include=JsonTypeInfo.As.PROPERTY, property="jobType")
@JsonFilter(value="explicitlySetFilter")
public final class SqlJob
extends Job {
    @JsonProperty(value="sqlType")
    private final SqlType sqlType;
    @JsonProperty(value="sqlText")
    private final String sqlText;
    @JsonProperty(value="operationType")
    private final OperationType operationType;
    @JsonProperty(value="userName")
    private final String userName;
    @JsonProperty(value="role")
    private final Role role;
    @JsonIgnore
    private final Set<String> __explicitlySet__ = new HashSet<String>();

    public static Builder builder() {
        return new Builder();
    }

    @Deprecated
    public SqlJob(String id, String compartmentId, String name, String description, String managedDatabaseGroupId, String managedDatabaseId, List<JobDatabase> managedDatabasesDetails, DatabaseSubType databaseSubType, Job.ScheduleType scheduleType, Job.LifecycleState lifecycleState, String timeout, JobExecutionResultLocation resultLocation, String submissionErrorMessage, Date timeCreated, Date timeUpdated, SqlType sqlType, String sqlText, OperationType operationType, String userName, Role role) {
        super(id, compartmentId, name, description, managedDatabaseGroupId, managedDatabaseId, managedDatabasesDetails, databaseSubType, scheduleType, lifecycleState, timeout, resultLocation, submissionErrorMessage, timeCreated, timeUpdated);
        this.sqlType = sqlType;
        this.sqlText = sqlText;
        this.operationType = operationType;
        this.userName = userName;
        this.role = role;
    }

    public Builder toBuilder() {
        return new Builder().sqlType(this.sqlType).sqlText(this.sqlText).operationType(this.operationType).userName(this.userName).role(this.role);
    }

    public SqlType getSqlType() {
        return this.sqlType;
    }

    public String getSqlText() {
        return this.sqlText;
    }

    public OperationType getOperationType() {
        return this.operationType;
    }

    public String getUserName() {
        return this.userName;
    }

    public Role getRole() {
        return this.role;
    }

    public Set<String> get__explicitlySet__() {
        return this.__explicitlySet__;
    }

    @Override
    public String toString() {
        return "SqlJob(super=" + super.toString() + ", sqlType=" + (Object)((Object)this.getSqlType()) + ", sqlText=" + this.getSqlText() + ", operationType=" + (Object)((Object)this.getOperationType()) + ", userName=" + this.getUserName() + ", role=" + (Object)((Object)this.getRole()) + ", __explicitlySet__=" + this.get__explicitlySet__() + ")";
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof SqlJob)) {
            return false;
        }
        SqlJob other = (SqlJob)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        SqlType this$sqlType = this.getSqlType();
        SqlType other$sqlType = other.getSqlType();
        if (this$sqlType == null ? other$sqlType != null : !((Object)((Object)this$sqlType)).equals((Object)other$sqlType)) {
            return false;
        }
        String this$sqlText = this.getSqlText();
        String other$sqlText = other.getSqlText();
        if (this$sqlText == null ? other$sqlText != null : !this$sqlText.equals(other$sqlText)) {
            return false;
        }
        OperationType this$operationType = this.getOperationType();
        OperationType other$operationType = other.getOperationType();
        if (this$operationType == null ? other$operationType != null : !((Object)((Object)this$operationType)).equals((Object)other$operationType)) {
            return false;
        }
        String this$userName = this.getUserName();
        String other$userName = other.getUserName();
        if (this$userName == null ? other$userName != null : !this$userName.equals(other$userName)) {
            return false;
        }
        Role this$role = this.getRole();
        Role other$role = other.getRole();
        if (this$role == null ? other$role != null : !((Object)((Object)this$role)).equals((Object)other$role)) {
            return false;
        }
        Set<String> this$__explicitlySet__ = this.get__explicitlySet__();
        Set<String> other$__explicitlySet__ = other.get__explicitlySet__();
        return !(this$__explicitlySet__ == null ? other$__explicitlySet__ != null : !((Object)this$__explicitlySet__).equals(other$__explicitlySet__));
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof SqlJob;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        SqlType $sqlType = this.getSqlType();
        result = result * 59 + ($sqlType == null ? 43 : ((Object)((Object)$sqlType)).hashCode());
        String $sqlText = this.getSqlText();
        result = result * 59 + ($sqlText == null ? 43 : $sqlText.hashCode());
        OperationType $operationType = this.getOperationType();
        result = result * 59 + ($operationType == null ? 43 : ((Object)((Object)$operationType)).hashCode());
        String $userName = this.getUserName();
        result = result * 59 + ($userName == null ? 43 : $userName.hashCode());
        Role $role = this.getRole();
        result = result * 59 + ($role == null ? 43 : ((Object)((Object)$role)).hashCode());
        Set<String> $__explicitlySet__ = this.get__explicitlySet__();
        result = result * 59 + ($__explicitlySet__ == null ? 43 : ((Object)$__explicitlySet__).hashCode());
        return result;
    }

    public static enum Role {
        Normal("NORMAL"),
        Sysdba("SYSDBA"),
        UnknownEnumValue(null);

        private static final Logger LOG;
        private final String value;
        private static Map<String, Role> map;

        private Role(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static Role create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            LOG.warn("Received unknown value '{}' for enum 'Role', returning UnknownEnumValue", (Object)key);
            return UnknownEnumValue;
        }

        static {
            LOG = LoggerFactory.getLogger(Role.class);
            map = new HashMap<String, Role>();
            for (Role v : Role.values()) {
                if (v == UnknownEnumValue) continue;
                map.put(v.getValue(), v);
            }
        }
    }

    public static enum OperationType {
        ExecuteSql("EXECUTE_SQL"),
        UnknownEnumValue(null);

        private static final Logger LOG;
        private final String value;
        private static Map<String, OperationType> map;

        private OperationType(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static OperationType create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            LOG.warn("Received unknown value '{}' for enum 'OperationType', returning UnknownEnumValue", (Object)key);
            return UnknownEnumValue;
        }

        static {
            LOG = LoggerFactory.getLogger(OperationType.class);
            map = new HashMap<String, OperationType>();
            for (OperationType v : OperationType.values()) {
                if (v == UnknownEnumValue) continue;
                map.put(v.getValue(), v);
            }
        }
    }

    public static enum SqlType {
        Query("QUERY"),
        Dml("DML"),
        Ddl("DDL"),
        Plsql("PLSQL"),
        UnknownEnumValue(null);

        private static final Logger LOG;
        private final String value;
        private static Map<String, SqlType> map;

        private SqlType(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static SqlType create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            LOG.warn("Received unknown value '{}' for enum 'SqlType', returning UnknownEnumValue", (Object)key);
            return UnknownEnumValue;
        }

        static {
            LOG = LoggerFactory.getLogger(SqlType.class);
            map = new HashMap<String, SqlType>();
            for (SqlType v : SqlType.values()) {
                if (v == UnknownEnumValue) continue;
                map.put(v.getValue(), v);
            }
        }
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="id")
        private String id;
        @JsonProperty(value="compartmentId")
        private String compartmentId;
        @JsonProperty(value="name")
        private String name;
        @JsonProperty(value="description")
        private String description;
        @JsonProperty(value="managedDatabaseGroupId")
        private String managedDatabaseGroupId;
        @JsonProperty(value="managedDatabaseId")
        private String managedDatabaseId;
        @JsonProperty(value="managedDatabasesDetails")
        private List<JobDatabase> managedDatabasesDetails;
        @JsonProperty(value="databaseSubType")
        private DatabaseSubType databaseSubType;
        @JsonProperty(value="scheduleType")
        private Job.ScheduleType scheduleType;
        @JsonProperty(value="lifecycleState")
        private Job.LifecycleState lifecycleState;
        @JsonProperty(value="timeout")
        private String timeout;
        @JsonProperty(value="resultLocation")
        private JobExecutionResultLocation resultLocation;
        @JsonProperty(value="submissionErrorMessage")
        private String submissionErrorMessage;
        @JsonProperty(value="timeCreated")
        private Date timeCreated;
        @JsonProperty(value="timeUpdated")
        private Date timeUpdated;
        @JsonProperty(value="sqlType")
        private SqlType sqlType;
        @JsonProperty(value="sqlText")
        private String sqlText;
        @JsonProperty(value="operationType")
        private OperationType operationType;
        @JsonProperty(value="userName")
        private String userName;
        @JsonProperty(value="role")
        private Role role;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder id(String id) {
            this.id = id;
            this.__explicitlySet__.add("id");
            return this;
        }

        public Builder compartmentId(String compartmentId) {
            this.compartmentId = compartmentId;
            this.__explicitlySet__.add("compartmentId");
            return this;
        }

        public Builder name(String name) {
            this.name = name;
            this.__explicitlySet__.add("name");
            return this;
        }

        public Builder description(String description) {
            this.description = description;
            this.__explicitlySet__.add("description");
            return this;
        }

        public Builder managedDatabaseGroupId(String managedDatabaseGroupId) {
            this.managedDatabaseGroupId = managedDatabaseGroupId;
            this.__explicitlySet__.add("managedDatabaseGroupId");
            return this;
        }

        public Builder managedDatabaseId(String managedDatabaseId) {
            this.managedDatabaseId = managedDatabaseId;
            this.__explicitlySet__.add("managedDatabaseId");
            return this;
        }

        public Builder managedDatabasesDetails(List<JobDatabase> managedDatabasesDetails) {
            this.managedDatabasesDetails = managedDatabasesDetails;
            this.__explicitlySet__.add("managedDatabasesDetails");
            return this;
        }

        public Builder databaseSubType(DatabaseSubType databaseSubType) {
            this.databaseSubType = databaseSubType;
            this.__explicitlySet__.add("databaseSubType");
            return this;
        }

        public Builder scheduleType(Job.ScheduleType scheduleType) {
            this.scheduleType = scheduleType;
            this.__explicitlySet__.add("scheduleType");
            return this;
        }

        public Builder lifecycleState(Job.LifecycleState lifecycleState) {
            this.lifecycleState = lifecycleState;
            this.__explicitlySet__.add("lifecycleState");
            return this;
        }

        public Builder timeout(String timeout) {
            this.timeout = timeout;
            this.__explicitlySet__.add("timeout");
            return this;
        }

        public Builder resultLocation(JobExecutionResultLocation resultLocation) {
            this.resultLocation = resultLocation;
            this.__explicitlySet__.add("resultLocation");
            return this;
        }

        public Builder submissionErrorMessage(String submissionErrorMessage) {
            this.submissionErrorMessage = submissionErrorMessage;
            this.__explicitlySet__.add("submissionErrorMessage");
            return this;
        }

        public Builder timeCreated(Date timeCreated) {
            this.timeCreated = timeCreated;
            this.__explicitlySet__.add("timeCreated");
            return this;
        }

        public Builder timeUpdated(Date timeUpdated) {
            this.timeUpdated = timeUpdated;
            this.__explicitlySet__.add("timeUpdated");
            return this;
        }

        public Builder sqlType(SqlType sqlType) {
            this.sqlType = sqlType;
            this.__explicitlySet__.add("sqlType");
            return this;
        }

        public Builder sqlText(String sqlText) {
            this.sqlText = sqlText;
            this.__explicitlySet__.add("sqlText");
            return this;
        }

        public Builder operationType(OperationType operationType) {
            this.operationType = operationType;
            this.__explicitlySet__.add("operationType");
            return this;
        }

        public Builder userName(String userName) {
            this.userName = userName;
            this.__explicitlySet__.add("userName");
            return this;
        }

        public Builder role(Role role) {
            this.role = role;
            this.__explicitlySet__.add("role");
            return this;
        }

        public SqlJob build() {
            SqlJob __instance__ = new SqlJob(this.id, this.compartmentId, this.name, this.description, this.managedDatabaseGroupId, this.managedDatabaseId, this.managedDatabasesDetails, this.databaseSubType, this.scheduleType, this.lifecycleState, this.timeout, this.resultLocation, this.submissionErrorMessage, this.timeCreated, this.timeUpdated, this.sqlType, this.sqlText, this.operationType, this.userName, this.role);
            __instance__.__explicitlySet__.addAll(this.__explicitlySet__);
            return __instance__;
        }

        @JsonIgnore
        public Builder copy(SqlJob o) {
            Builder copiedBuilder = this.id(o.getId()).compartmentId(o.getCompartmentId()).name(o.getName()).description(o.getDescription()).managedDatabaseGroupId(o.getManagedDatabaseGroupId()).managedDatabaseId(o.getManagedDatabaseId()).managedDatabasesDetails(o.getManagedDatabasesDetails()).databaseSubType(o.getDatabaseSubType()).scheduleType(o.getScheduleType()).lifecycleState(o.getLifecycleState()).timeout(o.getTimeout()).resultLocation(o.getResultLocation()).submissionErrorMessage(o.getSubmissionErrorMessage()).timeCreated(o.getTimeCreated()).timeUpdated(o.getTimeUpdated()).sqlType(o.getSqlType()).sqlText(o.getSqlText()).operationType(o.getOperationType()).userName(o.getUserName()).role(o.getRole());
            copiedBuilder.__explicitlySet__.retainAll(o.__explicitlySet__);
            return copiedBuilder;
        }

        Builder() {
        }

        public String toString() {
            return "SqlJob.Builder(sqlType=" + (Object)((Object)this.sqlType) + ", sqlText=" + this.sqlText + ", operationType=" + (Object)((Object)this.operationType) + ", userName=" + this.userName + ", role=" + (Object)((Object)this.role) + ")";
        }
    }
}

