/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.datacatalog;

import com.google.common.base.Function;
import com.google.common.base.Predicate;
import com.google.common.base.Suppliers;
import com.oracle.bmc.datacatalog.DataCatalog;
import com.oracle.bmc.datacatalog.model.JobExecutionState;
import com.oracle.bmc.datacatalog.model.JobLifecycleState;
import com.oracle.bmc.datacatalog.model.LifecycleState;
import com.oracle.bmc.datacatalog.requests.GetAttributeRequest;
import com.oracle.bmc.datacatalog.requests.GetAttributeTagRequest;
import com.oracle.bmc.datacatalog.requests.GetCatalogPrivateEndpointRequest;
import com.oracle.bmc.datacatalog.requests.GetCatalogRequest;
import com.oracle.bmc.datacatalog.requests.GetConnectionRequest;
import com.oracle.bmc.datacatalog.requests.GetCustomPropertyRequest;
import com.oracle.bmc.datacatalog.requests.GetDataAssetRequest;
import com.oracle.bmc.datacatalog.requests.GetDataAssetTagRequest;
import com.oracle.bmc.datacatalog.requests.GetEntityRequest;
import com.oracle.bmc.datacatalog.requests.GetEntityTagRequest;
import com.oracle.bmc.datacatalog.requests.GetFolderRequest;
import com.oracle.bmc.datacatalog.requests.GetFolderTagRequest;
import com.oracle.bmc.datacatalog.requests.GetGlossaryRequest;
import com.oracle.bmc.datacatalog.requests.GetJobDefinitionRequest;
import com.oracle.bmc.datacatalog.requests.GetJobExecutionRequest;
import com.oracle.bmc.datacatalog.requests.GetJobRequest;
import com.oracle.bmc.datacatalog.requests.GetNamespaceRequest;
import com.oracle.bmc.datacatalog.requests.GetPatternRequest;
import com.oracle.bmc.datacatalog.requests.GetTermRelationshipRequest;
import com.oracle.bmc.datacatalog.requests.GetTermRequest;
import com.oracle.bmc.datacatalog.requests.GetTypeRequest;
import com.oracle.bmc.datacatalog.requests.GetWorkRequestRequest;
import com.oracle.bmc.datacatalog.responses.GetAttributeResponse;
import com.oracle.bmc.datacatalog.responses.GetAttributeTagResponse;
import com.oracle.bmc.datacatalog.responses.GetCatalogPrivateEndpointResponse;
import com.oracle.bmc.datacatalog.responses.GetCatalogResponse;
import com.oracle.bmc.datacatalog.responses.GetConnectionResponse;
import com.oracle.bmc.datacatalog.responses.GetCustomPropertyResponse;
import com.oracle.bmc.datacatalog.responses.GetDataAssetResponse;
import com.oracle.bmc.datacatalog.responses.GetDataAssetTagResponse;
import com.oracle.bmc.datacatalog.responses.GetEntityResponse;
import com.oracle.bmc.datacatalog.responses.GetEntityTagResponse;
import com.oracle.bmc.datacatalog.responses.GetFolderResponse;
import com.oracle.bmc.datacatalog.responses.GetFolderTagResponse;
import com.oracle.bmc.datacatalog.responses.GetGlossaryResponse;
import com.oracle.bmc.datacatalog.responses.GetJobDefinitionResponse;
import com.oracle.bmc.datacatalog.responses.GetJobExecutionResponse;
import com.oracle.bmc.datacatalog.responses.GetJobResponse;
import com.oracle.bmc.datacatalog.responses.GetNamespaceResponse;
import com.oracle.bmc.datacatalog.responses.GetPatternResponse;
import com.oracle.bmc.datacatalog.responses.GetTermRelationshipResponse;
import com.oracle.bmc.datacatalog.responses.GetTermResponse;
import com.oracle.bmc.datacatalog.responses.GetTypeResponse;
import com.oracle.bmc.datacatalog.responses.GetWorkRequestResponse;
import com.oracle.bmc.waiter.BmcGenericWaiter;
import com.oracle.bmc.waiter.DelayStrategy;
import com.oracle.bmc.waiter.TerminationStrategy;
import com.oracle.bmc.waiter.Waiter;
import com.oracle.bmc.waiter.Waiters;
import com.oracle.bmc.waiter.internal.SimpleWaiterImpl;
import java.beans.ConstructorProperties;
import java.util.Arrays;
import java.util.HashSet;
import java.util.concurrent.ExecutorService;
import org.apache.commons.lang3.Validate;

public class DataCatalogWaiters {
    private final ExecutorService executorService;
    private final DataCatalog client;

    public Waiter<GetAttributeRequest, GetAttributeResponse> forAttribute(GetAttributeRequest request, LifecycleState ... targetStates) {
        Validate.notEmpty((Object[])targetStates, (String)"At least one targetState must be provided", (Object[])new Object[0]);
        Validate.noNullElements((Object[])targetStates, (String)"Null targetState values are not permitted", (Object[])new Object[0]);
        return this.forAttribute(Waiters.DEFAULT_POLLING_WAITER, request, targetStates);
    }

    public Waiter<GetAttributeRequest, GetAttributeResponse> forAttribute(GetAttributeRequest request, LifecycleState targetState, TerminationStrategy terminationStrategy, DelayStrategy delayStrategy) {
        Validate.notNull((Object)((Object)targetState), (String)"The targetState cannot be null", (Object[])new Object[0]);
        return this.forAttribute(Waiters.newWaiter((TerminationStrategy)terminationStrategy, (DelayStrategy)delayStrategy), request, targetState);
    }

    public Waiter<GetAttributeRequest, GetAttributeResponse> forAttribute(GetAttributeRequest request, TerminationStrategy terminationStrategy, DelayStrategy delayStrategy, LifecycleState ... targetStates) {
        Validate.notEmpty((Object[])targetStates, (String)"At least one targetState must be provided", (Object[])new Object[0]);
        Validate.noNullElements((Object[])targetStates, (String)"Null targetState values are not permitted", (Object[])new Object[0]);
        return this.forAttribute(Waiters.newWaiter((TerminationStrategy)terminationStrategy, (DelayStrategy)delayStrategy), request, targetStates);
    }

    private Waiter<GetAttributeRequest, GetAttributeResponse> forAttribute(BmcGenericWaiter waiter, GetAttributeRequest request, LifecycleState ... targetStates) {
        final HashSet<LifecycleState> targetStatesSet = new HashSet<LifecycleState>(Arrays.asList(targetStates));
        return new SimpleWaiterImpl(this.executorService, waiter.toCallable(Suppliers.ofInstance((Object)((Object)request)), (Function)new Function<GetAttributeRequest, GetAttributeResponse>(){

            public GetAttributeResponse apply(GetAttributeRequest request) {
                return DataCatalogWaiters.this.client.getAttribute(request);
            }
        }, (Predicate)new Predicate<GetAttributeResponse>(){

            public boolean apply(GetAttributeResponse response) {
                return targetStatesSet.contains((Object)response.getAttribute().getLifecycleState());
            }
        }, targetStatesSet.contains((Object)LifecycleState.Deleted)), (Object)request);
    }

    public Waiter<GetAttributeTagRequest, GetAttributeTagResponse> forAttributeTag(GetAttributeTagRequest request, LifecycleState ... targetStates) {
        Validate.notEmpty((Object[])targetStates, (String)"At least one targetState must be provided", (Object[])new Object[0]);
        Validate.noNullElements((Object[])targetStates, (String)"Null targetState values are not permitted", (Object[])new Object[0]);
        return this.forAttributeTag(Waiters.DEFAULT_POLLING_WAITER, request, targetStates);
    }

    public Waiter<GetAttributeTagRequest, GetAttributeTagResponse> forAttributeTag(GetAttributeTagRequest request, LifecycleState targetState, TerminationStrategy terminationStrategy, DelayStrategy delayStrategy) {
        Validate.notNull((Object)((Object)targetState), (String)"The targetState cannot be null", (Object[])new Object[0]);
        return this.forAttributeTag(Waiters.newWaiter((TerminationStrategy)terminationStrategy, (DelayStrategy)delayStrategy), request, targetState);
    }

    public Waiter<GetAttributeTagRequest, GetAttributeTagResponse> forAttributeTag(GetAttributeTagRequest request, TerminationStrategy terminationStrategy, DelayStrategy delayStrategy, LifecycleState ... targetStates) {
        Validate.notEmpty((Object[])targetStates, (String)"At least one targetState must be provided", (Object[])new Object[0]);
        Validate.noNullElements((Object[])targetStates, (String)"Null targetState values are not permitted", (Object[])new Object[0]);
        return this.forAttributeTag(Waiters.newWaiter((TerminationStrategy)terminationStrategy, (DelayStrategy)delayStrategy), request, targetStates);
    }

    private Waiter<GetAttributeTagRequest, GetAttributeTagResponse> forAttributeTag(BmcGenericWaiter waiter, GetAttributeTagRequest request, LifecycleState ... targetStates) {
        final HashSet<LifecycleState> targetStatesSet = new HashSet<LifecycleState>(Arrays.asList(targetStates));
        return new SimpleWaiterImpl(this.executorService, waiter.toCallable(Suppliers.ofInstance((Object)((Object)request)), (Function)new Function<GetAttributeTagRequest, GetAttributeTagResponse>(){

            public GetAttributeTagResponse apply(GetAttributeTagRequest request) {
                return DataCatalogWaiters.this.client.getAttributeTag(request);
            }
        }, (Predicate)new Predicate<GetAttributeTagResponse>(){

            public boolean apply(GetAttributeTagResponse response) {
                return targetStatesSet.contains((Object)response.getAttributeTag().getLifecycleState());
            }
        }, targetStatesSet.contains((Object)LifecycleState.Deleted)), (Object)request);
    }

    public Waiter<GetCatalogRequest, GetCatalogResponse> forCatalog(GetCatalogRequest request, LifecycleState ... targetStates) {
        Validate.notEmpty((Object[])targetStates, (String)"At least one targetState must be provided", (Object[])new Object[0]);
        Validate.noNullElements((Object[])targetStates, (String)"Null targetState values are not permitted", (Object[])new Object[0]);
        return this.forCatalog(Waiters.DEFAULT_POLLING_WAITER, request, targetStates);
    }

    public Waiter<GetCatalogRequest, GetCatalogResponse> forCatalog(GetCatalogRequest request, LifecycleState targetState, TerminationStrategy terminationStrategy, DelayStrategy delayStrategy) {
        Validate.notNull((Object)((Object)targetState), (String)"The targetState cannot be null", (Object[])new Object[0]);
        return this.forCatalog(Waiters.newWaiter((TerminationStrategy)terminationStrategy, (DelayStrategy)delayStrategy), request, targetState);
    }

    public Waiter<GetCatalogRequest, GetCatalogResponse> forCatalog(GetCatalogRequest request, TerminationStrategy terminationStrategy, DelayStrategy delayStrategy, LifecycleState ... targetStates) {
        Validate.notEmpty((Object[])targetStates, (String)"At least one targetState must be provided", (Object[])new Object[0]);
        Validate.noNullElements((Object[])targetStates, (String)"Null targetState values are not permitted", (Object[])new Object[0]);
        return this.forCatalog(Waiters.newWaiter((TerminationStrategy)terminationStrategy, (DelayStrategy)delayStrategy), request, targetStates);
    }

    private Waiter<GetCatalogRequest, GetCatalogResponse> forCatalog(BmcGenericWaiter waiter, GetCatalogRequest request, LifecycleState ... targetStates) {
        final HashSet<LifecycleState> targetStatesSet = new HashSet<LifecycleState>(Arrays.asList(targetStates));
        return new SimpleWaiterImpl(this.executorService, waiter.toCallable(Suppliers.ofInstance((Object)((Object)request)), (Function)new Function<GetCatalogRequest, GetCatalogResponse>(){

            public GetCatalogResponse apply(GetCatalogRequest request) {
                return DataCatalogWaiters.this.client.getCatalog(request);
            }
        }, (Predicate)new Predicate<GetCatalogResponse>(){

            public boolean apply(GetCatalogResponse response) {
                return targetStatesSet.contains((Object)response.getCatalog().getLifecycleState());
            }
        }, targetStatesSet.contains((Object)LifecycleState.Deleted)), (Object)request);
    }

    public Waiter<GetCatalogPrivateEndpointRequest, GetCatalogPrivateEndpointResponse> forCatalogPrivateEndpoint(GetCatalogPrivateEndpointRequest request, LifecycleState ... targetStates) {
        Validate.notEmpty((Object[])targetStates, (String)"At least one targetState must be provided", (Object[])new Object[0]);
        Validate.noNullElements((Object[])targetStates, (String)"Null targetState values are not permitted", (Object[])new Object[0]);
        return this.forCatalogPrivateEndpoint(Waiters.DEFAULT_POLLING_WAITER, request, targetStates);
    }

    public Waiter<GetCatalogPrivateEndpointRequest, GetCatalogPrivateEndpointResponse> forCatalogPrivateEndpoint(GetCatalogPrivateEndpointRequest request, LifecycleState targetState, TerminationStrategy terminationStrategy, DelayStrategy delayStrategy) {
        Validate.notNull((Object)((Object)targetState), (String)"The targetState cannot be null", (Object[])new Object[0]);
        return this.forCatalogPrivateEndpoint(Waiters.newWaiter((TerminationStrategy)terminationStrategy, (DelayStrategy)delayStrategy), request, targetState);
    }

    public Waiter<GetCatalogPrivateEndpointRequest, GetCatalogPrivateEndpointResponse> forCatalogPrivateEndpoint(GetCatalogPrivateEndpointRequest request, TerminationStrategy terminationStrategy, DelayStrategy delayStrategy, LifecycleState ... targetStates) {
        Validate.notEmpty((Object[])targetStates, (String)"At least one targetState must be provided", (Object[])new Object[0]);
        Validate.noNullElements((Object[])targetStates, (String)"Null targetState values are not permitted", (Object[])new Object[0]);
        return this.forCatalogPrivateEndpoint(Waiters.newWaiter((TerminationStrategy)terminationStrategy, (DelayStrategy)delayStrategy), request, targetStates);
    }

    private Waiter<GetCatalogPrivateEndpointRequest, GetCatalogPrivateEndpointResponse> forCatalogPrivateEndpoint(BmcGenericWaiter waiter, GetCatalogPrivateEndpointRequest request, LifecycleState ... targetStates) {
        final HashSet<LifecycleState> targetStatesSet = new HashSet<LifecycleState>(Arrays.asList(targetStates));
        return new SimpleWaiterImpl(this.executorService, waiter.toCallable(Suppliers.ofInstance((Object)((Object)request)), (Function)new Function<GetCatalogPrivateEndpointRequest, GetCatalogPrivateEndpointResponse>(){

            public GetCatalogPrivateEndpointResponse apply(GetCatalogPrivateEndpointRequest request) {
                return DataCatalogWaiters.this.client.getCatalogPrivateEndpoint(request);
            }
        }, (Predicate)new Predicate<GetCatalogPrivateEndpointResponse>(){

            public boolean apply(GetCatalogPrivateEndpointResponse response) {
                return targetStatesSet.contains((Object)response.getCatalogPrivateEndpoint().getLifecycleState());
            }
        }, targetStatesSet.contains((Object)LifecycleState.Deleted)), (Object)request);
    }

    public Waiter<GetConnectionRequest, GetConnectionResponse> forConnection(GetConnectionRequest request, LifecycleState ... targetStates) {
        Validate.notEmpty((Object[])targetStates, (String)"At least one targetState must be provided", (Object[])new Object[0]);
        Validate.noNullElements((Object[])targetStates, (String)"Null targetState values are not permitted", (Object[])new Object[0]);
        return this.forConnection(Waiters.DEFAULT_POLLING_WAITER, request, targetStates);
    }

    public Waiter<GetConnectionRequest, GetConnectionResponse> forConnection(GetConnectionRequest request, LifecycleState targetState, TerminationStrategy terminationStrategy, DelayStrategy delayStrategy) {
        Validate.notNull((Object)((Object)targetState), (String)"The targetState cannot be null", (Object[])new Object[0]);
        return this.forConnection(Waiters.newWaiter((TerminationStrategy)terminationStrategy, (DelayStrategy)delayStrategy), request, targetState);
    }

    public Waiter<GetConnectionRequest, GetConnectionResponse> forConnection(GetConnectionRequest request, TerminationStrategy terminationStrategy, DelayStrategy delayStrategy, LifecycleState ... targetStates) {
        Validate.notEmpty((Object[])targetStates, (String)"At least one targetState must be provided", (Object[])new Object[0]);
        Validate.noNullElements((Object[])targetStates, (String)"Null targetState values are not permitted", (Object[])new Object[0]);
        return this.forConnection(Waiters.newWaiter((TerminationStrategy)terminationStrategy, (DelayStrategy)delayStrategy), request, targetStates);
    }

    private Waiter<GetConnectionRequest, GetConnectionResponse> forConnection(BmcGenericWaiter waiter, GetConnectionRequest request, LifecycleState ... targetStates) {
        final HashSet<LifecycleState> targetStatesSet = new HashSet<LifecycleState>(Arrays.asList(targetStates));
        return new SimpleWaiterImpl(this.executorService, waiter.toCallable(Suppliers.ofInstance((Object)((Object)request)), (Function)new Function<GetConnectionRequest, GetConnectionResponse>(){

            public GetConnectionResponse apply(GetConnectionRequest request) {
                return DataCatalogWaiters.this.client.getConnection(request);
            }
        }, (Predicate)new Predicate<GetConnectionResponse>(){

            public boolean apply(GetConnectionResponse response) {
                return targetStatesSet.contains((Object)response.getConnection().getLifecycleState());
            }
        }, targetStatesSet.contains((Object)LifecycleState.Deleted)), (Object)request);
    }

    public Waiter<GetCustomPropertyRequest, GetCustomPropertyResponse> forCustomProperty(GetCustomPropertyRequest request, LifecycleState ... targetStates) {
        Validate.notEmpty((Object[])targetStates, (String)"At least one targetState must be provided", (Object[])new Object[0]);
        Validate.noNullElements((Object[])targetStates, (String)"Null targetState values are not permitted", (Object[])new Object[0]);
        return this.forCustomProperty(Waiters.DEFAULT_POLLING_WAITER, request, targetStates);
    }

    public Waiter<GetCustomPropertyRequest, GetCustomPropertyResponse> forCustomProperty(GetCustomPropertyRequest request, LifecycleState targetState, TerminationStrategy terminationStrategy, DelayStrategy delayStrategy) {
        Validate.notNull((Object)((Object)targetState), (String)"The targetState cannot be null", (Object[])new Object[0]);
        return this.forCustomProperty(Waiters.newWaiter((TerminationStrategy)terminationStrategy, (DelayStrategy)delayStrategy), request, targetState);
    }

    public Waiter<GetCustomPropertyRequest, GetCustomPropertyResponse> forCustomProperty(GetCustomPropertyRequest request, TerminationStrategy terminationStrategy, DelayStrategy delayStrategy, LifecycleState ... targetStates) {
        Validate.notEmpty((Object[])targetStates, (String)"At least one targetState must be provided", (Object[])new Object[0]);
        Validate.noNullElements((Object[])targetStates, (String)"Null targetState values are not permitted", (Object[])new Object[0]);
        return this.forCustomProperty(Waiters.newWaiter((TerminationStrategy)terminationStrategy, (DelayStrategy)delayStrategy), request, targetStates);
    }

    private Waiter<GetCustomPropertyRequest, GetCustomPropertyResponse> forCustomProperty(BmcGenericWaiter waiter, GetCustomPropertyRequest request, LifecycleState ... targetStates) {
        final HashSet<LifecycleState> targetStatesSet = new HashSet<LifecycleState>(Arrays.asList(targetStates));
        return new SimpleWaiterImpl(this.executorService, waiter.toCallable(Suppliers.ofInstance((Object)((Object)request)), (Function)new Function<GetCustomPropertyRequest, GetCustomPropertyResponse>(){

            public GetCustomPropertyResponse apply(GetCustomPropertyRequest request) {
                return DataCatalogWaiters.this.client.getCustomProperty(request);
            }
        }, (Predicate)new Predicate<GetCustomPropertyResponse>(){

            public boolean apply(GetCustomPropertyResponse response) {
                return targetStatesSet.contains((Object)response.getCustomProperty().getLifecycleState());
            }
        }, targetStatesSet.contains((Object)LifecycleState.Deleted)), (Object)request);
    }

    public Waiter<GetDataAssetRequest, GetDataAssetResponse> forDataAsset(GetDataAssetRequest request, LifecycleState ... targetStates) {
        Validate.notEmpty((Object[])targetStates, (String)"At least one targetState must be provided", (Object[])new Object[0]);
        Validate.noNullElements((Object[])targetStates, (String)"Null targetState values are not permitted", (Object[])new Object[0]);
        return this.forDataAsset(Waiters.DEFAULT_POLLING_WAITER, request, targetStates);
    }

    public Waiter<GetDataAssetRequest, GetDataAssetResponse> forDataAsset(GetDataAssetRequest request, LifecycleState targetState, TerminationStrategy terminationStrategy, DelayStrategy delayStrategy) {
        Validate.notNull((Object)((Object)targetState), (String)"The targetState cannot be null", (Object[])new Object[0]);
        return this.forDataAsset(Waiters.newWaiter((TerminationStrategy)terminationStrategy, (DelayStrategy)delayStrategy), request, targetState);
    }

    public Waiter<GetDataAssetRequest, GetDataAssetResponse> forDataAsset(GetDataAssetRequest request, TerminationStrategy terminationStrategy, DelayStrategy delayStrategy, LifecycleState ... targetStates) {
        Validate.notEmpty((Object[])targetStates, (String)"At least one targetState must be provided", (Object[])new Object[0]);
        Validate.noNullElements((Object[])targetStates, (String)"Null targetState values are not permitted", (Object[])new Object[0]);
        return this.forDataAsset(Waiters.newWaiter((TerminationStrategy)terminationStrategy, (DelayStrategy)delayStrategy), request, targetStates);
    }

    private Waiter<GetDataAssetRequest, GetDataAssetResponse> forDataAsset(BmcGenericWaiter waiter, GetDataAssetRequest request, LifecycleState ... targetStates) {
        final HashSet<LifecycleState> targetStatesSet = new HashSet<LifecycleState>(Arrays.asList(targetStates));
        return new SimpleWaiterImpl(this.executorService, waiter.toCallable(Suppliers.ofInstance((Object)((Object)request)), (Function)new Function<GetDataAssetRequest, GetDataAssetResponse>(){

            public GetDataAssetResponse apply(GetDataAssetRequest request) {
                return DataCatalogWaiters.this.client.getDataAsset(request);
            }
        }, (Predicate)new Predicate<GetDataAssetResponse>(){

            public boolean apply(GetDataAssetResponse response) {
                return targetStatesSet.contains((Object)response.getDataAsset().getLifecycleState());
            }
        }, targetStatesSet.contains((Object)LifecycleState.Deleted)), (Object)request);
    }

    public Waiter<GetDataAssetTagRequest, GetDataAssetTagResponse> forDataAssetTag(GetDataAssetTagRequest request, LifecycleState ... targetStates) {
        Validate.notEmpty((Object[])targetStates, (String)"At least one targetState must be provided", (Object[])new Object[0]);
        Validate.noNullElements((Object[])targetStates, (String)"Null targetState values are not permitted", (Object[])new Object[0]);
        return this.forDataAssetTag(Waiters.DEFAULT_POLLING_WAITER, request, targetStates);
    }

    public Waiter<GetDataAssetTagRequest, GetDataAssetTagResponse> forDataAssetTag(GetDataAssetTagRequest request, LifecycleState targetState, TerminationStrategy terminationStrategy, DelayStrategy delayStrategy) {
        Validate.notNull((Object)((Object)targetState), (String)"The targetState cannot be null", (Object[])new Object[0]);
        return this.forDataAssetTag(Waiters.newWaiter((TerminationStrategy)terminationStrategy, (DelayStrategy)delayStrategy), request, targetState);
    }

    public Waiter<GetDataAssetTagRequest, GetDataAssetTagResponse> forDataAssetTag(GetDataAssetTagRequest request, TerminationStrategy terminationStrategy, DelayStrategy delayStrategy, LifecycleState ... targetStates) {
        Validate.notEmpty((Object[])targetStates, (String)"At least one targetState must be provided", (Object[])new Object[0]);
        Validate.noNullElements((Object[])targetStates, (String)"Null targetState values are not permitted", (Object[])new Object[0]);
        return this.forDataAssetTag(Waiters.newWaiter((TerminationStrategy)terminationStrategy, (DelayStrategy)delayStrategy), request, targetStates);
    }

    private Waiter<GetDataAssetTagRequest, GetDataAssetTagResponse> forDataAssetTag(BmcGenericWaiter waiter, GetDataAssetTagRequest request, LifecycleState ... targetStates) {
        final HashSet<LifecycleState> targetStatesSet = new HashSet<LifecycleState>(Arrays.asList(targetStates));
        return new SimpleWaiterImpl(this.executorService, waiter.toCallable(Suppliers.ofInstance((Object)((Object)request)), (Function)new Function<GetDataAssetTagRequest, GetDataAssetTagResponse>(){

            public GetDataAssetTagResponse apply(GetDataAssetTagRequest request) {
                return DataCatalogWaiters.this.client.getDataAssetTag(request);
            }
        }, (Predicate)new Predicate<GetDataAssetTagResponse>(){

            public boolean apply(GetDataAssetTagResponse response) {
                return targetStatesSet.contains((Object)response.getDataAssetTag().getLifecycleState());
            }
        }, targetStatesSet.contains((Object)LifecycleState.Deleted)), (Object)request);
    }

    public Waiter<GetEntityRequest, GetEntityResponse> forEntity(GetEntityRequest request, LifecycleState ... targetStates) {
        Validate.notEmpty((Object[])targetStates, (String)"At least one targetState must be provided", (Object[])new Object[0]);
        Validate.noNullElements((Object[])targetStates, (String)"Null targetState values are not permitted", (Object[])new Object[0]);
        return this.forEntity(Waiters.DEFAULT_POLLING_WAITER, request, targetStates);
    }

    public Waiter<GetEntityRequest, GetEntityResponse> forEntity(GetEntityRequest request, LifecycleState targetState, TerminationStrategy terminationStrategy, DelayStrategy delayStrategy) {
        Validate.notNull((Object)((Object)targetState), (String)"The targetState cannot be null", (Object[])new Object[0]);
        return this.forEntity(Waiters.newWaiter((TerminationStrategy)terminationStrategy, (DelayStrategy)delayStrategy), request, targetState);
    }

    public Waiter<GetEntityRequest, GetEntityResponse> forEntity(GetEntityRequest request, TerminationStrategy terminationStrategy, DelayStrategy delayStrategy, LifecycleState ... targetStates) {
        Validate.notEmpty((Object[])targetStates, (String)"At least one targetState must be provided", (Object[])new Object[0]);
        Validate.noNullElements((Object[])targetStates, (String)"Null targetState values are not permitted", (Object[])new Object[0]);
        return this.forEntity(Waiters.newWaiter((TerminationStrategy)terminationStrategy, (DelayStrategy)delayStrategy), request, targetStates);
    }

    private Waiter<GetEntityRequest, GetEntityResponse> forEntity(BmcGenericWaiter waiter, GetEntityRequest request, LifecycleState ... targetStates) {
        final HashSet<LifecycleState> targetStatesSet = new HashSet<LifecycleState>(Arrays.asList(targetStates));
        return new SimpleWaiterImpl(this.executorService, waiter.toCallable(Suppliers.ofInstance((Object)((Object)request)), (Function)new Function<GetEntityRequest, GetEntityResponse>(){

            public GetEntityResponse apply(GetEntityRequest request) {
                return DataCatalogWaiters.this.client.getEntity(request);
            }
        }, (Predicate)new Predicate<GetEntityResponse>(){

            public boolean apply(GetEntityResponse response) {
                return targetStatesSet.contains((Object)response.getEntity().getLifecycleState());
            }
        }, targetStatesSet.contains((Object)LifecycleState.Deleted)), (Object)request);
    }

    public Waiter<GetEntityTagRequest, GetEntityTagResponse> forEntityTag(GetEntityTagRequest request, LifecycleState ... targetStates) {
        Validate.notEmpty((Object[])targetStates, (String)"At least one targetState must be provided", (Object[])new Object[0]);
        Validate.noNullElements((Object[])targetStates, (String)"Null targetState values are not permitted", (Object[])new Object[0]);
        return this.forEntityTag(Waiters.DEFAULT_POLLING_WAITER, request, targetStates);
    }

    public Waiter<GetEntityTagRequest, GetEntityTagResponse> forEntityTag(GetEntityTagRequest request, LifecycleState targetState, TerminationStrategy terminationStrategy, DelayStrategy delayStrategy) {
        Validate.notNull((Object)((Object)targetState), (String)"The targetState cannot be null", (Object[])new Object[0]);
        return this.forEntityTag(Waiters.newWaiter((TerminationStrategy)terminationStrategy, (DelayStrategy)delayStrategy), request, targetState);
    }

    public Waiter<GetEntityTagRequest, GetEntityTagResponse> forEntityTag(GetEntityTagRequest request, TerminationStrategy terminationStrategy, DelayStrategy delayStrategy, LifecycleState ... targetStates) {
        Validate.notEmpty((Object[])targetStates, (String)"At least one targetState must be provided", (Object[])new Object[0]);
        Validate.noNullElements((Object[])targetStates, (String)"Null targetState values are not permitted", (Object[])new Object[0]);
        return this.forEntityTag(Waiters.newWaiter((TerminationStrategy)terminationStrategy, (DelayStrategy)delayStrategy), request, targetStates);
    }

    private Waiter<GetEntityTagRequest, GetEntityTagResponse> forEntityTag(BmcGenericWaiter waiter, GetEntityTagRequest request, LifecycleState ... targetStates) {
        final HashSet<LifecycleState> targetStatesSet = new HashSet<LifecycleState>(Arrays.asList(targetStates));
        return new SimpleWaiterImpl(this.executorService, waiter.toCallable(Suppliers.ofInstance((Object)((Object)request)), (Function)new Function<GetEntityTagRequest, GetEntityTagResponse>(){

            public GetEntityTagResponse apply(GetEntityTagRequest request) {
                return DataCatalogWaiters.this.client.getEntityTag(request);
            }
        }, (Predicate)new Predicate<GetEntityTagResponse>(){

            public boolean apply(GetEntityTagResponse response) {
                return targetStatesSet.contains((Object)response.getEntityTag().getLifecycleState());
            }
        }, targetStatesSet.contains((Object)LifecycleState.Deleted)), (Object)request);
    }

    public Waiter<GetFolderRequest, GetFolderResponse> forFolder(GetFolderRequest request, LifecycleState ... targetStates) {
        Validate.notEmpty((Object[])targetStates, (String)"At least one targetState must be provided", (Object[])new Object[0]);
        Validate.noNullElements((Object[])targetStates, (String)"Null targetState values are not permitted", (Object[])new Object[0]);
        return this.forFolder(Waiters.DEFAULT_POLLING_WAITER, request, targetStates);
    }

    public Waiter<GetFolderRequest, GetFolderResponse> forFolder(GetFolderRequest request, LifecycleState targetState, TerminationStrategy terminationStrategy, DelayStrategy delayStrategy) {
        Validate.notNull((Object)((Object)targetState), (String)"The targetState cannot be null", (Object[])new Object[0]);
        return this.forFolder(Waiters.newWaiter((TerminationStrategy)terminationStrategy, (DelayStrategy)delayStrategy), request, targetState);
    }

    public Waiter<GetFolderRequest, GetFolderResponse> forFolder(GetFolderRequest request, TerminationStrategy terminationStrategy, DelayStrategy delayStrategy, LifecycleState ... targetStates) {
        Validate.notEmpty((Object[])targetStates, (String)"At least one targetState must be provided", (Object[])new Object[0]);
        Validate.noNullElements((Object[])targetStates, (String)"Null targetState values are not permitted", (Object[])new Object[0]);
        return this.forFolder(Waiters.newWaiter((TerminationStrategy)terminationStrategy, (DelayStrategy)delayStrategy), request, targetStates);
    }

    private Waiter<GetFolderRequest, GetFolderResponse> forFolder(BmcGenericWaiter waiter, GetFolderRequest request, LifecycleState ... targetStates) {
        final HashSet<LifecycleState> targetStatesSet = new HashSet<LifecycleState>(Arrays.asList(targetStates));
        return new SimpleWaiterImpl(this.executorService, waiter.toCallable(Suppliers.ofInstance((Object)((Object)request)), (Function)new Function<GetFolderRequest, GetFolderResponse>(){

            public GetFolderResponse apply(GetFolderRequest request) {
                return DataCatalogWaiters.this.client.getFolder(request);
            }
        }, (Predicate)new Predicate<GetFolderResponse>(){

            public boolean apply(GetFolderResponse response) {
                return targetStatesSet.contains((Object)response.getFolder().getLifecycleState());
            }
        }, targetStatesSet.contains((Object)LifecycleState.Deleted)), (Object)request);
    }

    public Waiter<GetFolderTagRequest, GetFolderTagResponse> forFolderTag(GetFolderTagRequest request, LifecycleState ... targetStates) {
        Validate.notEmpty((Object[])targetStates, (String)"At least one targetState must be provided", (Object[])new Object[0]);
        Validate.noNullElements((Object[])targetStates, (String)"Null targetState values are not permitted", (Object[])new Object[0]);
        return this.forFolderTag(Waiters.DEFAULT_POLLING_WAITER, request, targetStates);
    }

    public Waiter<GetFolderTagRequest, GetFolderTagResponse> forFolderTag(GetFolderTagRequest request, LifecycleState targetState, TerminationStrategy terminationStrategy, DelayStrategy delayStrategy) {
        Validate.notNull((Object)((Object)targetState), (String)"The targetState cannot be null", (Object[])new Object[0]);
        return this.forFolderTag(Waiters.newWaiter((TerminationStrategy)terminationStrategy, (DelayStrategy)delayStrategy), request, targetState);
    }

    public Waiter<GetFolderTagRequest, GetFolderTagResponse> forFolderTag(GetFolderTagRequest request, TerminationStrategy terminationStrategy, DelayStrategy delayStrategy, LifecycleState ... targetStates) {
        Validate.notEmpty((Object[])targetStates, (String)"At least one targetState must be provided", (Object[])new Object[0]);
        Validate.noNullElements((Object[])targetStates, (String)"Null targetState values are not permitted", (Object[])new Object[0]);
        return this.forFolderTag(Waiters.newWaiter((TerminationStrategy)terminationStrategy, (DelayStrategy)delayStrategy), request, targetStates);
    }

    private Waiter<GetFolderTagRequest, GetFolderTagResponse> forFolderTag(BmcGenericWaiter waiter, GetFolderTagRequest request, LifecycleState ... targetStates) {
        final HashSet<LifecycleState> targetStatesSet = new HashSet<LifecycleState>(Arrays.asList(targetStates));
        return new SimpleWaiterImpl(this.executorService, waiter.toCallable(Suppliers.ofInstance((Object)((Object)request)), (Function)new Function<GetFolderTagRequest, GetFolderTagResponse>(){

            public GetFolderTagResponse apply(GetFolderTagRequest request) {
                return DataCatalogWaiters.this.client.getFolderTag(request);
            }
        }, (Predicate)new Predicate<GetFolderTagResponse>(){

            public boolean apply(GetFolderTagResponse response) {
                return targetStatesSet.contains((Object)response.getFolderTag().getLifecycleState());
            }
        }, targetStatesSet.contains((Object)LifecycleState.Deleted)), (Object)request);
    }

    public Waiter<GetGlossaryRequest, GetGlossaryResponse> forGlossary(GetGlossaryRequest request, LifecycleState ... targetStates) {
        Validate.notEmpty((Object[])targetStates, (String)"At least one targetState must be provided", (Object[])new Object[0]);
        Validate.noNullElements((Object[])targetStates, (String)"Null targetState values are not permitted", (Object[])new Object[0]);
        return this.forGlossary(Waiters.DEFAULT_POLLING_WAITER, request, targetStates);
    }

    public Waiter<GetGlossaryRequest, GetGlossaryResponse> forGlossary(GetGlossaryRequest request, LifecycleState targetState, TerminationStrategy terminationStrategy, DelayStrategy delayStrategy) {
        Validate.notNull((Object)((Object)targetState), (String)"The targetState cannot be null", (Object[])new Object[0]);
        return this.forGlossary(Waiters.newWaiter((TerminationStrategy)terminationStrategy, (DelayStrategy)delayStrategy), request, targetState);
    }

    public Waiter<GetGlossaryRequest, GetGlossaryResponse> forGlossary(GetGlossaryRequest request, TerminationStrategy terminationStrategy, DelayStrategy delayStrategy, LifecycleState ... targetStates) {
        Validate.notEmpty((Object[])targetStates, (String)"At least one targetState must be provided", (Object[])new Object[0]);
        Validate.noNullElements((Object[])targetStates, (String)"Null targetState values are not permitted", (Object[])new Object[0]);
        return this.forGlossary(Waiters.newWaiter((TerminationStrategy)terminationStrategy, (DelayStrategy)delayStrategy), request, targetStates);
    }

    private Waiter<GetGlossaryRequest, GetGlossaryResponse> forGlossary(BmcGenericWaiter waiter, GetGlossaryRequest request, LifecycleState ... targetStates) {
        final HashSet<LifecycleState> targetStatesSet = new HashSet<LifecycleState>(Arrays.asList(targetStates));
        return new SimpleWaiterImpl(this.executorService, waiter.toCallable(Suppliers.ofInstance((Object)((Object)request)), (Function)new Function<GetGlossaryRequest, GetGlossaryResponse>(){

            public GetGlossaryResponse apply(GetGlossaryRequest request) {
                return DataCatalogWaiters.this.client.getGlossary(request);
            }
        }, (Predicate)new Predicate<GetGlossaryResponse>(){

            public boolean apply(GetGlossaryResponse response) {
                return targetStatesSet.contains((Object)response.getGlossary().getLifecycleState());
            }
        }, targetStatesSet.contains((Object)LifecycleState.Deleted)), (Object)request);
    }

    public Waiter<GetJobRequest, GetJobResponse> forJob(GetJobRequest request, JobLifecycleState ... targetStates) {
        Validate.notEmpty((Object[])targetStates, (String)"At least one targetState must be provided", (Object[])new Object[0]);
        Validate.noNullElements((Object[])targetStates, (String)"Null targetState values are not permitted", (Object[])new Object[0]);
        return this.forJob(Waiters.DEFAULT_POLLING_WAITER, request, targetStates);
    }

    public Waiter<GetJobRequest, GetJobResponse> forJob(GetJobRequest request, JobLifecycleState targetState, TerminationStrategy terminationStrategy, DelayStrategy delayStrategy) {
        Validate.notNull((Object)((Object)targetState), (String)"The targetState cannot be null", (Object[])new Object[0]);
        return this.forJob(Waiters.newWaiter((TerminationStrategy)terminationStrategy, (DelayStrategy)delayStrategy), request, targetState);
    }

    public Waiter<GetJobRequest, GetJobResponse> forJob(GetJobRequest request, TerminationStrategy terminationStrategy, DelayStrategy delayStrategy, JobLifecycleState ... targetStates) {
        Validate.notEmpty((Object[])targetStates, (String)"At least one targetState must be provided", (Object[])new Object[0]);
        Validate.noNullElements((Object[])targetStates, (String)"Null targetState values are not permitted", (Object[])new Object[0]);
        return this.forJob(Waiters.newWaiter((TerminationStrategy)terminationStrategy, (DelayStrategy)delayStrategy), request, targetStates);
    }

    private Waiter<GetJobRequest, GetJobResponse> forJob(BmcGenericWaiter waiter, GetJobRequest request, JobLifecycleState ... targetStates) {
        final HashSet<JobLifecycleState> targetStatesSet = new HashSet<JobLifecycleState>(Arrays.asList(targetStates));
        return new SimpleWaiterImpl(this.executorService, waiter.toCallable(Suppliers.ofInstance((Object)((Object)request)), (Function)new Function<GetJobRequest, GetJobResponse>(){

            public GetJobResponse apply(GetJobRequest request) {
                return DataCatalogWaiters.this.client.getJob(request);
            }
        }, (Predicate)new Predicate<GetJobResponse>(){

            public boolean apply(GetJobResponse response) {
                return targetStatesSet.contains((Object)response.getJob().getLifecycleState());
            }
        }, false), (Object)request);
    }

    public Waiter<GetJobDefinitionRequest, GetJobDefinitionResponse> forJobDefinition(GetJobDefinitionRequest request, LifecycleState ... targetStates) {
        Validate.notEmpty((Object[])targetStates, (String)"At least one targetState must be provided", (Object[])new Object[0]);
        Validate.noNullElements((Object[])targetStates, (String)"Null targetState values are not permitted", (Object[])new Object[0]);
        return this.forJobDefinition(Waiters.DEFAULT_POLLING_WAITER, request, targetStates);
    }

    public Waiter<GetJobDefinitionRequest, GetJobDefinitionResponse> forJobDefinition(GetJobDefinitionRequest request, LifecycleState targetState, TerminationStrategy terminationStrategy, DelayStrategy delayStrategy) {
        Validate.notNull((Object)((Object)targetState), (String)"The targetState cannot be null", (Object[])new Object[0]);
        return this.forJobDefinition(Waiters.newWaiter((TerminationStrategy)terminationStrategy, (DelayStrategy)delayStrategy), request, targetState);
    }

    public Waiter<GetJobDefinitionRequest, GetJobDefinitionResponse> forJobDefinition(GetJobDefinitionRequest request, TerminationStrategy terminationStrategy, DelayStrategy delayStrategy, LifecycleState ... targetStates) {
        Validate.notEmpty((Object[])targetStates, (String)"At least one targetState must be provided", (Object[])new Object[0]);
        Validate.noNullElements((Object[])targetStates, (String)"Null targetState values are not permitted", (Object[])new Object[0]);
        return this.forJobDefinition(Waiters.newWaiter((TerminationStrategy)terminationStrategy, (DelayStrategy)delayStrategy), request, targetStates);
    }

    private Waiter<GetJobDefinitionRequest, GetJobDefinitionResponse> forJobDefinition(BmcGenericWaiter waiter, GetJobDefinitionRequest request, LifecycleState ... targetStates) {
        final HashSet<LifecycleState> targetStatesSet = new HashSet<LifecycleState>(Arrays.asList(targetStates));
        return new SimpleWaiterImpl(this.executorService, waiter.toCallable(Suppliers.ofInstance((Object)((Object)request)), (Function)new Function<GetJobDefinitionRequest, GetJobDefinitionResponse>(){

            public GetJobDefinitionResponse apply(GetJobDefinitionRequest request) {
                return DataCatalogWaiters.this.client.getJobDefinition(request);
            }
        }, (Predicate)new Predicate<GetJobDefinitionResponse>(){

            public boolean apply(GetJobDefinitionResponse response) {
                return targetStatesSet.contains((Object)response.getJobDefinition().getLifecycleState());
            }
        }, targetStatesSet.contains((Object)LifecycleState.Deleted)), (Object)request);
    }

    public Waiter<GetJobExecutionRequest, GetJobExecutionResponse> forJobExecution(GetJobExecutionRequest request, JobExecutionState ... targetStates) {
        Validate.notEmpty((Object[])targetStates, (String)"At least one targetState must be provided", (Object[])new Object[0]);
        Validate.noNullElements((Object[])targetStates, (String)"Null targetState values are not permitted", (Object[])new Object[0]);
        return this.forJobExecution(Waiters.DEFAULT_POLLING_WAITER, request, targetStates);
    }

    public Waiter<GetJobExecutionRequest, GetJobExecutionResponse> forJobExecution(GetJobExecutionRequest request, JobExecutionState targetState, TerminationStrategy terminationStrategy, DelayStrategy delayStrategy) {
        Validate.notNull((Object)((Object)targetState), (String)"The targetState cannot be null", (Object[])new Object[0]);
        return this.forJobExecution(Waiters.newWaiter((TerminationStrategy)terminationStrategy, (DelayStrategy)delayStrategy), request, targetState);
    }

    public Waiter<GetJobExecutionRequest, GetJobExecutionResponse> forJobExecution(GetJobExecutionRequest request, TerminationStrategy terminationStrategy, DelayStrategy delayStrategy, JobExecutionState ... targetStates) {
        Validate.notEmpty((Object[])targetStates, (String)"At least one targetState must be provided", (Object[])new Object[0]);
        Validate.noNullElements((Object[])targetStates, (String)"Null targetState values are not permitted", (Object[])new Object[0]);
        return this.forJobExecution(Waiters.newWaiter((TerminationStrategy)terminationStrategy, (DelayStrategy)delayStrategy), request, targetStates);
    }

    private Waiter<GetJobExecutionRequest, GetJobExecutionResponse> forJobExecution(BmcGenericWaiter waiter, GetJobExecutionRequest request, JobExecutionState ... targetStates) {
        final HashSet<JobExecutionState> targetStatesSet = new HashSet<JobExecutionState>(Arrays.asList(targetStates));
        return new SimpleWaiterImpl(this.executorService, waiter.toCallable(Suppliers.ofInstance((Object)((Object)request)), (Function)new Function<GetJobExecutionRequest, GetJobExecutionResponse>(){

            public GetJobExecutionResponse apply(GetJobExecutionRequest request) {
                return DataCatalogWaiters.this.client.getJobExecution(request);
            }
        }, (Predicate)new Predicate<GetJobExecutionResponse>(){

            public boolean apply(GetJobExecutionResponse response) {
                return targetStatesSet.contains((Object)response.getJobExecution().getLifecycleState());
            }
        }, false), (Object)request);
    }

    public Waiter<GetNamespaceRequest, GetNamespaceResponse> forNamespace(GetNamespaceRequest request, LifecycleState ... targetStates) {
        Validate.notEmpty((Object[])targetStates, (String)"At least one targetState must be provided", (Object[])new Object[0]);
        Validate.noNullElements((Object[])targetStates, (String)"Null targetState values are not permitted", (Object[])new Object[0]);
        return this.forNamespace(Waiters.DEFAULT_POLLING_WAITER, request, targetStates);
    }

    public Waiter<GetNamespaceRequest, GetNamespaceResponse> forNamespace(GetNamespaceRequest request, LifecycleState targetState, TerminationStrategy terminationStrategy, DelayStrategy delayStrategy) {
        Validate.notNull((Object)((Object)targetState), (String)"The targetState cannot be null", (Object[])new Object[0]);
        return this.forNamespace(Waiters.newWaiter((TerminationStrategy)terminationStrategy, (DelayStrategy)delayStrategy), request, targetState);
    }

    public Waiter<GetNamespaceRequest, GetNamespaceResponse> forNamespace(GetNamespaceRequest request, TerminationStrategy terminationStrategy, DelayStrategy delayStrategy, LifecycleState ... targetStates) {
        Validate.notEmpty((Object[])targetStates, (String)"At least one targetState must be provided", (Object[])new Object[0]);
        Validate.noNullElements((Object[])targetStates, (String)"Null targetState values are not permitted", (Object[])new Object[0]);
        return this.forNamespace(Waiters.newWaiter((TerminationStrategy)terminationStrategy, (DelayStrategy)delayStrategy), request, targetStates);
    }

    private Waiter<GetNamespaceRequest, GetNamespaceResponse> forNamespace(BmcGenericWaiter waiter, GetNamespaceRequest request, LifecycleState ... targetStates) {
        final HashSet<LifecycleState> targetStatesSet = new HashSet<LifecycleState>(Arrays.asList(targetStates));
        return new SimpleWaiterImpl(this.executorService, waiter.toCallable(Suppliers.ofInstance((Object)((Object)request)), (Function)new Function<GetNamespaceRequest, GetNamespaceResponse>(){

            public GetNamespaceResponse apply(GetNamespaceRequest request) {
                return DataCatalogWaiters.this.client.getNamespace(request);
            }
        }, (Predicate)new Predicate<GetNamespaceResponse>(){

            public boolean apply(GetNamespaceResponse response) {
                return targetStatesSet.contains((Object)response.getNamespace().getLifecycleState());
            }
        }, targetStatesSet.contains((Object)LifecycleState.Deleted)), (Object)request);
    }

    public Waiter<GetPatternRequest, GetPatternResponse> forPattern(GetPatternRequest request, LifecycleState ... targetStates) {
        Validate.notEmpty((Object[])targetStates, (String)"At least one targetState must be provided", (Object[])new Object[0]);
        Validate.noNullElements((Object[])targetStates, (String)"Null targetState values are not permitted", (Object[])new Object[0]);
        return this.forPattern(Waiters.DEFAULT_POLLING_WAITER, request, targetStates);
    }

    public Waiter<GetPatternRequest, GetPatternResponse> forPattern(GetPatternRequest request, LifecycleState targetState, TerminationStrategy terminationStrategy, DelayStrategy delayStrategy) {
        Validate.notNull((Object)((Object)targetState), (String)"The targetState cannot be null", (Object[])new Object[0]);
        return this.forPattern(Waiters.newWaiter((TerminationStrategy)terminationStrategy, (DelayStrategy)delayStrategy), request, targetState);
    }

    public Waiter<GetPatternRequest, GetPatternResponse> forPattern(GetPatternRequest request, TerminationStrategy terminationStrategy, DelayStrategy delayStrategy, LifecycleState ... targetStates) {
        Validate.notEmpty((Object[])targetStates, (String)"At least one targetState must be provided", (Object[])new Object[0]);
        Validate.noNullElements((Object[])targetStates, (String)"Null targetState values are not permitted", (Object[])new Object[0]);
        return this.forPattern(Waiters.newWaiter((TerminationStrategy)terminationStrategy, (DelayStrategy)delayStrategy), request, targetStates);
    }

    private Waiter<GetPatternRequest, GetPatternResponse> forPattern(BmcGenericWaiter waiter, GetPatternRequest request, LifecycleState ... targetStates) {
        final HashSet<LifecycleState> targetStatesSet = new HashSet<LifecycleState>(Arrays.asList(targetStates));
        return new SimpleWaiterImpl(this.executorService, waiter.toCallable(Suppliers.ofInstance((Object)((Object)request)), (Function)new Function<GetPatternRequest, GetPatternResponse>(){

            public GetPatternResponse apply(GetPatternRequest request) {
                return DataCatalogWaiters.this.client.getPattern(request);
            }
        }, (Predicate)new Predicate<GetPatternResponse>(){

            public boolean apply(GetPatternResponse response) {
                return targetStatesSet.contains((Object)response.getPattern().getLifecycleState());
            }
        }, targetStatesSet.contains((Object)LifecycleState.Deleted)), (Object)request);
    }

    public Waiter<GetTermRequest, GetTermResponse> forTerm(GetTermRequest request, LifecycleState ... targetStates) {
        Validate.notEmpty((Object[])targetStates, (String)"At least one targetState must be provided", (Object[])new Object[0]);
        Validate.noNullElements((Object[])targetStates, (String)"Null targetState values are not permitted", (Object[])new Object[0]);
        return this.forTerm(Waiters.DEFAULT_POLLING_WAITER, request, targetStates);
    }

    public Waiter<GetTermRequest, GetTermResponse> forTerm(GetTermRequest request, LifecycleState targetState, TerminationStrategy terminationStrategy, DelayStrategy delayStrategy) {
        Validate.notNull((Object)((Object)targetState), (String)"The targetState cannot be null", (Object[])new Object[0]);
        return this.forTerm(Waiters.newWaiter((TerminationStrategy)terminationStrategy, (DelayStrategy)delayStrategy), request, targetState);
    }

    public Waiter<GetTermRequest, GetTermResponse> forTerm(GetTermRequest request, TerminationStrategy terminationStrategy, DelayStrategy delayStrategy, LifecycleState ... targetStates) {
        Validate.notEmpty((Object[])targetStates, (String)"At least one targetState must be provided", (Object[])new Object[0]);
        Validate.noNullElements((Object[])targetStates, (String)"Null targetState values are not permitted", (Object[])new Object[0]);
        return this.forTerm(Waiters.newWaiter((TerminationStrategy)terminationStrategy, (DelayStrategy)delayStrategy), request, targetStates);
    }

    private Waiter<GetTermRequest, GetTermResponse> forTerm(BmcGenericWaiter waiter, GetTermRequest request, LifecycleState ... targetStates) {
        final HashSet<LifecycleState> targetStatesSet = new HashSet<LifecycleState>(Arrays.asList(targetStates));
        return new SimpleWaiterImpl(this.executorService, waiter.toCallable(Suppliers.ofInstance((Object)((Object)request)), (Function)new Function<GetTermRequest, GetTermResponse>(){

            public GetTermResponse apply(GetTermRequest request) {
                return DataCatalogWaiters.this.client.getTerm(request);
            }
        }, (Predicate)new Predicate<GetTermResponse>(){

            public boolean apply(GetTermResponse response) {
                return targetStatesSet.contains((Object)response.getTerm().getLifecycleState());
            }
        }, targetStatesSet.contains((Object)LifecycleState.Deleted)), (Object)request);
    }

    public Waiter<GetTermRelationshipRequest, GetTermRelationshipResponse> forTermRelationship(GetTermRelationshipRequest request, LifecycleState ... targetStates) {
        Validate.notEmpty((Object[])targetStates, (String)"At least one targetState must be provided", (Object[])new Object[0]);
        Validate.noNullElements((Object[])targetStates, (String)"Null targetState values are not permitted", (Object[])new Object[0]);
        return this.forTermRelationship(Waiters.DEFAULT_POLLING_WAITER, request, targetStates);
    }

    public Waiter<GetTermRelationshipRequest, GetTermRelationshipResponse> forTermRelationship(GetTermRelationshipRequest request, LifecycleState targetState, TerminationStrategy terminationStrategy, DelayStrategy delayStrategy) {
        Validate.notNull((Object)((Object)targetState), (String)"The targetState cannot be null", (Object[])new Object[0]);
        return this.forTermRelationship(Waiters.newWaiter((TerminationStrategy)terminationStrategy, (DelayStrategy)delayStrategy), request, targetState);
    }

    public Waiter<GetTermRelationshipRequest, GetTermRelationshipResponse> forTermRelationship(GetTermRelationshipRequest request, TerminationStrategy terminationStrategy, DelayStrategy delayStrategy, LifecycleState ... targetStates) {
        Validate.notEmpty((Object[])targetStates, (String)"At least one targetState must be provided", (Object[])new Object[0]);
        Validate.noNullElements((Object[])targetStates, (String)"Null targetState values are not permitted", (Object[])new Object[0]);
        return this.forTermRelationship(Waiters.newWaiter((TerminationStrategy)terminationStrategy, (DelayStrategy)delayStrategy), request, targetStates);
    }

    private Waiter<GetTermRelationshipRequest, GetTermRelationshipResponse> forTermRelationship(BmcGenericWaiter waiter, GetTermRelationshipRequest request, LifecycleState ... targetStates) {
        final HashSet<LifecycleState> targetStatesSet = new HashSet<LifecycleState>(Arrays.asList(targetStates));
        return new SimpleWaiterImpl(this.executorService, waiter.toCallable(Suppliers.ofInstance((Object)((Object)request)), (Function)new Function<GetTermRelationshipRequest, GetTermRelationshipResponse>(){

            public GetTermRelationshipResponse apply(GetTermRelationshipRequest request) {
                return DataCatalogWaiters.this.client.getTermRelationship(request);
            }
        }, (Predicate)new Predicate<GetTermRelationshipResponse>(){

            public boolean apply(GetTermRelationshipResponse response) {
                return targetStatesSet.contains((Object)response.getTermRelationship().getLifecycleState());
            }
        }, targetStatesSet.contains((Object)LifecycleState.Deleted)), (Object)request);
    }

    public Waiter<GetTypeRequest, GetTypeResponse> forType(GetTypeRequest request, LifecycleState ... targetStates) {
        Validate.notEmpty((Object[])targetStates, (String)"At least one targetState must be provided", (Object[])new Object[0]);
        Validate.noNullElements((Object[])targetStates, (String)"Null targetState values are not permitted", (Object[])new Object[0]);
        return this.forType(Waiters.DEFAULT_POLLING_WAITER, request, targetStates);
    }

    public Waiter<GetTypeRequest, GetTypeResponse> forType(GetTypeRequest request, LifecycleState targetState, TerminationStrategy terminationStrategy, DelayStrategy delayStrategy) {
        Validate.notNull((Object)((Object)targetState), (String)"The targetState cannot be null", (Object[])new Object[0]);
        return this.forType(Waiters.newWaiter((TerminationStrategy)terminationStrategy, (DelayStrategy)delayStrategy), request, targetState);
    }

    public Waiter<GetTypeRequest, GetTypeResponse> forType(GetTypeRequest request, TerminationStrategy terminationStrategy, DelayStrategy delayStrategy, LifecycleState ... targetStates) {
        Validate.notEmpty((Object[])targetStates, (String)"At least one targetState must be provided", (Object[])new Object[0]);
        Validate.noNullElements((Object[])targetStates, (String)"Null targetState values are not permitted", (Object[])new Object[0]);
        return this.forType(Waiters.newWaiter((TerminationStrategy)terminationStrategy, (DelayStrategy)delayStrategy), request, targetStates);
    }

    private Waiter<GetTypeRequest, GetTypeResponse> forType(BmcGenericWaiter waiter, GetTypeRequest request, LifecycleState ... targetStates) {
        final HashSet<LifecycleState> targetStatesSet = new HashSet<LifecycleState>(Arrays.asList(targetStates));
        return new SimpleWaiterImpl(this.executorService, waiter.toCallable(Suppliers.ofInstance((Object)((Object)request)), (Function)new Function<GetTypeRequest, GetTypeResponse>(){

            public GetTypeResponse apply(GetTypeRequest request) {
                return DataCatalogWaiters.this.client.getType(request);
            }
        }, (Predicate)new Predicate<GetTypeResponse>(){

            public boolean apply(GetTypeResponse response) {
                return targetStatesSet.contains((Object)response.getType().getLifecycleState());
            }
        }, targetStatesSet.contains((Object)LifecycleState.Deleted)), (Object)request);
    }

    public Waiter<GetWorkRequestRequest, GetWorkRequestResponse> forWorkRequest(GetWorkRequestRequest request) {
        return this.forWorkRequest(Waiters.DEFAULT_POLLING_WAITER, request);
    }

    public Waiter<GetWorkRequestRequest, GetWorkRequestResponse> forWorkRequest(GetWorkRequestRequest request, TerminationStrategy terminationStrategy, DelayStrategy delayStrategy) {
        return this.forWorkRequest(Waiters.newWaiter((TerminationStrategy)terminationStrategy, (DelayStrategy)delayStrategy), request);
    }

    private Waiter<GetWorkRequestRequest, GetWorkRequestResponse> forWorkRequest(BmcGenericWaiter waiter, GetWorkRequestRequest request) {
        return new SimpleWaiterImpl(this.executorService, waiter.toCallable(Suppliers.ofInstance((Object)((Object)request)), (Function)new Function<GetWorkRequestRequest, GetWorkRequestResponse>(){

            public GetWorkRequestResponse apply(GetWorkRequestRequest request) {
                return DataCatalogWaiters.this.client.getWorkRequest(request);
            }
        }, (Predicate)new Predicate<GetWorkRequestResponse>(){

            public boolean apply(GetWorkRequestResponse response) {
                return response.getWorkRequest().getTimeFinished() != null;
            }
        }, false), (Object)request);
    }

    @ConstructorProperties(value={"executorService", "client"})
    public DataCatalogWaiters(ExecutorService executorService, DataCatalog client) {
        this.executorService = executorService;
        this.client = client;
    }
}

