/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.datacatalog.internal.http;

import com.google.common.base.Function;
import com.google.common.base.Optional;
import com.oracle.bmc.datacatalog.model.CatalogPrivateEndpoint;
import com.oracle.bmc.datacatalog.requests.GetCatalogPrivateEndpointRequest;
import com.oracle.bmc.datacatalog.responses.GetCatalogPrivateEndpointResponse;
import com.oracle.bmc.http.internal.HeaderUtils;
import com.oracle.bmc.http.internal.ResponseConversionFunctionFactory;
import com.oracle.bmc.http.internal.ResponseHelper;
import com.oracle.bmc.http.internal.RestClient;
import com.oracle.bmc.http.internal.WithHeaders;
import com.oracle.bmc.http.internal.WrappedInvocationBuilder;
import com.oracle.bmc.http.internal.WrappedWebTarget;
import com.oracle.bmc.util.internal.HttpUtils;
import java.util.List;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.Response;
import org.apache.commons.lang3.Validate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GetCatalogPrivateEndpointConverter {
    private static final Logger LOG = LoggerFactory.getLogger(GetCatalogPrivateEndpointConverter.class);
    private static final ResponseConversionFunctionFactory RESPONSE_CONVERSION_FACTORY = new ResponseConversionFunctionFactory();

    public static GetCatalogPrivateEndpointRequest interceptRequest(GetCatalogPrivateEndpointRequest request) {
        return request;
    }

    public static WrappedInvocationBuilder fromRequest(RestClient client, GetCatalogPrivateEndpointRequest request) {
        Validate.notNull((Object)((Object)request), (String)"request instance is required", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)request.getCatalogPrivateEndpointId(), (String)"catalogPrivateEndpointId must not be blank", (Object[])new Object[0]);
        WrappedWebTarget target = client.getBaseTarget().path("/20190325").path("catalogPrivateEndpoints").path(HttpUtils.encodePathSegment((String)request.getCatalogPrivateEndpointId()));
        WrappedInvocationBuilder ib = target.request();
        ib.accept(new String[]{"application/json"});
        if (request.getOpcRequestId() != null) {
            ib.header("opc-request-id", (Object)request.getOpcRequestId());
        }
        return ib;
    }

    public static Function<Response, GetCatalogPrivateEndpointResponse> fromResponse() {
        Function<Response, GetCatalogPrivateEndpointResponse> transformer = new Function<Response, GetCatalogPrivateEndpointResponse>(){

            public GetCatalogPrivateEndpointResponse apply(Response rawResponse) {
                Optional etagHeader;
                LOG.trace("Transform function invoked for com.oracle.bmc.datacatalog.responses.GetCatalogPrivateEndpointResponse");
                Function responseFn = RESPONSE_CONVERSION_FACTORY.create(CatalogPrivateEndpoint.class);
                WithHeaders response = (WithHeaders)responseFn.apply((Object)rawResponse);
                MultivaluedMap headers = response.getHeaders();
                GetCatalogPrivateEndpointResponse.Builder builder = GetCatalogPrivateEndpointResponse.builder().__httpStatusCode__(rawResponse.getStatus());
                builder.catalogPrivateEndpoint((CatalogPrivateEndpoint)response.getItem());
                Optional opcRequestIdHeader = HeaderUtils.get((MultivaluedMap)headers, (String)"opc-request-id");
                if (opcRequestIdHeader.isPresent()) {
                    builder.opcRequestId((String)HeaderUtils.toValue((String)"opc-request-id", (String)((String)((List)opcRequestIdHeader.get()).get(0)), String.class));
                }
                if ((etagHeader = HeaderUtils.get((MultivaluedMap)headers, (String)"etag")).isPresent()) {
                    builder.etag((String)HeaderUtils.toValue((String)"etag", (String)((String)((List)etagHeader.get()).get(0)), String.class));
                }
                GetCatalogPrivateEndpointResponse responseWrapper = builder.build();
                ResponseHelper.closeResponseSilentlyIfNotBuffered((Response)rawResponse);
                return responseWrapper;
            }
        };
        return transformer;
    }
}

