/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.datacatalog.internal.http;

import com.google.common.base.Function;
import com.google.common.base.Optional;
import com.oracle.bmc.datacatalog.model.DataAsset;
import com.oracle.bmc.datacatalog.requests.GetDataAssetRequest;
import com.oracle.bmc.datacatalog.responses.GetDataAssetResponse;
import com.oracle.bmc.http.internal.HeaderUtils;
import com.oracle.bmc.http.internal.ResponseConversionFunctionFactory;
import com.oracle.bmc.http.internal.ResponseHelper;
import com.oracle.bmc.http.internal.RestClient;
import com.oracle.bmc.http.internal.WithHeaders;
import com.oracle.bmc.http.internal.WrappedInvocationBuilder;
import com.oracle.bmc.http.internal.WrappedWebTarget;
import com.oracle.bmc.util.internal.CollectionFormatType;
import com.oracle.bmc.util.internal.HttpUtils;
import java.util.List;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.Response;
import org.apache.commons.lang3.Validate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GetDataAssetConverter {
    private static final Logger LOG = LoggerFactory.getLogger(GetDataAssetConverter.class);
    private static final ResponseConversionFunctionFactory RESPONSE_CONVERSION_FACTORY = new ResponseConversionFunctionFactory();

    public static GetDataAssetRequest interceptRequest(GetDataAssetRequest request) {
        return request;
    }

    public static WrappedInvocationBuilder fromRequest(RestClient client, GetDataAssetRequest request) {
        Validate.notNull((Object)((Object)request), (String)"request instance is required", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)request.getCatalogId(), (String)"catalogId must not be blank", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)request.getDataAssetKey(), (String)"dataAssetKey must not be blank", (Object[])new Object[0]);
        WrappedWebTarget target = client.getBaseTarget().path("/20190325").path("catalogs").path(HttpUtils.encodePathSegment((String)request.getCatalogId())).path("dataAssets").path(HttpUtils.encodePathSegment((String)request.getDataAssetKey()));
        if (request.getFields() != null) {
            target = HttpUtils.encodeCollectionFormatQueryParam((WrappedWebTarget)target, (String)"fields", request.getFields(), (CollectionFormatType)CollectionFormatType.Multi);
        }
        WrappedInvocationBuilder ib = target.request();
        ib.accept(new String[]{"application/json"});
        if (request.getOpcRequestId() != null) {
            ib.header("opc-request-id", (Object)request.getOpcRequestId());
        }
        return ib;
    }

    public static Function<Response, GetDataAssetResponse> fromResponse() {
        Function<Response, GetDataAssetResponse> transformer = new Function<Response, GetDataAssetResponse>(){

            public GetDataAssetResponse apply(Response rawResponse) {
                Optional opcRequestIdHeader;
                LOG.trace("Transform function invoked for com.oracle.bmc.datacatalog.responses.GetDataAssetResponse");
                Function responseFn = RESPONSE_CONVERSION_FACTORY.create(DataAsset.class);
                WithHeaders response = (WithHeaders)responseFn.apply((Object)rawResponse);
                MultivaluedMap headers = response.getHeaders();
                GetDataAssetResponse.Builder builder = GetDataAssetResponse.builder().__httpStatusCode__(rawResponse.getStatus());
                builder.dataAsset((DataAsset)response.getItem());
                Optional etagHeader = HeaderUtils.get((MultivaluedMap)headers, (String)"etag");
                if (etagHeader.isPresent()) {
                    builder.etag((String)HeaderUtils.toValue((String)"etag", (String)((String)((List)etagHeader.get()).get(0)), String.class));
                }
                if ((opcRequestIdHeader = HeaderUtils.get((MultivaluedMap)headers, (String)"opc-request-id")).isPresent()) {
                    builder.opcRequestId((String)HeaderUtils.toValue((String)"opc-request-id", (String)((String)((List)opcRequestIdHeader.get()).get(0)), String.class));
                }
                GetDataAssetResponse responseWrapper = builder.build();
                ResponseHelper.closeResponseSilentlyIfNotBuffered((Response)rawResponse);
                return responseWrapper;
            }
        };
        return transformer;
    }
}

