/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.datacatalog.internal.http;

import com.google.common.base.Function;
import com.google.common.base.Optional;
import com.oracle.bmc.datacatalog.model.TermRelationship;
import com.oracle.bmc.datacatalog.requests.GetTermRelationshipRequest;
import com.oracle.bmc.datacatalog.responses.GetTermRelationshipResponse;
import com.oracle.bmc.http.internal.HeaderUtils;
import com.oracle.bmc.http.internal.ResponseConversionFunctionFactory;
import com.oracle.bmc.http.internal.ResponseHelper;
import com.oracle.bmc.http.internal.RestClient;
import com.oracle.bmc.http.internal.WithHeaders;
import com.oracle.bmc.http.internal.WrappedInvocationBuilder;
import com.oracle.bmc.http.internal.WrappedWebTarget;
import com.oracle.bmc.util.internal.CollectionFormatType;
import com.oracle.bmc.util.internal.HttpUtils;
import java.util.List;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.Response;
import org.apache.commons.lang3.Validate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GetTermRelationshipConverter {
    private static final Logger LOG = LoggerFactory.getLogger(GetTermRelationshipConverter.class);
    private static final ResponseConversionFunctionFactory RESPONSE_CONVERSION_FACTORY = new ResponseConversionFunctionFactory();

    public static GetTermRelationshipRequest interceptRequest(GetTermRelationshipRequest request) {
        return request;
    }

    public static WrappedInvocationBuilder fromRequest(RestClient client, GetTermRelationshipRequest request) {
        Validate.notNull((Object)((Object)request), (String)"request instance is required", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)request.getCatalogId(), (String)"catalogId must not be blank", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)request.getGlossaryKey(), (String)"glossaryKey must not be blank", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)request.getTermKey(), (String)"termKey must not be blank", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)request.getTermRelationshipKey(), (String)"termRelationshipKey must not be blank", (Object[])new Object[0]);
        WrappedWebTarget target = client.getBaseTarget().path("/20190325").path("catalogs").path(HttpUtils.encodePathSegment((String)request.getCatalogId())).path("glossaries").path(HttpUtils.encodePathSegment((String)request.getGlossaryKey())).path("terms").path(HttpUtils.encodePathSegment((String)request.getTermKey())).path("termRelationships").path(HttpUtils.encodePathSegment((String)request.getTermRelationshipKey()));
        if (request.getFields() != null) {
            target = HttpUtils.encodeCollectionFormatQueryParam((WrappedWebTarget)target, (String)"fields", request.getFields(), (CollectionFormatType)CollectionFormatType.Multi);
        }
        WrappedInvocationBuilder ib = target.request();
        ib.accept(new String[]{"application/json"});
        if (request.getOpcRequestId() != null) {
            ib.header("opc-request-id", (Object)request.getOpcRequestId());
        }
        return ib;
    }

    public static Function<Response, GetTermRelationshipResponse> fromResponse() {
        Function<Response, GetTermRelationshipResponse> transformer = new Function<Response, GetTermRelationshipResponse>(){

            public GetTermRelationshipResponse apply(Response rawResponse) {
                Optional opcRequestIdHeader;
                LOG.trace("Transform function invoked for com.oracle.bmc.datacatalog.responses.GetTermRelationshipResponse");
                Function responseFn = RESPONSE_CONVERSION_FACTORY.create(TermRelationship.class);
                WithHeaders response = (WithHeaders)responseFn.apply((Object)rawResponse);
                MultivaluedMap headers = response.getHeaders();
                GetTermRelationshipResponse.Builder builder = GetTermRelationshipResponse.builder().__httpStatusCode__(rawResponse.getStatus());
                builder.termRelationship((TermRelationship)response.getItem());
                Optional etagHeader = HeaderUtils.get((MultivaluedMap)headers, (String)"etag");
                if (etagHeader.isPresent()) {
                    builder.etag((String)HeaderUtils.toValue((String)"etag", (String)((String)((List)etagHeader.get()).get(0)), String.class));
                }
                if ((opcRequestIdHeader = HeaderUtils.get((MultivaluedMap)headers, (String)"opc-request-id")).isPresent()) {
                    builder.opcRequestId((String)HeaderUtils.toValue((String)"opc-request-id", (String)((String)((List)opcRequestIdHeader.get()).get(0)), String.class));
                }
                GetTermRelationshipResponse responseWrapper = builder.build();
                ResponseHelper.closeResponseSilentlyIfNotBuffered((Response)rawResponse);
                return responseWrapper;
            }
        };
        return transformer;
    }
}

