/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.datacatalog.internal.http;

import com.google.common.base.Function;
import com.google.common.base.Optional;
import com.oracle.bmc.datacatalog.model.CustomPropertyCollection;
import com.oracle.bmc.datacatalog.requests.ListCustomPropertiesRequest;
import com.oracle.bmc.datacatalog.responses.ListCustomPropertiesResponse;
import com.oracle.bmc.http.internal.HeaderUtils;
import com.oracle.bmc.http.internal.ResponseConversionFunctionFactory;
import com.oracle.bmc.http.internal.ResponseHelper;
import com.oracle.bmc.http.internal.RestClient;
import com.oracle.bmc.http.internal.WithHeaders;
import com.oracle.bmc.http.internal.WrappedInvocationBuilder;
import com.oracle.bmc.http.internal.WrappedWebTarget;
import com.oracle.bmc.util.internal.CollectionFormatType;
import com.oracle.bmc.util.internal.HttpUtils;
import java.util.List;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.Response;
import org.apache.commons.lang3.Validate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ListCustomPropertiesConverter {
    private static final Logger LOG = LoggerFactory.getLogger(ListCustomPropertiesConverter.class);
    private static final ResponseConversionFunctionFactory RESPONSE_CONVERSION_FACTORY = new ResponseConversionFunctionFactory();

    public static ListCustomPropertiesRequest interceptRequest(ListCustomPropertiesRequest request) {
        return request;
    }

    public static WrappedInvocationBuilder fromRequest(RestClient client, ListCustomPropertiesRequest request) {
        Validate.notNull((Object)((Object)request), (String)"request instance is required", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)request.getCatalogId(), (String)"catalogId must not be blank", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)request.getNamespaceId(), (String)"namespaceId must not be blank", (Object[])new Object[0]);
        WrappedWebTarget target = client.getBaseTarget().path("/20190325").path("catalogs").path(HttpUtils.encodePathSegment((String)request.getCatalogId())).path("namespaces").path(HttpUtils.encodePathSegment((String)request.getNamespaceId())).path("customProperties");
        if (request.getDisplayName() != null) {
            target = target.queryParam("displayName", new Object[]{HttpUtils.attemptEncodeQueryParam((Object)request.getDisplayName())});
        }
        if (request.getDisplayNameContains() != null) {
            target = target.queryParam("displayNameContains", new Object[]{HttpUtils.attemptEncodeQueryParam((Object)request.getDisplayNameContains())});
        }
        if (request.getDataTypes() != null) {
            target = HttpUtils.encodeCollectionFormatQueryParam((WrappedWebTarget)target, (String)"dataTypes", request.getDataTypes(), (CollectionFormatType)CollectionFormatType.Multi);
        }
        if (request.getTypeName() != null) {
            target = HttpUtils.encodeCollectionFormatQueryParam((WrappedWebTarget)target, (String)"typeName", request.getTypeName(), (CollectionFormatType)CollectionFormatType.Multi);
        }
        if (request.getLifecycleState() != null) {
            target = target.queryParam("lifecycleState", new Object[]{HttpUtils.attemptEncodeQueryParam((Object)request.getLifecycleState().getValue())});
        }
        if (request.getTimeCreated() != null) {
            target = target.queryParam("timeCreated", new Object[]{HttpUtils.attemptEncodeQueryParam((Object)request.getTimeCreated())});
        }
        if (request.getTimeUpdated() != null) {
            target = target.queryParam("timeUpdated", new Object[]{HttpUtils.attemptEncodeQueryParam((Object)request.getTimeUpdated())});
        }
        if (request.getCreatedById() != null) {
            target = target.queryParam("createdById", new Object[]{HttpUtils.attemptEncodeQueryParam((Object)request.getCreatedById())});
        }
        if (request.getUpdatedById() != null) {
            target = target.queryParam("updatedById", new Object[]{HttpUtils.attemptEncodeQueryParam((Object)request.getUpdatedById())});
        }
        if (request.getFields() != null) {
            target = HttpUtils.encodeCollectionFormatQueryParam((WrappedWebTarget)target, (String)"fields", request.getFields(), (CollectionFormatType)CollectionFormatType.Multi);
        }
        if (request.getSortOrder() != null) {
            target = target.queryParam("sortOrder", new Object[]{HttpUtils.attemptEncodeQueryParam((Object)request.getSortOrder().getValue())});
        }
        if (request.getSortBy() != null) {
            target = target.queryParam("sortBy", new Object[]{HttpUtils.attemptEncodeQueryParam((Object)request.getSortBy().getValue())});
        }
        if (request.getLimit() != null) {
            target = target.queryParam("limit", new Object[]{HttpUtils.attemptEncodeQueryParam((Object)request.getLimit())});
        }
        if (request.getPage() != null) {
            target = target.queryParam("page", new Object[]{HttpUtils.attemptEncodeQueryParam((Object)request.getPage())});
        }
        WrappedInvocationBuilder ib = target.request();
        ib.accept(new String[]{"application/json"});
        if (request.getOpcRequestId() != null) {
            ib.header("opc-request-id", (Object)request.getOpcRequestId());
        }
        return ib;
    }

    public static Function<Response, ListCustomPropertiesResponse> fromResponse() {
        Function<Response, ListCustomPropertiesResponse> transformer = new Function<Response, ListCustomPropertiesResponse>(){

            public ListCustomPropertiesResponse apply(Response rawResponse) {
                Optional opcNextPageHeader;
                LOG.trace("Transform function invoked for com.oracle.bmc.datacatalog.responses.ListCustomPropertiesResponse");
                Function responseFn = RESPONSE_CONVERSION_FACTORY.create(CustomPropertyCollection.class);
                WithHeaders response = (WithHeaders)responseFn.apply((Object)rawResponse);
                MultivaluedMap headers = response.getHeaders();
                ListCustomPropertiesResponse.Builder builder = ListCustomPropertiesResponse.builder().__httpStatusCode__(rawResponse.getStatus());
                builder.customPropertyCollection((CustomPropertyCollection)response.getItem());
                Optional opcRequestIdHeader = HeaderUtils.get((MultivaluedMap)headers, (String)"opc-request-id");
                if (opcRequestIdHeader.isPresent()) {
                    builder.opcRequestId((String)HeaderUtils.toValue((String)"opc-request-id", (String)((String)((List)opcRequestIdHeader.get()).get(0)), String.class));
                }
                if ((opcNextPageHeader = HeaderUtils.get((MultivaluedMap)headers, (String)"opc-next-page")).isPresent()) {
                    builder.opcNextPage((String)HeaderUtils.toValue((String)"opc-next-page", (String)((String)((List)opcNextPageHeader.get()).get(0)), String.class));
                }
                ListCustomPropertiesResponse responseWrapper = builder.build();
                ResponseHelper.closeResponseSilentlyIfNotBuffered((Response)rawResponse);
                return responseWrapper;
            }
        };
        return transformer;
    }
}

