/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.datacatalog.internal.http;

import com.google.common.base.Function;
import com.google.common.base.Optional;
import com.oracle.bmc.datacatalog.model.FolderCollection;
import com.oracle.bmc.datacatalog.requests.ListFoldersRequest;
import com.oracle.bmc.datacatalog.responses.ListFoldersResponse;
import com.oracle.bmc.http.internal.HeaderUtils;
import com.oracle.bmc.http.internal.ResponseConversionFunctionFactory;
import com.oracle.bmc.http.internal.ResponseHelper;
import com.oracle.bmc.http.internal.RestClient;
import com.oracle.bmc.http.internal.WithHeaders;
import com.oracle.bmc.http.internal.WrappedInvocationBuilder;
import com.oracle.bmc.http.internal.WrappedWebTarget;
import com.oracle.bmc.util.internal.CollectionFormatType;
import com.oracle.bmc.util.internal.HttpUtils;
import java.util.List;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.Response;
import org.apache.commons.lang3.Validate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ListFoldersConverter {
    private static final Logger LOG = LoggerFactory.getLogger(ListFoldersConverter.class);
    private static final ResponseConversionFunctionFactory RESPONSE_CONVERSION_FACTORY = new ResponseConversionFunctionFactory();

    public static ListFoldersRequest interceptRequest(ListFoldersRequest request) {
        return request;
    }

    public static WrappedInvocationBuilder fromRequest(RestClient client, ListFoldersRequest request) {
        Validate.notNull((Object)((Object)request), (String)"request instance is required", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)request.getCatalogId(), (String)"catalogId must not be blank", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)request.getDataAssetKey(), (String)"dataAssetKey must not be blank", (Object[])new Object[0]);
        WrappedWebTarget target = client.getBaseTarget().path("/20190325").path("catalogs").path(HttpUtils.encodePathSegment((String)request.getCatalogId())).path("dataAssets").path(HttpUtils.encodePathSegment((String)request.getDataAssetKey())).path("folders");
        if (request.getDisplayName() != null) {
            target = target.queryParam("displayName", new Object[]{HttpUtils.attemptEncodeQueryParam((Object)request.getDisplayName())});
        }
        if (request.getDisplayNameContains() != null) {
            target = target.queryParam("displayNameContains", new Object[]{HttpUtils.attemptEncodeQueryParam((Object)request.getDisplayNameContains())});
        }
        if (request.getLifecycleState() != null) {
            target = target.queryParam("lifecycleState", new Object[]{HttpUtils.attemptEncodeQueryParam((Object)request.getLifecycleState().getValue())});
        }
        if (request.getParentFolderKey() != null) {
            target = target.queryParam("parentFolderKey", new Object[]{HttpUtils.attemptEncodeQueryParam((Object)request.getParentFolderKey())});
        }
        if (request.getPath() != null) {
            target = target.queryParam("path", new Object[]{HttpUtils.attemptEncodeQueryParam((Object)request.getPath())});
        }
        if (request.getExternalKey() != null) {
            target = target.queryParam("externalKey", new Object[]{HttpUtils.attemptEncodeQueryParam((Object)request.getExternalKey())});
        }
        if (request.getTimeCreated() != null) {
            target = target.queryParam("timeCreated", new Object[]{HttpUtils.attemptEncodeQueryParam((Object)request.getTimeCreated())});
        }
        if (request.getTimeUpdated() != null) {
            target = target.queryParam("timeUpdated", new Object[]{HttpUtils.attemptEncodeQueryParam((Object)request.getTimeUpdated())});
        }
        if (request.getCreatedById() != null) {
            target = target.queryParam("createdById", new Object[]{HttpUtils.attemptEncodeQueryParam((Object)request.getCreatedById())});
        }
        if (request.getUpdatedById() != null) {
            target = target.queryParam("updatedById", new Object[]{HttpUtils.attemptEncodeQueryParam((Object)request.getUpdatedById())});
        }
        if (request.getHarvestStatus() != null) {
            target = target.queryParam("harvestStatus", new Object[]{HttpUtils.attemptEncodeQueryParam((Object)request.getHarvestStatus().getValue())});
        }
        if (request.getLastJobKey() != null) {
            target = target.queryParam("lastJobKey", new Object[]{HttpUtils.attemptEncodeQueryParam((Object)request.getLastJobKey())});
        }
        if (request.getFields() != null) {
            target = HttpUtils.encodeCollectionFormatQueryParam((WrappedWebTarget)target, (String)"fields", request.getFields(), (CollectionFormatType)CollectionFormatType.Multi);
        }
        if (request.getSortBy() != null) {
            target = target.queryParam("sortBy", new Object[]{HttpUtils.attemptEncodeQueryParam((Object)request.getSortBy().getValue())});
        }
        if (request.getSortOrder() != null) {
            target = target.queryParam("sortOrder", new Object[]{HttpUtils.attemptEncodeQueryParam((Object)request.getSortOrder().getValue())});
        }
        if (request.getLimit() != null) {
            target = target.queryParam("limit", new Object[]{HttpUtils.attemptEncodeQueryParam((Object)request.getLimit())});
        }
        if (request.getPage() != null) {
            target = target.queryParam("page", new Object[]{HttpUtils.attemptEncodeQueryParam((Object)request.getPage())});
        }
        WrappedInvocationBuilder ib = target.request();
        ib.accept(new String[]{"application/json"});
        if (request.getOpcRequestId() != null) {
            ib.header("opc-request-id", (Object)request.getOpcRequestId());
        }
        return ib;
    }

    public static Function<Response, ListFoldersResponse> fromResponse() {
        Function<Response, ListFoldersResponse> transformer = new Function<Response, ListFoldersResponse>(){

            public ListFoldersResponse apply(Response rawResponse) {
                Optional opcNextPageHeader;
                LOG.trace("Transform function invoked for com.oracle.bmc.datacatalog.responses.ListFoldersResponse");
                Function responseFn = RESPONSE_CONVERSION_FACTORY.create(FolderCollection.class);
                WithHeaders response = (WithHeaders)responseFn.apply((Object)rawResponse);
                MultivaluedMap headers = response.getHeaders();
                ListFoldersResponse.Builder builder = ListFoldersResponse.builder().__httpStatusCode__(rawResponse.getStatus());
                builder.folderCollection((FolderCollection)response.getItem());
                Optional opcRequestIdHeader = HeaderUtils.get((MultivaluedMap)headers, (String)"opc-request-id");
                if (opcRequestIdHeader.isPresent()) {
                    builder.opcRequestId((String)HeaderUtils.toValue((String)"opc-request-id", (String)((String)((List)opcRequestIdHeader.get()).get(0)), String.class));
                }
                if ((opcNextPageHeader = HeaderUtils.get((MultivaluedMap)headers, (String)"opc-next-page")).isPresent()) {
                    builder.opcNextPage((String)HeaderUtils.toValue((String)"opc-next-page", (String)((String)((List)opcNextPageHeader.get()).get(0)), String.class));
                }
                ListFoldersResponse responseWrapper = builder.build();
                ResponseHelper.closeResponseSilentlyIfNotBuffered((Response)rawResponse);
                return responseWrapper;
            }
        };
        return transformer;
    }
}

