/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.datacatalog.internal.http;

import com.google.common.base.Function;
import com.google.common.base.Optional;
import com.oracle.bmc.datacatalog.model.JobMetricCollection;
import com.oracle.bmc.datacatalog.requests.ListJobMetricsRequest;
import com.oracle.bmc.datacatalog.responses.ListJobMetricsResponse;
import com.oracle.bmc.http.internal.HeaderUtils;
import com.oracle.bmc.http.internal.ResponseConversionFunctionFactory;
import com.oracle.bmc.http.internal.ResponseHelper;
import com.oracle.bmc.http.internal.RestClient;
import com.oracle.bmc.http.internal.WithHeaders;
import com.oracle.bmc.http.internal.WrappedInvocationBuilder;
import com.oracle.bmc.http.internal.WrappedWebTarget;
import com.oracle.bmc.util.internal.CollectionFormatType;
import com.oracle.bmc.util.internal.HttpUtils;
import java.util.List;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.Response;
import org.apache.commons.lang3.Validate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ListJobMetricsConverter {
    private static final Logger LOG = LoggerFactory.getLogger(ListJobMetricsConverter.class);
    private static final ResponseConversionFunctionFactory RESPONSE_CONVERSION_FACTORY = new ResponseConversionFunctionFactory();

    public static ListJobMetricsRequest interceptRequest(ListJobMetricsRequest request) {
        return request;
    }

    public static WrappedInvocationBuilder fromRequest(RestClient client, ListJobMetricsRequest request) {
        Validate.notNull((Object)((Object)request), (String)"request instance is required", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)request.getCatalogId(), (String)"catalogId must not be blank", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)request.getJobKey(), (String)"jobKey must not be blank", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)request.getJobExecutionKey(), (String)"jobExecutionKey must not be blank", (Object[])new Object[0]);
        WrappedWebTarget target = client.getBaseTarget().path("/20190325").path("catalogs").path(HttpUtils.encodePathSegment((String)request.getCatalogId())).path("jobs").path(HttpUtils.encodePathSegment((String)request.getJobKey())).path("executions").path(HttpUtils.encodePathSegment((String)request.getJobExecutionKey())).path("metrics");
        if (request.getDisplayName() != null) {
            target = target.queryParam("displayName", new Object[]{HttpUtils.attemptEncodeQueryParam((Object)request.getDisplayName())});
        }
        if (request.getDisplayNameContains() != null) {
            target = target.queryParam("displayNameContains", new Object[]{HttpUtils.attemptEncodeQueryParam((Object)request.getDisplayNameContains())});
        }
        if (request.getCategory() != null) {
            target = target.queryParam("category", new Object[]{HttpUtils.attemptEncodeQueryParam((Object)request.getCategory())});
        }
        if (request.getSubCategory() != null) {
            target = target.queryParam("subCategory", new Object[]{HttpUtils.attemptEncodeQueryParam((Object)request.getSubCategory())});
        }
        if (request.getUnit() != null) {
            target = target.queryParam("unit", new Object[]{HttpUtils.attemptEncodeQueryParam((Object)request.getUnit())});
        }
        if (request.getValue() != null) {
            target = target.queryParam("value", new Object[]{HttpUtils.attemptEncodeQueryParam((Object)request.getValue())});
        }
        if (request.getBatchKey() != null) {
            target = target.queryParam("batchKey", new Object[]{HttpUtils.attemptEncodeQueryParam((Object)request.getBatchKey())});
        }
        if (request.getTimeCreated() != null) {
            target = target.queryParam("timeCreated", new Object[]{HttpUtils.attemptEncodeQueryParam((Object)request.getTimeCreated())});
        }
        if (request.getTimeUpdated() != null) {
            target = target.queryParam("timeUpdated", new Object[]{HttpUtils.attemptEncodeQueryParam((Object)request.getTimeUpdated())});
        }
        if (request.getTimeInserted() != null) {
            target = target.queryParam("timeInserted", new Object[]{HttpUtils.attemptEncodeQueryParam((Object)request.getTimeInserted())});
        }
        if (request.getCreatedById() != null) {
            target = target.queryParam("createdById", new Object[]{HttpUtils.attemptEncodeQueryParam((Object)request.getCreatedById())});
        }
        if (request.getUpdatedById() != null) {
            target = target.queryParam("updatedById", new Object[]{HttpUtils.attemptEncodeQueryParam((Object)request.getUpdatedById())});
        }
        if (request.getFields() != null) {
            target = HttpUtils.encodeCollectionFormatQueryParam((WrappedWebTarget)target, (String)"fields", request.getFields(), (CollectionFormatType)CollectionFormatType.Multi);
        }
        if (request.getSortBy() != null) {
            target = target.queryParam("sortBy", new Object[]{HttpUtils.attemptEncodeQueryParam((Object)request.getSortBy().getValue())});
        }
        if (request.getSortOrder() != null) {
            target = target.queryParam("sortOrder", new Object[]{HttpUtils.attemptEncodeQueryParam((Object)request.getSortOrder().getValue())});
        }
        if (request.getLimit() != null) {
            target = target.queryParam("limit", new Object[]{HttpUtils.attemptEncodeQueryParam((Object)request.getLimit())});
        }
        if (request.getPage() != null) {
            target = target.queryParam("page", new Object[]{HttpUtils.attemptEncodeQueryParam((Object)request.getPage())});
        }
        WrappedInvocationBuilder ib = target.request();
        ib.accept(new String[]{"application/json"});
        if (request.getOpcRequestId() != null) {
            ib.header("opc-request-id", (Object)request.getOpcRequestId());
        }
        return ib;
    }

    public static Function<Response, ListJobMetricsResponse> fromResponse() {
        Function<Response, ListJobMetricsResponse> transformer = new Function<Response, ListJobMetricsResponse>(){

            public ListJobMetricsResponse apply(Response rawResponse) {
                Optional opcNextPageHeader;
                LOG.trace("Transform function invoked for com.oracle.bmc.datacatalog.responses.ListJobMetricsResponse");
                Function responseFn = RESPONSE_CONVERSION_FACTORY.create(JobMetricCollection.class);
                WithHeaders response = (WithHeaders)responseFn.apply((Object)rawResponse);
                MultivaluedMap headers = response.getHeaders();
                ListJobMetricsResponse.Builder builder = ListJobMetricsResponse.builder().__httpStatusCode__(rawResponse.getStatus());
                builder.jobMetricCollection((JobMetricCollection)response.getItem());
                Optional opcRequestIdHeader = HeaderUtils.get((MultivaluedMap)headers, (String)"opc-request-id");
                if (opcRequestIdHeader.isPresent()) {
                    builder.opcRequestId((String)HeaderUtils.toValue((String)"opc-request-id", (String)((String)((List)opcRequestIdHeader.get()).get(0)), String.class));
                }
                if ((opcNextPageHeader = HeaderUtils.get((MultivaluedMap)headers, (String)"opc-next-page")).isPresent()) {
                    builder.opcNextPage((String)HeaderUtils.toValue((String)"opc-next-page", (String)((String)((List)opcNextPageHeader.get()).get(0)), String.class));
                }
                ListJobMetricsResponse responseWrapper = builder.build();
                ResponseHelper.closeResponseSilentlyIfNotBuffered((Response)rawResponse);
                return responseWrapper;
            }
        };
        return transformer;
    }
}

