/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.datacatalog.internal.http;

import com.google.common.base.Function;
import com.google.common.base.Optional;
import com.oracle.bmc.datacatalog.model.TypeCollection;
import com.oracle.bmc.datacatalog.requests.ListTypesRequest;
import com.oracle.bmc.datacatalog.responses.ListTypesResponse;
import com.oracle.bmc.http.internal.HeaderUtils;
import com.oracle.bmc.http.internal.ResponseConversionFunctionFactory;
import com.oracle.bmc.http.internal.ResponseHelper;
import com.oracle.bmc.http.internal.RestClient;
import com.oracle.bmc.http.internal.WithHeaders;
import com.oracle.bmc.http.internal.WrappedInvocationBuilder;
import com.oracle.bmc.http.internal.WrappedWebTarget;
import com.oracle.bmc.util.internal.CollectionFormatType;
import com.oracle.bmc.util.internal.HttpUtils;
import java.util.List;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.Response;
import org.apache.commons.lang3.Validate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ListTypesConverter {
    private static final Logger LOG = LoggerFactory.getLogger(ListTypesConverter.class);
    private static final ResponseConversionFunctionFactory RESPONSE_CONVERSION_FACTORY = new ResponseConversionFunctionFactory();

    public static ListTypesRequest interceptRequest(ListTypesRequest request) {
        return request;
    }

    public static WrappedInvocationBuilder fromRequest(RestClient client, ListTypesRequest request) {
        Validate.notNull((Object)((Object)request), (String)"request instance is required", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)request.getCatalogId(), (String)"catalogId must not be blank", (Object[])new Object[0]);
        WrappedWebTarget target = client.getBaseTarget().path("/20190325").path("catalogs").path(HttpUtils.encodePathSegment((String)request.getCatalogId())).path("types");
        if (request.getName() != null) {
            target = target.queryParam("name", new Object[]{HttpUtils.attemptEncodeQueryParam((Object)request.getName())});
        }
        if (request.getLifecycleState() != null) {
            target = target.queryParam("lifecycleState", new Object[]{HttpUtils.attemptEncodeQueryParam((Object)request.getLifecycleState().getValue())});
        }
        if (request.getIsInternal() != null) {
            target = target.queryParam("isInternal", new Object[]{HttpUtils.attemptEncodeQueryParam((Object)request.getIsInternal())});
        }
        if (request.getIsTag() != null) {
            target = target.queryParam("isTag", new Object[]{HttpUtils.attemptEncodeQueryParam((Object)request.getIsTag())});
        }
        if (request.getIsApproved() != null) {
            target = target.queryParam("isApproved", new Object[]{HttpUtils.attemptEncodeQueryParam((Object)request.getIsApproved())});
        }
        if (request.getExternalTypeName() != null) {
            target = target.queryParam("externalTypeName", new Object[]{HttpUtils.attemptEncodeQueryParam((Object)request.getExternalTypeName())});
        }
        if (request.getTypeCategory() != null) {
            target = target.queryParam("typeCategory", new Object[]{HttpUtils.attemptEncodeQueryParam((Object)request.getTypeCategory())});
        }
        if (request.getFields() != null) {
            target = HttpUtils.encodeCollectionFormatQueryParam((WrappedWebTarget)target, (String)"fields", request.getFields(), (CollectionFormatType)CollectionFormatType.Multi);
        }
        if (request.getSortBy() != null) {
            target = target.queryParam("sortBy", new Object[]{HttpUtils.attemptEncodeQueryParam((Object)request.getSortBy().getValue())});
        }
        if (request.getSortOrder() != null) {
            target = target.queryParam("sortOrder", new Object[]{HttpUtils.attemptEncodeQueryParam((Object)request.getSortOrder().getValue())});
        }
        if (request.getLimit() != null) {
            target = target.queryParam("limit", new Object[]{HttpUtils.attemptEncodeQueryParam((Object)request.getLimit())});
        }
        if (request.getPage() != null) {
            target = target.queryParam("page", new Object[]{HttpUtils.attemptEncodeQueryParam((Object)request.getPage())});
        }
        WrappedInvocationBuilder ib = target.request();
        ib.accept(new String[]{"application/json"});
        if (request.getOpcRequestId() != null) {
            ib.header("opc-request-id", (Object)request.getOpcRequestId());
        }
        return ib;
    }

    public static Function<Response, ListTypesResponse> fromResponse() {
        Function<Response, ListTypesResponse> transformer = new Function<Response, ListTypesResponse>(){

            public ListTypesResponse apply(Response rawResponse) {
                Optional opcNextPageHeader;
                LOG.trace("Transform function invoked for com.oracle.bmc.datacatalog.responses.ListTypesResponse");
                Function responseFn = RESPONSE_CONVERSION_FACTORY.create(TypeCollection.class);
                WithHeaders response = (WithHeaders)responseFn.apply((Object)rawResponse);
                MultivaluedMap headers = response.getHeaders();
                ListTypesResponse.Builder builder = ListTypesResponse.builder().__httpStatusCode__(rawResponse.getStatus());
                builder.typeCollection((TypeCollection)response.getItem());
                Optional opcRequestIdHeader = HeaderUtils.get((MultivaluedMap)headers, (String)"opc-request-id");
                if (opcRequestIdHeader.isPresent()) {
                    builder.opcRequestId((String)HeaderUtils.toValue((String)"opc-request-id", (String)((String)((List)opcRequestIdHeader.get()).get(0)), String.class));
                }
                if ((opcNextPageHeader = HeaderUtils.get((MultivaluedMap)headers, (String)"opc-next-page")).isPresent()) {
                    builder.opcNextPage((String)HeaderUtils.toValue((String)"opc-next-page", (String)((String)((List)opcNextPageHeader.get()).get(0)), String.class));
                }
                ListTypesResponse responseWrapper = builder.build();
                ResponseHelper.closeResponseSilentlyIfNotBuffered((Response)rawResponse);
                return responseWrapper;
            }
        };
        return transformer;
    }
}

