/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.datacatalog.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public enum JobType {
    Harvest("HARVEST"),
    Profiling("PROFILING"),
    Sampling("SAMPLING"),
    Preview("PREVIEW"),
    Import("IMPORT"),
    Export("EXPORT"),
    ImportGlossary("IMPORT_GLOSSARY"),
    ExportGlossary("EXPORT_GLOSSARY"),
    Internal("INTERNAL"),
    Purge("PURGE"),
    Immediate("IMMEDIATE"),
    Scheduled("SCHEDULED"),
    ImmediateExecution("IMMEDIATE_EXECUTION"),
    ScheduledExecution("SCHEDULED_EXECUTION"),
    ScheduledExecutionInstance("SCHEDULED_EXECUTION_INSTANCE"),
    AsyncDelete("ASYNC_DELETE"),
    UnknownEnumValue(null);

    private static final Logger LOG;
    private final String value;
    private static Map<String, JobType> map;

    private JobType(String value) {
        this.value = value;
    }

    @JsonValue
    public String getValue() {
        return this.value;
    }

    @JsonCreator
    public static JobType create(String key) {
        if (map.containsKey(key)) {
            return map.get(key);
        }
        LOG.warn("Received unknown value '{}' for enum 'JobType', returning UnknownEnumValue", (Object)key);
        return UnknownEnumValue;
    }

    static {
        LOG = LoggerFactory.getLogger(JobType.class);
        map = new HashMap<String, JobType>();
        for (JobType v : JobType.values()) {
            if (v == UnknownEnumValue) continue;
            map.put(v.getValue(), v);
        }
    }
}

