/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.datacatalog.requests;

import com.oracle.bmc.InternalSdk;
import com.oracle.bmc.datacatalog.model.CreateTagDetails;
import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import com.oracle.bmc.util.internal.Consumer;
import java.beans.ConstructorProperties;
import javax.ws.rs.client.Invocation;

public class CreateAttributeTagRequest
extends BmcRequest<CreateTagDetails> {
    private String catalogId;
    private String dataAssetKey;
    private String entityKey;
    private String attributeKey;
    private CreateTagDetails createAttributeTagDetails;
    private String opcRequestId;
    private String opcRetryToken;

    @InternalSdk
    public CreateTagDetails getBody$() {
        return this.createAttributeTagDetails;
    }

    @ConstructorProperties(value={"catalogId", "dataAssetKey", "entityKey", "attributeKey", "createAttributeTagDetails", "opcRequestId", "opcRetryToken"})
    CreateAttributeTagRequest(String catalogId, String dataAssetKey, String entityKey, String attributeKey, CreateTagDetails createAttributeTagDetails, String opcRequestId, String opcRetryToken) {
        this.catalogId = catalogId;
        this.dataAssetKey = dataAssetKey;
        this.entityKey = entityKey;
        this.attributeKey = attributeKey;
        this.createAttributeTagDetails = createAttributeTagDetails;
        this.opcRequestId = opcRequestId;
        this.opcRetryToken = opcRetryToken;
    }

    public static Builder builder() {
        return new Builder();
    }

    public String getCatalogId() {
        return this.catalogId;
    }

    public String getDataAssetKey() {
        return this.dataAssetKey;
    }

    public String getEntityKey() {
        return this.entityKey;
    }

    public String getAttributeKey() {
        return this.attributeKey;
    }

    public CreateTagDetails getCreateAttributeTagDetails() {
        return this.createAttributeTagDetails;
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    public String getOpcRetryToken() {
        return this.opcRetryToken;
    }

    public static class Builder
    implements BmcRequest.Builder<CreateAttributeTagRequest, CreateTagDetails> {
        private String catalogId;
        private String dataAssetKey;
        private String entityKey;
        private String attributeKey;
        private CreateTagDetails createAttributeTagDetails;
        private String opcRequestId;
        private String opcRetryToken;
        private Consumer<Invocation.Builder> invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;

        public Builder invocationCallback(Consumer<Invocation.Builder> invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(CreateAttributeTagRequest o) {
            this.catalogId(o.getCatalogId());
            this.dataAssetKey(o.getDataAssetKey());
            this.entityKey(o.getEntityKey());
            this.attributeKey(o.getAttributeKey());
            this.createAttributeTagDetails(o.getCreateAttributeTagDetails());
            this.opcRequestId(o.getOpcRequestId());
            this.opcRetryToken(o.getOpcRetryToken());
            this.invocationCallback((Consumer<Invocation.Builder>)o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public CreateAttributeTagRequest build() {
            CreateAttributeTagRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        @InternalSdk
        public Builder body$(CreateTagDetails body) {
            this.createAttributeTagDetails(body);
            return this;
        }

        Builder() {
        }

        public Builder catalogId(String catalogId) {
            this.catalogId = catalogId;
            return this;
        }

        public Builder dataAssetKey(String dataAssetKey) {
            this.dataAssetKey = dataAssetKey;
            return this;
        }

        public Builder entityKey(String entityKey) {
            this.entityKey = entityKey;
            return this;
        }

        public Builder attributeKey(String attributeKey) {
            this.attributeKey = attributeKey;
            return this;
        }

        public Builder createAttributeTagDetails(CreateTagDetails createAttributeTagDetails) {
            this.createAttributeTagDetails = createAttributeTagDetails;
            return this;
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public Builder opcRetryToken(String opcRetryToken) {
            this.opcRetryToken = opcRetryToken;
            return this;
        }

        public CreateAttributeTagRequest buildWithoutInvocationCallback() {
            return new CreateAttributeTagRequest(this.catalogId, this.dataAssetKey, this.entityKey, this.attributeKey, this.createAttributeTagDetails, this.opcRequestId, this.opcRetryToken);
        }

        public String toString() {
            return "CreateAttributeTagRequest.Builder(catalogId=" + this.catalogId + ", dataAssetKey=" + this.dataAssetKey + ", entityKey=" + this.entityKey + ", attributeKey=" + this.attributeKey + ", createAttributeTagDetails=" + this.createAttributeTagDetails + ", opcRequestId=" + this.opcRequestId + ", opcRetryToken=" + this.opcRetryToken + ")";
        }
    }
}

