/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.datacatalog.requests;

import com.oracle.bmc.InternalSdk;
import com.oracle.bmc.datacatalog.model.CreateConnectionDetails;
import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import com.oracle.bmc.util.internal.Consumer;
import java.beans.ConstructorProperties;
import javax.ws.rs.client.Invocation;

public class CreateConnectionRequest
extends BmcRequest<CreateConnectionDetails> {
    private String catalogId;
    private String dataAssetKey;
    private CreateConnectionDetails createConnectionDetails;
    private String opcRequestId;
    private String opcRetryToken;

    @InternalSdk
    public CreateConnectionDetails getBody$() {
        return this.createConnectionDetails;
    }

    @ConstructorProperties(value={"catalogId", "dataAssetKey", "createConnectionDetails", "opcRequestId", "opcRetryToken"})
    CreateConnectionRequest(String catalogId, String dataAssetKey, CreateConnectionDetails createConnectionDetails, String opcRequestId, String opcRetryToken) {
        this.catalogId = catalogId;
        this.dataAssetKey = dataAssetKey;
        this.createConnectionDetails = createConnectionDetails;
        this.opcRequestId = opcRequestId;
        this.opcRetryToken = opcRetryToken;
    }

    public static Builder builder() {
        return new Builder();
    }

    public String getCatalogId() {
        return this.catalogId;
    }

    public String getDataAssetKey() {
        return this.dataAssetKey;
    }

    public CreateConnectionDetails getCreateConnectionDetails() {
        return this.createConnectionDetails;
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    public String getOpcRetryToken() {
        return this.opcRetryToken;
    }

    public static class Builder
    implements BmcRequest.Builder<CreateConnectionRequest, CreateConnectionDetails> {
        private String catalogId;
        private String dataAssetKey;
        private CreateConnectionDetails createConnectionDetails;
        private String opcRequestId;
        private String opcRetryToken;
        private Consumer<Invocation.Builder> invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;

        public Builder invocationCallback(Consumer<Invocation.Builder> invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(CreateConnectionRequest o) {
            this.catalogId(o.getCatalogId());
            this.dataAssetKey(o.getDataAssetKey());
            this.createConnectionDetails(o.getCreateConnectionDetails());
            this.opcRequestId(o.getOpcRequestId());
            this.opcRetryToken(o.getOpcRetryToken());
            this.invocationCallback((Consumer<Invocation.Builder>)o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public CreateConnectionRequest build() {
            CreateConnectionRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        @InternalSdk
        public Builder body$(CreateConnectionDetails body) {
            this.createConnectionDetails(body);
            return this;
        }

        Builder() {
        }

        public Builder catalogId(String catalogId) {
            this.catalogId = catalogId;
            return this;
        }

        public Builder dataAssetKey(String dataAssetKey) {
            this.dataAssetKey = dataAssetKey;
            return this;
        }

        public Builder createConnectionDetails(CreateConnectionDetails createConnectionDetails) {
            this.createConnectionDetails = createConnectionDetails;
            return this;
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public Builder opcRetryToken(String opcRetryToken) {
            this.opcRetryToken = opcRetryToken;
            return this;
        }

        public CreateConnectionRequest buildWithoutInvocationCallback() {
            return new CreateConnectionRequest(this.catalogId, this.dataAssetKey, this.createConnectionDetails, this.opcRequestId, this.opcRetryToken);
        }

        public String toString() {
            return "CreateConnectionRequest.Builder(catalogId=" + this.catalogId + ", dataAssetKey=" + this.dataAssetKey + ", createConnectionDetails=" + this.createConnectionDetails + ", opcRequestId=" + this.opcRequestId + ", opcRetryToken=" + this.opcRetryToken + ")";
        }
    }
}

