/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.datacatalog.requests;

import com.oracle.bmc.InternalSdk;
import com.oracle.bmc.datacatalog.model.CreateTagDetails;
import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import com.oracle.bmc.util.internal.Consumer;
import java.beans.ConstructorProperties;
import javax.ws.rs.client.Invocation;

public class CreateDataAssetTagRequest
extends BmcRequest<CreateTagDetails> {
    private String catalogId;
    private String dataAssetKey;
    private CreateTagDetails createDataAssetTagDetails;
    private String opcRequestId;
    private String opcRetryToken;

    @InternalSdk
    public CreateTagDetails getBody$() {
        return this.createDataAssetTagDetails;
    }

    @ConstructorProperties(value={"catalogId", "dataAssetKey", "createDataAssetTagDetails", "opcRequestId", "opcRetryToken"})
    CreateDataAssetTagRequest(String catalogId, String dataAssetKey, CreateTagDetails createDataAssetTagDetails, String opcRequestId, String opcRetryToken) {
        this.catalogId = catalogId;
        this.dataAssetKey = dataAssetKey;
        this.createDataAssetTagDetails = createDataAssetTagDetails;
        this.opcRequestId = opcRequestId;
        this.opcRetryToken = opcRetryToken;
    }

    public static Builder builder() {
        return new Builder();
    }

    public String getCatalogId() {
        return this.catalogId;
    }

    public String getDataAssetKey() {
        return this.dataAssetKey;
    }

    public CreateTagDetails getCreateDataAssetTagDetails() {
        return this.createDataAssetTagDetails;
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    public String getOpcRetryToken() {
        return this.opcRetryToken;
    }

    public static class Builder
    implements BmcRequest.Builder<CreateDataAssetTagRequest, CreateTagDetails> {
        private String catalogId;
        private String dataAssetKey;
        private CreateTagDetails createDataAssetTagDetails;
        private String opcRequestId;
        private String opcRetryToken;
        private Consumer<Invocation.Builder> invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;

        public Builder invocationCallback(Consumer<Invocation.Builder> invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(CreateDataAssetTagRequest o) {
            this.catalogId(o.getCatalogId());
            this.dataAssetKey(o.getDataAssetKey());
            this.createDataAssetTagDetails(o.getCreateDataAssetTagDetails());
            this.opcRequestId(o.getOpcRequestId());
            this.opcRetryToken(o.getOpcRetryToken());
            this.invocationCallback((Consumer<Invocation.Builder>)o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public CreateDataAssetTagRequest build() {
            CreateDataAssetTagRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        @InternalSdk
        public Builder body$(CreateTagDetails body) {
            this.createDataAssetTagDetails(body);
            return this;
        }

        Builder() {
        }

        public Builder catalogId(String catalogId) {
            this.catalogId = catalogId;
            return this;
        }

        public Builder dataAssetKey(String dataAssetKey) {
            this.dataAssetKey = dataAssetKey;
            return this;
        }

        public Builder createDataAssetTagDetails(CreateTagDetails createDataAssetTagDetails) {
            this.createDataAssetTagDetails = createDataAssetTagDetails;
            return this;
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public Builder opcRetryToken(String opcRetryToken) {
            this.opcRetryToken = opcRetryToken;
            return this;
        }

        public CreateDataAssetTagRequest buildWithoutInvocationCallback() {
            return new CreateDataAssetTagRequest(this.catalogId, this.dataAssetKey, this.createDataAssetTagDetails, this.opcRequestId, this.opcRetryToken);
        }

        public String toString() {
            return "CreateDataAssetTagRequest.Builder(catalogId=" + this.catalogId + ", dataAssetKey=" + this.dataAssetKey + ", createDataAssetTagDetails=" + this.createDataAssetTagDetails + ", opcRequestId=" + this.opcRequestId + ", opcRetryToken=" + this.opcRetryToken + ")";
        }
    }
}

