/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.datacatalog.requests;

import com.oracle.bmc.InternalSdk;
import com.oracle.bmc.datacatalog.model.CreateTagDetails;
import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import com.oracle.bmc.util.internal.Consumer;
import java.beans.ConstructorProperties;
import javax.ws.rs.client.Invocation;

public class CreateEntityTagRequest
extends BmcRequest<CreateTagDetails> {
    private String catalogId;
    private String dataAssetKey;
    private String entityKey;
    private CreateTagDetails createEntityTagDetails;
    private String opcRequestId;
    private String opcRetryToken;

    @InternalSdk
    public CreateTagDetails getBody$() {
        return this.createEntityTagDetails;
    }

    @ConstructorProperties(value={"catalogId", "dataAssetKey", "entityKey", "createEntityTagDetails", "opcRequestId", "opcRetryToken"})
    CreateEntityTagRequest(String catalogId, String dataAssetKey, String entityKey, CreateTagDetails createEntityTagDetails, String opcRequestId, String opcRetryToken) {
        this.catalogId = catalogId;
        this.dataAssetKey = dataAssetKey;
        this.entityKey = entityKey;
        this.createEntityTagDetails = createEntityTagDetails;
        this.opcRequestId = opcRequestId;
        this.opcRetryToken = opcRetryToken;
    }

    public static Builder builder() {
        return new Builder();
    }

    public String getCatalogId() {
        return this.catalogId;
    }

    public String getDataAssetKey() {
        return this.dataAssetKey;
    }

    public String getEntityKey() {
        return this.entityKey;
    }

    public CreateTagDetails getCreateEntityTagDetails() {
        return this.createEntityTagDetails;
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    public String getOpcRetryToken() {
        return this.opcRetryToken;
    }

    public static class Builder
    implements BmcRequest.Builder<CreateEntityTagRequest, CreateTagDetails> {
        private String catalogId;
        private String dataAssetKey;
        private String entityKey;
        private CreateTagDetails createEntityTagDetails;
        private String opcRequestId;
        private String opcRetryToken;
        private Consumer<Invocation.Builder> invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;

        public Builder invocationCallback(Consumer<Invocation.Builder> invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(CreateEntityTagRequest o) {
            this.catalogId(o.getCatalogId());
            this.dataAssetKey(o.getDataAssetKey());
            this.entityKey(o.getEntityKey());
            this.createEntityTagDetails(o.getCreateEntityTagDetails());
            this.opcRequestId(o.getOpcRequestId());
            this.opcRetryToken(o.getOpcRetryToken());
            this.invocationCallback((Consumer<Invocation.Builder>)o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public CreateEntityTagRequest build() {
            CreateEntityTagRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        @InternalSdk
        public Builder body$(CreateTagDetails body) {
            this.createEntityTagDetails(body);
            return this;
        }

        Builder() {
        }

        public Builder catalogId(String catalogId) {
            this.catalogId = catalogId;
            return this;
        }

        public Builder dataAssetKey(String dataAssetKey) {
            this.dataAssetKey = dataAssetKey;
            return this;
        }

        public Builder entityKey(String entityKey) {
            this.entityKey = entityKey;
            return this;
        }

        public Builder createEntityTagDetails(CreateTagDetails createEntityTagDetails) {
            this.createEntityTagDetails = createEntityTagDetails;
            return this;
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public Builder opcRetryToken(String opcRetryToken) {
            this.opcRetryToken = opcRetryToken;
            return this;
        }

        public CreateEntityTagRequest buildWithoutInvocationCallback() {
            return new CreateEntityTagRequest(this.catalogId, this.dataAssetKey, this.entityKey, this.createEntityTagDetails, this.opcRequestId, this.opcRetryToken);
        }

        public String toString() {
            return "CreateEntityTagRequest.Builder(catalogId=" + this.catalogId + ", dataAssetKey=" + this.dataAssetKey + ", entityKey=" + this.entityKey + ", createEntityTagDetails=" + this.createEntityTagDetails + ", opcRequestId=" + this.opcRequestId + ", opcRetryToken=" + this.opcRetryToken + ")";
        }
    }
}

