/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.datacatalog.requests;

import com.oracle.bmc.InternalSdk;
import com.oracle.bmc.datacatalog.model.CreateTagDetails;
import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import com.oracle.bmc.util.internal.Consumer;
import java.beans.ConstructorProperties;
import javax.ws.rs.client.Invocation;

public class CreateFolderTagRequest
extends BmcRequest<CreateTagDetails> {
    private String catalogId;
    private String dataAssetKey;
    private String folderKey;
    private CreateTagDetails createFolderTagDetails;
    private String opcRequestId;
    private String opcRetryToken;

    @InternalSdk
    public CreateTagDetails getBody$() {
        return this.createFolderTagDetails;
    }

    @ConstructorProperties(value={"catalogId", "dataAssetKey", "folderKey", "createFolderTagDetails", "opcRequestId", "opcRetryToken"})
    CreateFolderTagRequest(String catalogId, String dataAssetKey, String folderKey, CreateTagDetails createFolderTagDetails, String opcRequestId, String opcRetryToken) {
        this.catalogId = catalogId;
        this.dataAssetKey = dataAssetKey;
        this.folderKey = folderKey;
        this.createFolderTagDetails = createFolderTagDetails;
        this.opcRequestId = opcRequestId;
        this.opcRetryToken = opcRetryToken;
    }

    public static Builder builder() {
        return new Builder();
    }

    public String getCatalogId() {
        return this.catalogId;
    }

    public String getDataAssetKey() {
        return this.dataAssetKey;
    }

    public String getFolderKey() {
        return this.folderKey;
    }

    public CreateTagDetails getCreateFolderTagDetails() {
        return this.createFolderTagDetails;
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    public String getOpcRetryToken() {
        return this.opcRetryToken;
    }

    public static class Builder
    implements BmcRequest.Builder<CreateFolderTagRequest, CreateTagDetails> {
        private String catalogId;
        private String dataAssetKey;
        private String folderKey;
        private CreateTagDetails createFolderTagDetails;
        private String opcRequestId;
        private String opcRetryToken;
        private Consumer<Invocation.Builder> invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;

        public Builder invocationCallback(Consumer<Invocation.Builder> invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(CreateFolderTagRequest o) {
            this.catalogId(o.getCatalogId());
            this.dataAssetKey(o.getDataAssetKey());
            this.folderKey(o.getFolderKey());
            this.createFolderTagDetails(o.getCreateFolderTagDetails());
            this.opcRequestId(o.getOpcRequestId());
            this.opcRetryToken(o.getOpcRetryToken());
            this.invocationCallback((Consumer<Invocation.Builder>)o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public CreateFolderTagRequest build() {
            CreateFolderTagRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        @InternalSdk
        public Builder body$(CreateTagDetails body) {
            this.createFolderTagDetails(body);
            return this;
        }

        Builder() {
        }

        public Builder catalogId(String catalogId) {
            this.catalogId = catalogId;
            return this;
        }

        public Builder dataAssetKey(String dataAssetKey) {
            this.dataAssetKey = dataAssetKey;
            return this;
        }

        public Builder folderKey(String folderKey) {
            this.folderKey = folderKey;
            return this;
        }

        public Builder createFolderTagDetails(CreateTagDetails createFolderTagDetails) {
            this.createFolderTagDetails = createFolderTagDetails;
            return this;
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public Builder opcRetryToken(String opcRetryToken) {
            this.opcRetryToken = opcRetryToken;
            return this;
        }

        public CreateFolderTagRequest buildWithoutInvocationCallback() {
            return new CreateFolderTagRequest(this.catalogId, this.dataAssetKey, this.folderKey, this.createFolderTagDetails, this.opcRequestId, this.opcRetryToken);
        }

        public String toString() {
            return "CreateFolderTagRequest.Builder(catalogId=" + this.catalogId + ", dataAssetKey=" + this.dataAssetKey + ", folderKey=" + this.folderKey + ", createFolderTagDetails=" + this.createFolderTagDetails + ", opcRequestId=" + this.opcRequestId + ", opcRetryToken=" + this.opcRetryToken + ")";
        }
    }
}

