/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.datacatalog.requests;

import com.oracle.bmc.InternalSdk;
import com.oracle.bmc.datacatalog.model.CreateJobDefinitionDetails;
import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import com.oracle.bmc.util.internal.Consumer;
import java.beans.ConstructorProperties;
import javax.ws.rs.client.Invocation;

public class CreateJobDefinitionRequest
extends BmcRequest<CreateJobDefinitionDetails> {
    private String catalogId;
    private CreateJobDefinitionDetails createJobDefinitionDetails;
    private String opcRequestId;
    private String opcRetryToken;

    @InternalSdk
    public CreateJobDefinitionDetails getBody$() {
        return this.createJobDefinitionDetails;
    }

    @ConstructorProperties(value={"catalogId", "createJobDefinitionDetails", "opcRequestId", "opcRetryToken"})
    CreateJobDefinitionRequest(String catalogId, CreateJobDefinitionDetails createJobDefinitionDetails, String opcRequestId, String opcRetryToken) {
        this.catalogId = catalogId;
        this.createJobDefinitionDetails = createJobDefinitionDetails;
        this.opcRequestId = opcRequestId;
        this.opcRetryToken = opcRetryToken;
    }

    public static Builder builder() {
        return new Builder();
    }

    public String getCatalogId() {
        return this.catalogId;
    }

    public CreateJobDefinitionDetails getCreateJobDefinitionDetails() {
        return this.createJobDefinitionDetails;
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    public String getOpcRetryToken() {
        return this.opcRetryToken;
    }

    public static class Builder
    implements BmcRequest.Builder<CreateJobDefinitionRequest, CreateJobDefinitionDetails> {
        private String catalogId;
        private CreateJobDefinitionDetails createJobDefinitionDetails;
        private String opcRequestId;
        private String opcRetryToken;
        private Consumer<Invocation.Builder> invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;

        public Builder invocationCallback(Consumer<Invocation.Builder> invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(CreateJobDefinitionRequest o) {
            this.catalogId(o.getCatalogId());
            this.createJobDefinitionDetails(o.getCreateJobDefinitionDetails());
            this.opcRequestId(o.getOpcRequestId());
            this.opcRetryToken(o.getOpcRetryToken());
            this.invocationCallback((Consumer<Invocation.Builder>)o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public CreateJobDefinitionRequest build() {
            CreateJobDefinitionRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        @InternalSdk
        public Builder body$(CreateJobDefinitionDetails body) {
            this.createJobDefinitionDetails(body);
            return this;
        }

        Builder() {
        }

        public Builder catalogId(String catalogId) {
            this.catalogId = catalogId;
            return this;
        }

        public Builder createJobDefinitionDetails(CreateJobDefinitionDetails createJobDefinitionDetails) {
            this.createJobDefinitionDetails = createJobDefinitionDetails;
            return this;
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public Builder opcRetryToken(String opcRetryToken) {
            this.opcRetryToken = opcRetryToken;
            return this;
        }

        public CreateJobDefinitionRequest buildWithoutInvocationCallback() {
            return new CreateJobDefinitionRequest(this.catalogId, this.createJobDefinitionDetails, this.opcRequestId, this.opcRetryToken);
        }

        public String toString() {
            return "CreateJobDefinitionRequest.Builder(catalogId=" + this.catalogId + ", createJobDefinitionDetails=" + this.createJobDefinitionDetails + ", opcRequestId=" + this.opcRequestId + ", opcRetryToken=" + this.opcRetryToken + ")";
        }
    }
}

