/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.datacatalog.requests;

import com.oracle.bmc.InternalSdk;
import com.oracle.bmc.datacatalog.model.CreateJobExecutionDetails;
import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import com.oracle.bmc.util.internal.Consumer;
import java.beans.ConstructorProperties;
import javax.ws.rs.client.Invocation;

public class CreateJobExecutionRequest
extends BmcRequest<CreateJobExecutionDetails> {
    private String catalogId;
    private String jobKey;
    private CreateJobExecutionDetails createJobExecutionDetails;
    private String opcRequestId;
    private String opcRetryToken;

    @InternalSdk
    public CreateJobExecutionDetails getBody$() {
        return this.createJobExecutionDetails;
    }

    @ConstructorProperties(value={"catalogId", "jobKey", "createJobExecutionDetails", "opcRequestId", "opcRetryToken"})
    CreateJobExecutionRequest(String catalogId, String jobKey, CreateJobExecutionDetails createJobExecutionDetails, String opcRequestId, String opcRetryToken) {
        this.catalogId = catalogId;
        this.jobKey = jobKey;
        this.createJobExecutionDetails = createJobExecutionDetails;
        this.opcRequestId = opcRequestId;
        this.opcRetryToken = opcRetryToken;
    }

    public static Builder builder() {
        return new Builder();
    }

    public String getCatalogId() {
        return this.catalogId;
    }

    public String getJobKey() {
        return this.jobKey;
    }

    public CreateJobExecutionDetails getCreateJobExecutionDetails() {
        return this.createJobExecutionDetails;
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    public String getOpcRetryToken() {
        return this.opcRetryToken;
    }

    public static class Builder
    implements BmcRequest.Builder<CreateJobExecutionRequest, CreateJobExecutionDetails> {
        private String catalogId;
        private String jobKey;
        private CreateJobExecutionDetails createJobExecutionDetails;
        private String opcRequestId;
        private String opcRetryToken;
        private Consumer<Invocation.Builder> invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;

        public Builder invocationCallback(Consumer<Invocation.Builder> invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(CreateJobExecutionRequest o) {
            this.catalogId(o.getCatalogId());
            this.jobKey(o.getJobKey());
            this.createJobExecutionDetails(o.getCreateJobExecutionDetails());
            this.opcRequestId(o.getOpcRequestId());
            this.opcRetryToken(o.getOpcRetryToken());
            this.invocationCallback((Consumer<Invocation.Builder>)o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public CreateJobExecutionRequest build() {
            CreateJobExecutionRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        @InternalSdk
        public Builder body$(CreateJobExecutionDetails body) {
            this.createJobExecutionDetails(body);
            return this;
        }

        Builder() {
        }

        public Builder catalogId(String catalogId) {
            this.catalogId = catalogId;
            return this;
        }

        public Builder jobKey(String jobKey) {
            this.jobKey = jobKey;
            return this;
        }

        public Builder createJobExecutionDetails(CreateJobExecutionDetails createJobExecutionDetails) {
            this.createJobExecutionDetails = createJobExecutionDetails;
            return this;
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public Builder opcRetryToken(String opcRetryToken) {
            this.opcRetryToken = opcRetryToken;
            return this;
        }

        public CreateJobExecutionRequest buildWithoutInvocationCallback() {
            return new CreateJobExecutionRequest(this.catalogId, this.jobKey, this.createJobExecutionDetails, this.opcRequestId, this.opcRetryToken);
        }

        public String toString() {
            return "CreateJobExecutionRequest.Builder(catalogId=" + this.catalogId + ", jobKey=" + this.jobKey + ", createJobExecutionDetails=" + this.createJobExecutionDetails + ", opcRequestId=" + this.opcRequestId + ", opcRetryToken=" + this.opcRetryToken + ")";
        }
    }
}

