/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.datacatalog.requests;

import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import com.oracle.bmc.util.internal.Consumer;
import java.beans.ConstructorProperties;
import javax.ws.rs.client.Invocation;

public class DeleteAttributeTagRequest
extends BmcRequest<Void> {
    private String catalogId;
    private String dataAssetKey;
    private String entityKey;
    private String attributeKey;
    private String tagKey;
    private String ifMatch;
    private String opcRequestId;

    @ConstructorProperties(value={"catalogId", "dataAssetKey", "entityKey", "attributeKey", "tagKey", "ifMatch", "opcRequestId"})
    DeleteAttributeTagRequest(String catalogId, String dataAssetKey, String entityKey, String attributeKey, String tagKey, String ifMatch, String opcRequestId) {
        this.catalogId = catalogId;
        this.dataAssetKey = dataAssetKey;
        this.entityKey = entityKey;
        this.attributeKey = attributeKey;
        this.tagKey = tagKey;
        this.ifMatch = ifMatch;
        this.opcRequestId = opcRequestId;
    }

    public static Builder builder() {
        return new Builder();
    }

    public String getCatalogId() {
        return this.catalogId;
    }

    public String getDataAssetKey() {
        return this.dataAssetKey;
    }

    public String getEntityKey() {
        return this.entityKey;
    }

    public String getAttributeKey() {
        return this.attributeKey;
    }

    public String getTagKey() {
        return this.tagKey;
    }

    public String getIfMatch() {
        return this.ifMatch;
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    public static class Builder
    implements BmcRequest.Builder<DeleteAttributeTagRequest, Void> {
        private String catalogId;
        private String dataAssetKey;
        private String entityKey;
        private String attributeKey;
        private String tagKey;
        private String ifMatch;
        private String opcRequestId;
        private Consumer<Invocation.Builder> invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;

        public Builder invocationCallback(Consumer<Invocation.Builder> invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(DeleteAttributeTagRequest o) {
            this.catalogId(o.getCatalogId());
            this.dataAssetKey(o.getDataAssetKey());
            this.entityKey(o.getEntityKey());
            this.attributeKey(o.getAttributeKey());
            this.tagKey(o.getTagKey());
            this.ifMatch(o.getIfMatch());
            this.opcRequestId(o.getOpcRequestId());
            this.invocationCallback((Consumer<Invocation.Builder>)o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public DeleteAttributeTagRequest build() {
            DeleteAttributeTagRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        Builder() {
        }

        public Builder catalogId(String catalogId) {
            this.catalogId = catalogId;
            return this;
        }

        public Builder dataAssetKey(String dataAssetKey) {
            this.dataAssetKey = dataAssetKey;
            return this;
        }

        public Builder entityKey(String entityKey) {
            this.entityKey = entityKey;
            return this;
        }

        public Builder attributeKey(String attributeKey) {
            this.attributeKey = attributeKey;
            return this;
        }

        public Builder tagKey(String tagKey) {
            this.tagKey = tagKey;
            return this;
        }

        public Builder ifMatch(String ifMatch) {
            this.ifMatch = ifMatch;
            return this;
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public DeleteAttributeTagRequest buildWithoutInvocationCallback() {
            return new DeleteAttributeTagRequest(this.catalogId, this.dataAssetKey, this.entityKey, this.attributeKey, this.tagKey, this.ifMatch, this.opcRequestId);
        }

        public String toString() {
            return "DeleteAttributeTagRequest.Builder(catalogId=" + this.catalogId + ", dataAssetKey=" + this.dataAssetKey + ", entityKey=" + this.entityKey + ", attributeKey=" + this.attributeKey + ", tagKey=" + this.tagKey + ", ifMatch=" + this.ifMatch + ", opcRequestId=" + this.opcRequestId + ")";
        }
    }
}

