/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.datacatalog.requests;

import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import com.oracle.bmc.util.internal.Consumer;
import java.beans.ConstructorProperties;
import javax.ws.rs.client.Invocation;

public class DeleteJobDefinitionRequest
extends BmcRequest<Void> {
    private String catalogId;
    private String jobDefinitionKey;
    private String ifMatch;
    private String opcRequestId;

    @ConstructorProperties(value={"catalogId", "jobDefinitionKey", "ifMatch", "opcRequestId"})
    DeleteJobDefinitionRequest(String catalogId, String jobDefinitionKey, String ifMatch, String opcRequestId) {
        this.catalogId = catalogId;
        this.jobDefinitionKey = jobDefinitionKey;
        this.ifMatch = ifMatch;
        this.opcRequestId = opcRequestId;
    }

    public static Builder builder() {
        return new Builder();
    }

    public String getCatalogId() {
        return this.catalogId;
    }

    public String getJobDefinitionKey() {
        return this.jobDefinitionKey;
    }

    public String getIfMatch() {
        return this.ifMatch;
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    public static class Builder
    implements BmcRequest.Builder<DeleteJobDefinitionRequest, Void> {
        private String catalogId;
        private String jobDefinitionKey;
        private String ifMatch;
        private String opcRequestId;
        private Consumer<Invocation.Builder> invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;

        public Builder invocationCallback(Consumer<Invocation.Builder> invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(DeleteJobDefinitionRequest o) {
            this.catalogId(o.getCatalogId());
            this.jobDefinitionKey(o.getJobDefinitionKey());
            this.ifMatch(o.getIfMatch());
            this.opcRequestId(o.getOpcRequestId());
            this.invocationCallback((Consumer<Invocation.Builder>)o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public DeleteJobDefinitionRequest build() {
            DeleteJobDefinitionRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        Builder() {
        }

        public Builder catalogId(String catalogId) {
            this.catalogId = catalogId;
            return this;
        }

        public Builder jobDefinitionKey(String jobDefinitionKey) {
            this.jobDefinitionKey = jobDefinitionKey;
            return this;
        }

        public Builder ifMatch(String ifMatch) {
            this.ifMatch = ifMatch;
            return this;
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public DeleteJobDefinitionRequest buildWithoutInvocationCallback() {
            return new DeleteJobDefinitionRequest(this.catalogId, this.jobDefinitionKey, this.ifMatch, this.opcRequestId);
        }

        public String toString() {
            return "DeleteJobDefinitionRequest.Builder(catalogId=" + this.catalogId + ", jobDefinitionKey=" + this.jobDefinitionKey + ", ifMatch=" + this.ifMatch + ", opcRequestId=" + this.opcRequestId + ")";
        }
    }
}

