/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.datacatalog.requests;

import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import com.oracle.bmc.util.internal.Consumer;
import java.beans.ConstructorProperties;
import javax.ws.rs.client.Invocation;

public class ExpandTreeForGlossaryRequest
extends BmcRequest<Void> {
    private String catalogId;
    private String glossaryKey;
    private String opcRequestId;
    private String opcRetryToken;

    @ConstructorProperties(value={"catalogId", "glossaryKey", "opcRequestId", "opcRetryToken"})
    ExpandTreeForGlossaryRequest(String catalogId, String glossaryKey, String opcRequestId, String opcRetryToken) {
        this.catalogId = catalogId;
        this.glossaryKey = glossaryKey;
        this.opcRequestId = opcRequestId;
        this.opcRetryToken = opcRetryToken;
    }

    public static Builder builder() {
        return new Builder();
    }

    public String getCatalogId() {
        return this.catalogId;
    }

    public String getGlossaryKey() {
        return this.glossaryKey;
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    public String getOpcRetryToken() {
        return this.opcRetryToken;
    }

    public static class Builder
    implements BmcRequest.Builder<ExpandTreeForGlossaryRequest, Void> {
        private String catalogId;
        private String glossaryKey;
        private String opcRequestId;
        private String opcRetryToken;
        private Consumer<Invocation.Builder> invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;

        public Builder invocationCallback(Consumer<Invocation.Builder> invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(ExpandTreeForGlossaryRequest o) {
            this.catalogId(o.getCatalogId());
            this.glossaryKey(o.getGlossaryKey());
            this.opcRequestId(o.getOpcRequestId());
            this.opcRetryToken(o.getOpcRetryToken());
            this.invocationCallback((Consumer<Invocation.Builder>)o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public ExpandTreeForGlossaryRequest build() {
            ExpandTreeForGlossaryRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        Builder() {
        }

        public Builder catalogId(String catalogId) {
            this.catalogId = catalogId;
            return this;
        }

        public Builder glossaryKey(String glossaryKey) {
            this.glossaryKey = glossaryKey;
            return this;
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public Builder opcRetryToken(String opcRetryToken) {
            this.opcRetryToken = opcRetryToken;
            return this;
        }

        public ExpandTreeForGlossaryRequest buildWithoutInvocationCallback() {
            return new ExpandTreeForGlossaryRequest(this.catalogId, this.glossaryKey, this.opcRequestId, this.opcRetryToken);
        }

        public String toString() {
            return "ExpandTreeForGlossaryRequest.Builder(catalogId=" + this.catalogId + ", glossaryKey=" + this.glossaryKey + ", opcRequestId=" + this.opcRequestId + ", opcRetryToken=" + this.opcRetryToken + ")";
        }
    }
}

