/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.datacatalog.requests;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import com.oracle.bmc.util.internal.Consumer;
import java.beans.ConstructorProperties;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.ws.rs.client.Invocation;

public class GetTypeRequest
extends BmcRequest<Void> {
    private String catalogId;
    private String typeKey;
    private List<Fields> fields;
    private String opcRequestId;

    @ConstructorProperties(value={"catalogId", "typeKey", "fields", "opcRequestId"})
    GetTypeRequest(String catalogId, String typeKey, List<Fields> fields, String opcRequestId) {
        this.catalogId = catalogId;
        this.typeKey = typeKey;
        this.fields = fields;
        this.opcRequestId = opcRequestId;
    }

    public static Builder builder() {
        return new Builder();
    }

    public String getCatalogId() {
        return this.catalogId;
    }

    public String getTypeKey() {
        return this.typeKey;
    }

    public List<Fields> getFields() {
        return this.fields;
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    public static class Builder
    implements BmcRequest.Builder<GetTypeRequest, Void> {
        private String catalogId;
        private String typeKey;
        private List<Fields> fields;
        private String opcRequestId;
        private Consumer<Invocation.Builder> invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;

        public Builder invocationCallback(Consumer<Invocation.Builder> invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(GetTypeRequest o) {
            this.catalogId(o.getCatalogId());
            this.typeKey(o.getTypeKey());
            this.fields(o.getFields());
            this.opcRequestId(o.getOpcRequestId());
            this.invocationCallback((Consumer<Invocation.Builder>)o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public GetTypeRequest build() {
            GetTypeRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        Builder() {
        }

        public Builder catalogId(String catalogId) {
            this.catalogId = catalogId;
            return this;
        }

        public Builder typeKey(String typeKey) {
            this.typeKey = typeKey;
            return this;
        }

        public Builder fields(List<Fields> fields) {
            this.fields = fields;
            return this;
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public GetTypeRequest buildWithoutInvocationCallback() {
            return new GetTypeRequest(this.catalogId, this.typeKey, this.fields, this.opcRequestId);
        }

        public String toString() {
            return "GetTypeRequest.Builder(catalogId=" + this.catalogId + ", typeKey=" + this.typeKey + ", fields=" + this.fields + ", opcRequestId=" + this.opcRequestId + ")";
        }
    }

    public static enum Fields {
        Key("key"),
        Description("description"),
        Name("name"),
        CatalogId("catalogId"),
        Properties("properties"),
        IsInternal("isInternal"),
        IsTag("isTag"),
        IsApproved("isApproved"),
        TypeCategory("typeCategory"),
        ExternalTypeName("externalTypeName"),
        LifecycleState("lifecycleState"),
        Uri("uri");

        private final String value;
        private static Map<String, Fields> map;

        private Fields(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static Fields create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            throw new IllegalArgumentException("Invalid Fields: " + key);
        }

        static {
            map = new HashMap<String, Fields>();
            for (Fields v : Fields.values()) {
                map.put(v.getValue(), v);
            }
        }
    }
}

