/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.datacatalog.requests;

import com.oracle.bmc.InternalSdk;
import com.oracle.bmc.datacatalog.model.ImportGlossaryDetails;
import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import com.oracle.bmc.util.internal.Consumer;
import java.beans.ConstructorProperties;
import javax.ws.rs.client.Invocation;

public class ImportGlossaryRequest
extends BmcRequest<ImportGlossaryDetails> {
    private String catalogId;
    private String glossaryKey;
    private ImportGlossaryDetails importGlossaryDetails;
    private Boolean isRelationshipImported;
    private String opcRequestId;
    private String opcRetryToken;

    @InternalSdk
    public ImportGlossaryDetails getBody$() {
        return this.importGlossaryDetails;
    }

    @ConstructorProperties(value={"catalogId", "glossaryKey", "importGlossaryDetails", "isRelationshipImported", "opcRequestId", "opcRetryToken"})
    ImportGlossaryRequest(String catalogId, String glossaryKey, ImportGlossaryDetails importGlossaryDetails, Boolean isRelationshipImported, String opcRequestId, String opcRetryToken) {
        this.catalogId = catalogId;
        this.glossaryKey = glossaryKey;
        this.importGlossaryDetails = importGlossaryDetails;
        this.isRelationshipImported = isRelationshipImported;
        this.opcRequestId = opcRequestId;
        this.opcRetryToken = opcRetryToken;
    }

    public static Builder builder() {
        return new Builder();
    }

    public String getCatalogId() {
        return this.catalogId;
    }

    public String getGlossaryKey() {
        return this.glossaryKey;
    }

    public ImportGlossaryDetails getImportGlossaryDetails() {
        return this.importGlossaryDetails;
    }

    public Boolean getIsRelationshipImported() {
        return this.isRelationshipImported;
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    public String getOpcRetryToken() {
        return this.opcRetryToken;
    }

    public static class Builder
    implements BmcRequest.Builder<ImportGlossaryRequest, ImportGlossaryDetails> {
        private String catalogId;
        private String glossaryKey;
        private ImportGlossaryDetails importGlossaryDetails;
        private Boolean isRelationshipImported;
        private String opcRequestId;
        private String opcRetryToken;
        private Consumer<Invocation.Builder> invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;

        public Builder invocationCallback(Consumer<Invocation.Builder> invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(ImportGlossaryRequest o) {
            this.catalogId(o.getCatalogId());
            this.glossaryKey(o.getGlossaryKey());
            this.importGlossaryDetails(o.getImportGlossaryDetails());
            this.isRelationshipImported(o.getIsRelationshipImported());
            this.opcRequestId(o.getOpcRequestId());
            this.opcRetryToken(o.getOpcRetryToken());
            this.invocationCallback((Consumer<Invocation.Builder>)o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public ImportGlossaryRequest build() {
            ImportGlossaryRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        @InternalSdk
        public Builder body$(ImportGlossaryDetails body) {
            this.importGlossaryDetails(body);
            return this;
        }

        Builder() {
        }

        public Builder catalogId(String catalogId) {
            this.catalogId = catalogId;
            return this;
        }

        public Builder glossaryKey(String glossaryKey) {
            this.glossaryKey = glossaryKey;
            return this;
        }

        public Builder importGlossaryDetails(ImportGlossaryDetails importGlossaryDetails) {
            this.importGlossaryDetails = importGlossaryDetails;
            return this;
        }

        public Builder isRelationshipImported(Boolean isRelationshipImported) {
            this.isRelationshipImported = isRelationshipImported;
            return this;
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public Builder opcRetryToken(String opcRetryToken) {
            this.opcRetryToken = opcRetryToken;
            return this;
        }

        public ImportGlossaryRequest buildWithoutInvocationCallback() {
            return new ImportGlossaryRequest(this.catalogId, this.glossaryKey, this.importGlossaryDetails, this.isRelationshipImported, this.opcRequestId, this.opcRetryToken);
        }

        public String toString() {
            return "ImportGlossaryRequest.Builder(catalogId=" + this.catalogId + ", glossaryKey=" + this.glossaryKey + ", importGlossaryDetails=" + this.importGlossaryDetails + ", isRelationshipImported=" + this.isRelationshipImported + ", opcRequestId=" + this.opcRequestId + ", opcRetryToken=" + this.opcRetryToken + ")";
        }
    }
}

