/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.datacatalog.requests;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import com.oracle.bmc.datacatalog.model.JobExecutionState;
import com.oracle.bmc.datacatalog.model.JobType;
import com.oracle.bmc.datacatalog.model.LifecycleState;
import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import com.oracle.bmc.util.internal.Consumer;
import java.beans.ConstructorProperties;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.ws.rs.client.Invocation;

public class ListJobDefinitionsRequest
extends BmcRequest<Void> {
    private String catalogId;
    private String displayName;
    private String displayNameContains;
    private JobExecutionState jobExecutionState;
    private LifecycleState lifecycleState;
    private JobType jobType;
    private Boolean isIncremental;
    private String dataAssetKey;
    private String connectionKey;
    private Date timeCreated;
    private Date timeUpdated;
    private String createdById;
    private String updatedById;
    private String sampleDataSizeInMBs;
    private List<Fields> fields;
    private SortBy sortBy;
    private SortOrder sortOrder;
    private Integer limit;
    private String page;
    private String opcRequestId;

    @ConstructorProperties(value={"catalogId", "displayName", "displayNameContains", "jobExecutionState", "lifecycleState", "jobType", "isIncremental", "dataAssetKey", "connectionKey", "timeCreated", "timeUpdated", "createdById", "updatedById", "sampleDataSizeInMBs", "fields", "sortBy", "sortOrder", "limit", "page", "opcRequestId"})
    ListJobDefinitionsRequest(String catalogId, String displayName, String displayNameContains, JobExecutionState jobExecutionState, LifecycleState lifecycleState, JobType jobType, Boolean isIncremental, String dataAssetKey, String connectionKey, Date timeCreated, Date timeUpdated, String createdById, String updatedById, String sampleDataSizeInMBs, List<Fields> fields, SortBy sortBy, SortOrder sortOrder, Integer limit, String page, String opcRequestId) {
        this.catalogId = catalogId;
        this.displayName = displayName;
        this.displayNameContains = displayNameContains;
        this.jobExecutionState = jobExecutionState;
        this.lifecycleState = lifecycleState;
        this.jobType = jobType;
        this.isIncremental = isIncremental;
        this.dataAssetKey = dataAssetKey;
        this.connectionKey = connectionKey;
        this.timeCreated = timeCreated;
        this.timeUpdated = timeUpdated;
        this.createdById = createdById;
        this.updatedById = updatedById;
        this.sampleDataSizeInMBs = sampleDataSizeInMBs;
        this.fields = fields;
        this.sortBy = sortBy;
        this.sortOrder = sortOrder;
        this.limit = limit;
        this.page = page;
        this.opcRequestId = opcRequestId;
    }

    public static Builder builder() {
        return new Builder();
    }

    public String getCatalogId() {
        return this.catalogId;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public String getDisplayNameContains() {
        return this.displayNameContains;
    }

    public JobExecutionState getJobExecutionState() {
        return this.jobExecutionState;
    }

    public LifecycleState getLifecycleState() {
        return this.lifecycleState;
    }

    public JobType getJobType() {
        return this.jobType;
    }

    public Boolean getIsIncremental() {
        return this.isIncremental;
    }

    public String getDataAssetKey() {
        return this.dataAssetKey;
    }

    public String getConnectionKey() {
        return this.connectionKey;
    }

    public Date getTimeCreated() {
        return this.timeCreated;
    }

    public Date getTimeUpdated() {
        return this.timeUpdated;
    }

    public String getCreatedById() {
        return this.createdById;
    }

    public String getUpdatedById() {
        return this.updatedById;
    }

    public String getSampleDataSizeInMBs() {
        return this.sampleDataSizeInMBs;
    }

    public List<Fields> getFields() {
        return this.fields;
    }

    public SortBy getSortBy() {
        return this.sortBy;
    }

    public SortOrder getSortOrder() {
        return this.sortOrder;
    }

    public Integer getLimit() {
        return this.limit;
    }

    public String getPage() {
        return this.page;
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    public static class Builder
    implements BmcRequest.Builder<ListJobDefinitionsRequest, Void> {
        private String catalogId;
        private String displayName;
        private String displayNameContains;
        private JobExecutionState jobExecutionState;
        private LifecycleState lifecycleState;
        private JobType jobType;
        private Boolean isIncremental;
        private String dataAssetKey;
        private String connectionKey;
        private Date timeCreated;
        private Date timeUpdated;
        private String createdById;
        private String updatedById;
        private String sampleDataSizeInMBs;
        private List<Fields> fields;
        private SortBy sortBy;
        private SortOrder sortOrder;
        private Integer limit;
        private String page;
        private String opcRequestId;
        private Consumer<Invocation.Builder> invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;

        public Builder invocationCallback(Consumer<Invocation.Builder> invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(ListJobDefinitionsRequest o) {
            this.catalogId(o.getCatalogId());
            this.displayName(o.getDisplayName());
            this.displayNameContains(o.getDisplayNameContains());
            this.jobExecutionState(o.getJobExecutionState());
            this.lifecycleState(o.getLifecycleState());
            this.jobType(o.getJobType());
            this.isIncremental(o.getIsIncremental());
            this.dataAssetKey(o.getDataAssetKey());
            this.connectionKey(o.getConnectionKey());
            this.timeCreated(o.getTimeCreated());
            this.timeUpdated(o.getTimeUpdated());
            this.createdById(o.getCreatedById());
            this.updatedById(o.getUpdatedById());
            this.sampleDataSizeInMBs(o.getSampleDataSizeInMBs());
            this.fields(o.getFields());
            this.sortBy(o.getSortBy());
            this.sortOrder(o.getSortOrder());
            this.limit(o.getLimit());
            this.page(o.getPage());
            this.opcRequestId(o.getOpcRequestId());
            this.invocationCallback((Consumer<Invocation.Builder>)o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public ListJobDefinitionsRequest build() {
            ListJobDefinitionsRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        Builder() {
        }

        public Builder catalogId(String catalogId) {
            this.catalogId = catalogId;
            return this;
        }

        public Builder displayName(String displayName) {
            this.displayName = displayName;
            return this;
        }

        public Builder displayNameContains(String displayNameContains) {
            this.displayNameContains = displayNameContains;
            return this;
        }

        public Builder jobExecutionState(JobExecutionState jobExecutionState) {
            this.jobExecutionState = jobExecutionState;
            return this;
        }

        public Builder lifecycleState(LifecycleState lifecycleState) {
            this.lifecycleState = lifecycleState;
            return this;
        }

        public Builder jobType(JobType jobType) {
            this.jobType = jobType;
            return this;
        }

        public Builder isIncremental(Boolean isIncremental) {
            this.isIncremental = isIncremental;
            return this;
        }

        public Builder dataAssetKey(String dataAssetKey) {
            this.dataAssetKey = dataAssetKey;
            return this;
        }

        public Builder connectionKey(String connectionKey) {
            this.connectionKey = connectionKey;
            return this;
        }

        public Builder timeCreated(Date timeCreated) {
            this.timeCreated = timeCreated;
            return this;
        }

        public Builder timeUpdated(Date timeUpdated) {
            this.timeUpdated = timeUpdated;
            return this;
        }

        public Builder createdById(String createdById) {
            this.createdById = createdById;
            return this;
        }

        public Builder updatedById(String updatedById) {
            this.updatedById = updatedById;
            return this;
        }

        public Builder sampleDataSizeInMBs(String sampleDataSizeInMBs) {
            this.sampleDataSizeInMBs = sampleDataSizeInMBs;
            return this;
        }

        public Builder fields(List<Fields> fields) {
            this.fields = fields;
            return this;
        }

        public Builder sortBy(SortBy sortBy) {
            this.sortBy = sortBy;
            return this;
        }

        public Builder sortOrder(SortOrder sortOrder) {
            this.sortOrder = sortOrder;
            return this;
        }

        public Builder limit(Integer limit) {
            this.limit = limit;
            return this;
        }

        public Builder page(String page) {
            this.page = page;
            return this;
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public ListJobDefinitionsRequest buildWithoutInvocationCallback() {
            return new ListJobDefinitionsRequest(this.catalogId, this.displayName, this.displayNameContains, this.jobExecutionState, this.lifecycleState, this.jobType, this.isIncremental, this.dataAssetKey, this.connectionKey, this.timeCreated, this.timeUpdated, this.createdById, this.updatedById, this.sampleDataSizeInMBs, this.fields, this.sortBy, this.sortOrder, this.limit, this.page, this.opcRequestId);
        }

        public String toString() {
            return "ListJobDefinitionsRequest.Builder(catalogId=" + this.catalogId + ", displayName=" + this.displayName + ", displayNameContains=" + this.displayNameContains + ", jobExecutionState=" + (Object)((Object)this.jobExecutionState) + ", lifecycleState=" + (Object)((Object)this.lifecycleState) + ", jobType=" + (Object)((Object)this.jobType) + ", isIncremental=" + this.isIncremental + ", dataAssetKey=" + this.dataAssetKey + ", connectionKey=" + this.connectionKey + ", timeCreated=" + this.timeCreated + ", timeUpdated=" + this.timeUpdated + ", createdById=" + this.createdById + ", updatedById=" + this.updatedById + ", sampleDataSizeInMBs=" + this.sampleDataSizeInMBs + ", fields=" + this.fields + ", sortBy=" + (Object)((Object)this.sortBy) + ", sortOrder=" + (Object)((Object)this.sortOrder) + ", limit=" + this.limit + ", page=" + this.page + ", opcRequestId=" + this.opcRequestId + ")";
        }
    }

    public static enum SortOrder {
        Asc("ASC"),
        Desc("DESC");

        private final String value;
        private static Map<String, SortOrder> map;

        private SortOrder(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static SortOrder create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            throw new IllegalArgumentException("Invalid SortOrder: " + key);
        }

        static {
            map = new HashMap<String, SortOrder>();
            for (SortOrder v : SortOrder.values()) {
                map.put(v.getValue(), v);
            }
        }
    }

    public static enum SortBy {
        Timecreated("TIMECREATED"),
        Displayname("DISPLAYNAME"),
        Timelatestexecutionstarted("TIMELATESTEXECUTIONSTARTED");

        private final String value;
        private static Map<String, SortBy> map;

        private SortBy(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static SortBy create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            throw new IllegalArgumentException("Invalid SortBy: " + key);
        }

        static {
            map = new HashMap<String, SortBy>();
            for (SortBy v : SortBy.values()) {
                map.put(v.getValue(), v);
            }
        }
    }

    public static enum Fields {
        Key("key"),
        DisplayName("displayName"),
        Description("description"),
        CatalogId("catalogId"),
        JobType("jobType"),
        ConnectionKey("connectionKey"),
        LifecycleState("lifecycleState"),
        TimeCreated("timeCreated"),
        IsSampleDataExtracted("isSampleDataExtracted"),
        Uri("uri"),
        TimeLatestExecutionStarted("timeLatestExecutionStarted"),
        TimeLatestExecutionEnded("timeLatestExecutionEnded"),
        JobExecutionState("jobExecutionState"),
        ScheduleType("scheduleType");

        private final String value;
        private static Map<String, Fields> map;

        private Fields(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static Fields create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            throw new IllegalArgumentException("Invalid Fields: " + key);
        }

        static {
            map = new HashMap<String, Fields>();
            for (Fields v : Fields.values()) {
                map.put(v.getValue(), v);
            }
        }
    }
}

