/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.datacatalog.requests;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import com.oracle.bmc.datacatalog.model.JobExecutionState;
import com.oracle.bmc.datacatalog.model.JobType;
import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import com.oracle.bmc.util.internal.Consumer;
import java.beans.ConstructorProperties;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.ws.rs.client.Invocation;

public class ListJobExecutionsRequest
extends BmcRequest<Void> {
    private String catalogId;
    private String jobKey;
    private JobExecutionState lifecycleState;
    private Date timeCreated;
    private Date timeUpdated;
    private String createdById;
    private String updatedById;
    private JobType jobType;
    private String subType;
    private String parentKey;
    private Date timeStart;
    private Date timeEnd;
    private String errorCode;
    private String errorMessage;
    private String processKey;
    private String externalUrl;
    private String eventKey;
    private String dataEntityKey;
    private List<Fields> fields;
    private SortBy sortBy;
    private SortOrder sortOrder;
    private Integer limit;
    private String page;
    private String opcRequestId;

    @ConstructorProperties(value={"catalogId", "jobKey", "lifecycleState", "timeCreated", "timeUpdated", "createdById", "updatedById", "jobType", "subType", "parentKey", "timeStart", "timeEnd", "errorCode", "errorMessage", "processKey", "externalUrl", "eventKey", "dataEntityKey", "fields", "sortBy", "sortOrder", "limit", "page", "opcRequestId"})
    ListJobExecutionsRequest(String catalogId, String jobKey, JobExecutionState lifecycleState, Date timeCreated, Date timeUpdated, String createdById, String updatedById, JobType jobType, String subType, String parentKey, Date timeStart, Date timeEnd, String errorCode, String errorMessage, String processKey, String externalUrl, String eventKey, String dataEntityKey, List<Fields> fields, SortBy sortBy, SortOrder sortOrder, Integer limit, String page, String opcRequestId) {
        this.catalogId = catalogId;
        this.jobKey = jobKey;
        this.lifecycleState = lifecycleState;
        this.timeCreated = timeCreated;
        this.timeUpdated = timeUpdated;
        this.createdById = createdById;
        this.updatedById = updatedById;
        this.jobType = jobType;
        this.subType = subType;
        this.parentKey = parentKey;
        this.timeStart = timeStart;
        this.timeEnd = timeEnd;
        this.errorCode = errorCode;
        this.errorMessage = errorMessage;
        this.processKey = processKey;
        this.externalUrl = externalUrl;
        this.eventKey = eventKey;
        this.dataEntityKey = dataEntityKey;
        this.fields = fields;
        this.sortBy = sortBy;
        this.sortOrder = sortOrder;
        this.limit = limit;
        this.page = page;
        this.opcRequestId = opcRequestId;
    }

    public static Builder builder() {
        return new Builder();
    }

    public String getCatalogId() {
        return this.catalogId;
    }

    public String getJobKey() {
        return this.jobKey;
    }

    public JobExecutionState getLifecycleState() {
        return this.lifecycleState;
    }

    public Date getTimeCreated() {
        return this.timeCreated;
    }

    public Date getTimeUpdated() {
        return this.timeUpdated;
    }

    public String getCreatedById() {
        return this.createdById;
    }

    public String getUpdatedById() {
        return this.updatedById;
    }

    public JobType getJobType() {
        return this.jobType;
    }

    public String getSubType() {
        return this.subType;
    }

    public String getParentKey() {
        return this.parentKey;
    }

    public Date getTimeStart() {
        return this.timeStart;
    }

    public Date getTimeEnd() {
        return this.timeEnd;
    }

    public String getErrorCode() {
        return this.errorCode;
    }

    public String getErrorMessage() {
        return this.errorMessage;
    }

    public String getProcessKey() {
        return this.processKey;
    }

    public String getExternalUrl() {
        return this.externalUrl;
    }

    public String getEventKey() {
        return this.eventKey;
    }

    public String getDataEntityKey() {
        return this.dataEntityKey;
    }

    public List<Fields> getFields() {
        return this.fields;
    }

    public SortBy getSortBy() {
        return this.sortBy;
    }

    public SortOrder getSortOrder() {
        return this.sortOrder;
    }

    public Integer getLimit() {
        return this.limit;
    }

    public String getPage() {
        return this.page;
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    public static class Builder
    implements BmcRequest.Builder<ListJobExecutionsRequest, Void> {
        private String catalogId;
        private String jobKey;
        private JobExecutionState lifecycleState;
        private Date timeCreated;
        private Date timeUpdated;
        private String createdById;
        private String updatedById;
        private JobType jobType;
        private String subType;
        private String parentKey;
        private Date timeStart;
        private Date timeEnd;
        private String errorCode;
        private String errorMessage;
        private String processKey;
        private String externalUrl;
        private String eventKey;
        private String dataEntityKey;
        private List<Fields> fields;
        private SortBy sortBy;
        private SortOrder sortOrder;
        private Integer limit;
        private String page;
        private String opcRequestId;
        private Consumer<Invocation.Builder> invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;

        public Builder invocationCallback(Consumer<Invocation.Builder> invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(ListJobExecutionsRequest o) {
            this.catalogId(o.getCatalogId());
            this.jobKey(o.getJobKey());
            this.lifecycleState(o.getLifecycleState());
            this.timeCreated(o.getTimeCreated());
            this.timeUpdated(o.getTimeUpdated());
            this.createdById(o.getCreatedById());
            this.updatedById(o.getUpdatedById());
            this.jobType(o.getJobType());
            this.subType(o.getSubType());
            this.parentKey(o.getParentKey());
            this.timeStart(o.getTimeStart());
            this.timeEnd(o.getTimeEnd());
            this.errorCode(o.getErrorCode());
            this.errorMessage(o.getErrorMessage());
            this.processKey(o.getProcessKey());
            this.externalUrl(o.getExternalUrl());
            this.eventKey(o.getEventKey());
            this.dataEntityKey(o.getDataEntityKey());
            this.fields(o.getFields());
            this.sortBy(o.getSortBy());
            this.sortOrder(o.getSortOrder());
            this.limit(o.getLimit());
            this.page(o.getPage());
            this.opcRequestId(o.getOpcRequestId());
            this.invocationCallback((Consumer<Invocation.Builder>)o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public ListJobExecutionsRequest build() {
            ListJobExecutionsRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        Builder() {
        }

        public Builder catalogId(String catalogId) {
            this.catalogId = catalogId;
            return this;
        }

        public Builder jobKey(String jobKey) {
            this.jobKey = jobKey;
            return this;
        }

        public Builder lifecycleState(JobExecutionState lifecycleState) {
            this.lifecycleState = lifecycleState;
            return this;
        }

        public Builder timeCreated(Date timeCreated) {
            this.timeCreated = timeCreated;
            return this;
        }

        public Builder timeUpdated(Date timeUpdated) {
            this.timeUpdated = timeUpdated;
            return this;
        }

        public Builder createdById(String createdById) {
            this.createdById = createdById;
            return this;
        }

        public Builder updatedById(String updatedById) {
            this.updatedById = updatedById;
            return this;
        }

        public Builder jobType(JobType jobType) {
            this.jobType = jobType;
            return this;
        }

        public Builder subType(String subType) {
            this.subType = subType;
            return this;
        }

        public Builder parentKey(String parentKey) {
            this.parentKey = parentKey;
            return this;
        }

        public Builder timeStart(Date timeStart) {
            this.timeStart = timeStart;
            return this;
        }

        public Builder timeEnd(Date timeEnd) {
            this.timeEnd = timeEnd;
            return this;
        }

        public Builder errorCode(String errorCode) {
            this.errorCode = errorCode;
            return this;
        }

        public Builder errorMessage(String errorMessage) {
            this.errorMessage = errorMessage;
            return this;
        }

        public Builder processKey(String processKey) {
            this.processKey = processKey;
            return this;
        }

        public Builder externalUrl(String externalUrl) {
            this.externalUrl = externalUrl;
            return this;
        }

        public Builder eventKey(String eventKey) {
            this.eventKey = eventKey;
            return this;
        }

        public Builder dataEntityKey(String dataEntityKey) {
            this.dataEntityKey = dataEntityKey;
            return this;
        }

        public Builder fields(List<Fields> fields) {
            this.fields = fields;
            return this;
        }

        public Builder sortBy(SortBy sortBy) {
            this.sortBy = sortBy;
            return this;
        }

        public Builder sortOrder(SortOrder sortOrder) {
            this.sortOrder = sortOrder;
            return this;
        }

        public Builder limit(Integer limit) {
            this.limit = limit;
            return this;
        }

        public Builder page(String page) {
            this.page = page;
            return this;
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public ListJobExecutionsRequest buildWithoutInvocationCallback() {
            return new ListJobExecutionsRequest(this.catalogId, this.jobKey, this.lifecycleState, this.timeCreated, this.timeUpdated, this.createdById, this.updatedById, this.jobType, this.subType, this.parentKey, this.timeStart, this.timeEnd, this.errorCode, this.errorMessage, this.processKey, this.externalUrl, this.eventKey, this.dataEntityKey, this.fields, this.sortBy, this.sortOrder, this.limit, this.page, this.opcRequestId);
        }

        public String toString() {
            return "ListJobExecutionsRequest.Builder(catalogId=" + this.catalogId + ", jobKey=" + this.jobKey + ", lifecycleState=" + (Object)((Object)this.lifecycleState) + ", timeCreated=" + this.timeCreated + ", timeUpdated=" + this.timeUpdated + ", createdById=" + this.createdById + ", updatedById=" + this.updatedById + ", jobType=" + (Object)((Object)this.jobType) + ", subType=" + this.subType + ", parentKey=" + this.parentKey + ", timeStart=" + this.timeStart + ", timeEnd=" + this.timeEnd + ", errorCode=" + this.errorCode + ", errorMessage=" + this.errorMessage + ", processKey=" + this.processKey + ", externalUrl=" + this.externalUrl + ", eventKey=" + this.eventKey + ", dataEntityKey=" + this.dataEntityKey + ", fields=" + this.fields + ", sortBy=" + (Object)((Object)this.sortBy) + ", sortOrder=" + (Object)((Object)this.sortOrder) + ", limit=" + this.limit + ", page=" + this.page + ", opcRequestId=" + this.opcRequestId + ")";
        }
    }

    public static enum SortOrder {
        Asc("ASC"),
        Desc("DESC");

        private final String value;
        private static Map<String, SortOrder> map;

        private SortOrder(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static SortOrder create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            throw new IllegalArgumentException("Invalid SortOrder: " + key);
        }

        static {
            map = new HashMap<String, SortOrder>();
            for (SortOrder v : SortOrder.values()) {
                map.put(v.getValue(), v);
            }
        }
    }

    public static enum SortBy {
        Timecreated("TIMECREATED"),
        Displayname("DISPLAYNAME");

        private final String value;
        private static Map<String, SortBy> map;

        private SortBy(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static SortBy create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            throw new IllegalArgumentException("Invalid SortBy: " + key);
        }

        static {
            map = new HashMap<String, SortBy>();
            for (SortBy v : SortBy.values()) {
                map.put(v.getValue(), v);
            }
        }
    }

    public static enum Fields {
        Key("key"),
        JobKey("jobKey"),
        JobType("jobType"),
        ParentKey("parentKey"),
        ScheduleInstanceKey("scheduleInstanceKey"),
        LifecycleState("lifecycleState"),
        TimeCreated("timeCreated"),
        TimeStarted("timeStarted"),
        TimeEnded("timeEnded"),
        Uri("uri");

        private final String value;
        private static Map<String, Fields> map;

        private Fields(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static Fields create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            throw new IllegalArgumentException("Invalid Fields: " + key);
        }

        static {
            map = new HashMap<String, Fields>();
            for (Fields v : Fields.values()) {
                map.put(v.getValue(), v);
            }
        }
    }
}

