/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.datacatalog.requests;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import com.oracle.bmc.datacatalog.model.LifecycleState;
import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import com.oracle.bmc.util.internal.Consumer;
import java.beans.ConstructorProperties;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.ws.rs.client.Invocation;

public class ListJobLogsRequest
extends BmcRequest<Void> {
    private String catalogId;
    private String jobKey;
    private String jobExecutionKey;
    private LifecycleState lifecycleState;
    private String severity;
    private Date timeCreated;
    private Date timeUpdated;
    private String createdById;
    private String updatedById;
    private List<Fields> fields;
    private SortBy sortBy;
    private SortOrder sortOrder;
    private Integer limit;
    private String page;
    private String opcRequestId;

    @ConstructorProperties(value={"catalogId", "jobKey", "jobExecutionKey", "lifecycleState", "severity", "timeCreated", "timeUpdated", "createdById", "updatedById", "fields", "sortBy", "sortOrder", "limit", "page", "opcRequestId"})
    ListJobLogsRequest(String catalogId, String jobKey, String jobExecutionKey, LifecycleState lifecycleState, String severity, Date timeCreated, Date timeUpdated, String createdById, String updatedById, List<Fields> fields, SortBy sortBy, SortOrder sortOrder, Integer limit, String page, String opcRequestId) {
        this.catalogId = catalogId;
        this.jobKey = jobKey;
        this.jobExecutionKey = jobExecutionKey;
        this.lifecycleState = lifecycleState;
        this.severity = severity;
        this.timeCreated = timeCreated;
        this.timeUpdated = timeUpdated;
        this.createdById = createdById;
        this.updatedById = updatedById;
        this.fields = fields;
        this.sortBy = sortBy;
        this.sortOrder = sortOrder;
        this.limit = limit;
        this.page = page;
        this.opcRequestId = opcRequestId;
    }

    public static Builder builder() {
        return new Builder();
    }

    public String getCatalogId() {
        return this.catalogId;
    }

    public String getJobKey() {
        return this.jobKey;
    }

    public String getJobExecutionKey() {
        return this.jobExecutionKey;
    }

    public LifecycleState getLifecycleState() {
        return this.lifecycleState;
    }

    public String getSeverity() {
        return this.severity;
    }

    public Date getTimeCreated() {
        return this.timeCreated;
    }

    public Date getTimeUpdated() {
        return this.timeUpdated;
    }

    public String getCreatedById() {
        return this.createdById;
    }

    public String getUpdatedById() {
        return this.updatedById;
    }

    public List<Fields> getFields() {
        return this.fields;
    }

    public SortBy getSortBy() {
        return this.sortBy;
    }

    public SortOrder getSortOrder() {
        return this.sortOrder;
    }

    public Integer getLimit() {
        return this.limit;
    }

    public String getPage() {
        return this.page;
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    public static class Builder
    implements BmcRequest.Builder<ListJobLogsRequest, Void> {
        private String catalogId;
        private String jobKey;
        private String jobExecutionKey;
        private LifecycleState lifecycleState;
        private String severity;
        private Date timeCreated;
        private Date timeUpdated;
        private String createdById;
        private String updatedById;
        private List<Fields> fields;
        private SortBy sortBy;
        private SortOrder sortOrder;
        private Integer limit;
        private String page;
        private String opcRequestId;
        private Consumer<Invocation.Builder> invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;

        public Builder invocationCallback(Consumer<Invocation.Builder> invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(ListJobLogsRequest o) {
            this.catalogId(o.getCatalogId());
            this.jobKey(o.getJobKey());
            this.jobExecutionKey(o.getJobExecutionKey());
            this.lifecycleState(o.getLifecycleState());
            this.severity(o.getSeverity());
            this.timeCreated(o.getTimeCreated());
            this.timeUpdated(o.getTimeUpdated());
            this.createdById(o.getCreatedById());
            this.updatedById(o.getUpdatedById());
            this.fields(o.getFields());
            this.sortBy(o.getSortBy());
            this.sortOrder(o.getSortOrder());
            this.limit(o.getLimit());
            this.page(o.getPage());
            this.opcRequestId(o.getOpcRequestId());
            this.invocationCallback((Consumer<Invocation.Builder>)o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public ListJobLogsRequest build() {
            ListJobLogsRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        Builder() {
        }

        public Builder catalogId(String catalogId) {
            this.catalogId = catalogId;
            return this;
        }

        public Builder jobKey(String jobKey) {
            this.jobKey = jobKey;
            return this;
        }

        public Builder jobExecutionKey(String jobExecutionKey) {
            this.jobExecutionKey = jobExecutionKey;
            return this;
        }

        public Builder lifecycleState(LifecycleState lifecycleState) {
            this.lifecycleState = lifecycleState;
            return this;
        }

        public Builder severity(String severity) {
            this.severity = severity;
            return this;
        }

        public Builder timeCreated(Date timeCreated) {
            this.timeCreated = timeCreated;
            return this;
        }

        public Builder timeUpdated(Date timeUpdated) {
            this.timeUpdated = timeUpdated;
            return this;
        }

        public Builder createdById(String createdById) {
            this.createdById = createdById;
            return this;
        }

        public Builder updatedById(String updatedById) {
            this.updatedById = updatedById;
            return this;
        }

        public Builder fields(List<Fields> fields) {
            this.fields = fields;
            return this;
        }

        public Builder sortBy(SortBy sortBy) {
            this.sortBy = sortBy;
            return this;
        }

        public Builder sortOrder(SortOrder sortOrder) {
            this.sortOrder = sortOrder;
            return this;
        }

        public Builder limit(Integer limit) {
            this.limit = limit;
            return this;
        }

        public Builder page(String page) {
            this.page = page;
            return this;
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public ListJobLogsRequest buildWithoutInvocationCallback() {
            return new ListJobLogsRequest(this.catalogId, this.jobKey, this.jobExecutionKey, this.lifecycleState, this.severity, this.timeCreated, this.timeUpdated, this.createdById, this.updatedById, this.fields, this.sortBy, this.sortOrder, this.limit, this.page, this.opcRequestId);
        }

        public String toString() {
            return "ListJobLogsRequest.Builder(catalogId=" + this.catalogId + ", jobKey=" + this.jobKey + ", jobExecutionKey=" + this.jobExecutionKey + ", lifecycleState=" + (Object)((Object)this.lifecycleState) + ", severity=" + this.severity + ", timeCreated=" + this.timeCreated + ", timeUpdated=" + this.timeUpdated + ", createdById=" + this.createdById + ", updatedById=" + this.updatedById + ", fields=" + this.fields + ", sortBy=" + (Object)((Object)this.sortBy) + ", sortOrder=" + (Object)((Object)this.sortOrder) + ", limit=" + this.limit + ", page=" + this.page + ", opcRequestId=" + this.opcRequestId + ")";
        }
    }

    public static enum SortOrder {
        Asc("ASC"),
        Desc("DESC");

        private final String value;
        private static Map<String, SortOrder> map;

        private SortOrder(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static SortOrder create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            throw new IllegalArgumentException("Invalid SortOrder: " + key);
        }

        static {
            map = new HashMap<String, SortOrder>();
            for (SortOrder v : SortOrder.values()) {
                map.put(v.getValue(), v);
            }
        }
    }

    public static enum SortBy {
        Timecreated("TIMECREATED"),
        Displayname("DISPLAYNAME");

        private final String value;
        private static Map<String, SortBy> map;

        private SortBy(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static SortBy create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            throw new IllegalArgumentException("Invalid SortBy: " + key);
        }

        static {
            map = new HashMap<String, SortBy>();
            for (SortBy v : SortBy.values()) {
                map.put(v.getValue(), v);
            }
        }
    }

    public static enum Fields {
        Key("key"),
        JobExecutionKey("jobExecutionKey"),
        Severity("severity"),
        TimeCreated("timeCreated"),
        LogMessage("logMessage"),
        Uri("uri");

        private final String value;
        private static Map<String, Fields> map;

        private Fields(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static Fields create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            throw new IllegalArgumentException("Invalid Fields: " + key);
        }

        static {
            map = new HashMap<String, Fields>();
            for (Fields v : Fields.values()) {
                map.put(v.getValue(), v);
            }
        }
    }
}

