/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.datacatalog.requests;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import com.oracle.bmc.datacatalog.model.LifecycleState;
import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import com.oracle.bmc.util.internal.Consumer;
import java.beans.ConstructorProperties;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.ws.rs.client.Invocation;

public class ListTermRelationshipsRequest
extends BmcRequest<Void> {
    private String catalogId;
    private String glossaryKey;
    private String termKey;
    private String displayName;
    private String displayNameContains;
    private LifecycleState lifecycleState;
    private List<Fields> fields;
    private SortBy sortBy;
    private SortOrder sortOrder;
    private Integer limit;
    private String page;
    private String opcRequestId;

    @ConstructorProperties(value={"catalogId", "glossaryKey", "termKey", "displayName", "displayNameContains", "lifecycleState", "fields", "sortBy", "sortOrder", "limit", "page", "opcRequestId"})
    ListTermRelationshipsRequest(String catalogId, String glossaryKey, String termKey, String displayName, String displayNameContains, LifecycleState lifecycleState, List<Fields> fields, SortBy sortBy, SortOrder sortOrder, Integer limit, String page, String opcRequestId) {
        this.catalogId = catalogId;
        this.glossaryKey = glossaryKey;
        this.termKey = termKey;
        this.displayName = displayName;
        this.displayNameContains = displayNameContains;
        this.lifecycleState = lifecycleState;
        this.fields = fields;
        this.sortBy = sortBy;
        this.sortOrder = sortOrder;
        this.limit = limit;
        this.page = page;
        this.opcRequestId = opcRequestId;
    }

    public static Builder builder() {
        return new Builder();
    }

    public String getCatalogId() {
        return this.catalogId;
    }

    public String getGlossaryKey() {
        return this.glossaryKey;
    }

    public String getTermKey() {
        return this.termKey;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public String getDisplayNameContains() {
        return this.displayNameContains;
    }

    public LifecycleState getLifecycleState() {
        return this.lifecycleState;
    }

    public List<Fields> getFields() {
        return this.fields;
    }

    public SortBy getSortBy() {
        return this.sortBy;
    }

    public SortOrder getSortOrder() {
        return this.sortOrder;
    }

    public Integer getLimit() {
        return this.limit;
    }

    public String getPage() {
        return this.page;
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    public static class Builder
    implements BmcRequest.Builder<ListTermRelationshipsRequest, Void> {
        private String catalogId;
        private String glossaryKey;
        private String termKey;
        private String displayName;
        private String displayNameContains;
        private LifecycleState lifecycleState;
        private List<Fields> fields;
        private SortBy sortBy;
        private SortOrder sortOrder;
        private Integer limit;
        private String page;
        private String opcRequestId;
        private Consumer<Invocation.Builder> invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;

        public Builder invocationCallback(Consumer<Invocation.Builder> invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(ListTermRelationshipsRequest o) {
            this.catalogId(o.getCatalogId());
            this.glossaryKey(o.getGlossaryKey());
            this.termKey(o.getTermKey());
            this.displayName(o.getDisplayName());
            this.displayNameContains(o.getDisplayNameContains());
            this.lifecycleState(o.getLifecycleState());
            this.fields(o.getFields());
            this.sortBy(o.getSortBy());
            this.sortOrder(o.getSortOrder());
            this.limit(o.getLimit());
            this.page(o.getPage());
            this.opcRequestId(o.getOpcRequestId());
            this.invocationCallback((Consumer<Invocation.Builder>)o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public ListTermRelationshipsRequest build() {
            ListTermRelationshipsRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        Builder() {
        }

        public Builder catalogId(String catalogId) {
            this.catalogId = catalogId;
            return this;
        }

        public Builder glossaryKey(String glossaryKey) {
            this.glossaryKey = glossaryKey;
            return this;
        }

        public Builder termKey(String termKey) {
            this.termKey = termKey;
            return this;
        }

        public Builder displayName(String displayName) {
            this.displayName = displayName;
            return this;
        }

        public Builder displayNameContains(String displayNameContains) {
            this.displayNameContains = displayNameContains;
            return this;
        }

        public Builder lifecycleState(LifecycleState lifecycleState) {
            this.lifecycleState = lifecycleState;
            return this;
        }

        public Builder fields(List<Fields> fields) {
            this.fields = fields;
            return this;
        }

        public Builder sortBy(SortBy sortBy) {
            this.sortBy = sortBy;
            return this;
        }

        public Builder sortOrder(SortOrder sortOrder) {
            this.sortOrder = sortOrder;
            return this;
        }

        public Builder limit(Integer limit) {
            this.limit = limit;
            return this;
        }

        public Builder page(String page) {
            this.page = page;
            return this;
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public ListTermRelationshipsRequest buildWithoutInvocationCallback() {
            return new ListTermRelationshipsRequest(this.catalogId, this.glossaryKey, this.termKey, this.displayName, this.displayNameContains, this.lifecycleState, this.fields, this.sortBy, this.sortOrder, this.limit, this.page, this.opcRequestId);
        }

        public String toString() {
            return "ListTermRelationshipsRequest.Builder(catalogId=" + this.catalogId + ", glossaryKey=" + this.glossaryKey + ", termKey=" + this.termKey + ", displayName=" + this.displayName + ", displayNameContains=" + this.displayNameContains + ", lifecycleState=" + (Object)((Object)this.lifecycleState) + ", fields=" + this.fields + ", sortBy=" + (Object)((Object)this.sortBy) + ", sortOrder=" + (Object)((Object)this.sortOrder) + ", limit=" + this.limit + ", page=" + this.page + ", opcRequestId=" + this.opcRequestId + ")";
        }
    }

    public static enum SortOrder {
        Asc("ASC"),
        Desc("DESC");

        private final String value;
        private static Map<String, SortOrder> map;

        private SortOrder(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static SortOrder create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            throw new IllegalArgumentException("Invalid SortOrder: " + key);
        }

        static {
            map = new HashMap<String, SortOrder>();
            for (SortOrder v : SortOrder.values()) {
                map.put(v.getValue(), v);
            }
        }
    }

    public static enum SortBy {
        Timecreated("TIMECREATED"),
        Displayname("DISPLAYNAME");

        private final String value;
        private static Map<String, SortBy> map;

        private SortBy(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static SortBy create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            throw new IllegalArgumentException("Invalid SortBy: " + key);
        }

        static {
            map = new HashMap<String, SortBy>();
            for (SortBy v : SortBy.values()) {
                map.put(v.getValue(), v);
            }
        }
    }

    public static enum Fields {
        Key("key"),
        DisplayName("displayName"),
        Description("description"),
        RelatedTermKey("relatedTermKey"),
        RelatedTermDisplayName("relatedTermDisplayName"),
        ParentTermKey("parentTermKey"),
        ParentTermDisplayName("parentTermDisplayName"),
        LifecycleState("lifecycleState"),
        TimeCreated("timeCreated"),
        Uri("uri");

        private final String value;
        private static Map<String, Fields> map;

        private Fields(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static Fields create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            throw new IllegalArgumentException("Invalid Fields: " + key);
        }

        static {
            map = new HashMap<String, Fields>();
            for (Fields v : Fields.values()) {
                map.put(v.getValue(), v);
            }
        }
    }
}

