/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.datacatalog.requests;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import com.oracle.bmc.datacatalog.model.LifecycleState;
import com.oracle.bmc.datacatalog.model.TermWorkflowStatus;
import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import com.oracle.bmc.util.internal.Consumer;
import java.beans.ConstructorProperties;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.ws.rs.client.Invocation;

public class ListTermsRequest
extends BmcRequest<Void> {
    private String catalogId;
    private String glossaryKey;
    private String displayName;
    private String displayNameContains;
    private LifecycleState lifecycleState;
    private String parentTermKey;
    private Boolean isAllowedToHaveChildTerms;
    private TermWorkflowStatus workflowStatus;
    private String path;
    private List<Fields> fields;
    private SortBy sortBy;
    private SortOrder sortOrder;
    private Integer limit;
    private String page;
    private String opcRequestId;

    @ConstructorProperties(value={"catalogId", "glossaryKey", "displayName", "displayNameContains", "lifecycleState", "parentTermKey", "isAllowedToHaveChildTerms", "workflowStatus", "path", "fields", "sortBy", "sortOrder", "limit", "page", "opcRequestId"})
    ListTermsRequest(String catalogId, String glossaryKey, String displayName, String displayNameContains, LifecycleState lifecycleState, String parentTermKey, Boolean isAllowedToHaveChildTerms, TermWorkflowStatus workflowStatus, String path, List<Fields> fields, SortBy sortBy, SortOrder sortOrder, Integer limit, String page, String opcRequestId) {
        this.catalogId = catalogId;
        this.glossaryKey = glossaryKey;
        this.displayName = displayName;
        this.displayNameContains = displayNameContains;
        this.lifecycleState = lifecycleState;
        this.parentTermKey = parentTermKey;
        this.isAllowedToHaveChildTerms = isAllowedToHaveChildTerms;
        this.workflowStatus = workflowStatus;
        this.path = path;
        this.fields = fields;
        this.sortBy = sortBy;
        this.sortOrder = sortOrder;
        this.limit = limit;
        this.page = page;
        this.opcRequestId = opcRequestId;
    }

    public static Builder builder() {
        return new Builder();
    }

    public String getCatalogId() {
        return this.catalogId;
    }

    public String getGlossaryKey() {
        return this.glossaryKey;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public String getDisplayNameContains() {
        return this.displayNameContains;
    }

    public LifecycleState getLifecycleState() {
        return this.lifecycleState;
    }

    public String getParentTermKey() {
        return this.parentTermKey;
    }

    public Boolean getIsAllowedToHaveChildTerms() {
        return this.isAllowedToHaveChildTerms;
    }

    public TermWorkflowStatus getWorkflowStatus() {
        return this.workflowStatus;
    }

    public String getPath() {
        return this.path;
    }

    public List<Fields> getFields() {
        return this.fields;
    }

    public SortBy getSortBy() {
        return this.sortBy;
    }

    public SortOrder getSortOrder() {
        return this.sortOrder;
    }

    public Integer getLimit() {
        return this.limit;
    }

    public String getPage() {
        return this.page;
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    public static class Builder
    implements BmcRequest.Builder<ListTermsRequest, Void> {
        private String catalogId;
        private String glossaryKey;
        private String displayName;
        private String displayNameContains;
        private LifecycleState lifecycleState;
        private String parentTermKey;
        private Boolean isAllowedToHaveChildTerms;
        private TermWorkflowStatus workflowStatus;
        private String path;
        private List<Fields> fields;
        private SortBy sortBy;
        private SortOrder sortOrder;
        private Integer limit;
        private String page;
        private String opcRequestId;
        private Consumer<Invocation.Builder> invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;

        public Builder invocationCallback(Consumer<Invocation.Builder> invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(ListTermsRequest o) {
            this.catalogId(o.getCatalogId());
            this.glossaryKey(o.getGlossaryKey());
            this.displayName(o.getDisplayName());
            this.displayNameContains(o.getDisplayNameContains());
            this.lifecycleState(o.getLifecycleState());
            this.parentTermKey(o.getParentTermKey());
            this.isAllowedToHaveChildTerms(o.getIsAllowedToHaveChildTerms());
            this.workflowStatus(o.getWorkflowStatus());
            this.path(o.getPath());
            this.fields(o.getFields());
            this.sortBy(o.getSortBy());
            this.sortOrder(o.getSortOrder());
            this.limit(o.getLimit());
            this.page(o.getPage());
            this.opcRequestId(o.getOpcRequestId());
            this.invocationCallback((Consumer<Invocation.Builder>)o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public ListTermsRequest build() {
            ListTermsRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        Builder() {
        }

        public Builder catalogId(String catalogId) {
            this.catalogId = catalogId;
            return this;
        }

        public Builder glossaryKey(String glossaryKey) {
            this.glossaryKey = glossaryKey;
            return this;
        }

        public Builder displayName(String displayName) {
            this.displayName = displayName;
            return this;
        }

        public Builder displayNameContains(String displayNameContains) {
            this.displayNameContains = displayNameContains;
            return this;
        }

        public Builder lifecycleState(LifecycleState lifecycleState) {
            this.lifecycleState = lifecycleState;
            return this;
        }

        public Builder parentTermKey(String parentTermKey) {
            this.parentTermKey = parentTermKey;
            return this;
        }

        public Builder isAllowedToHaveChildTerms(Boolean isAllowedToHaveChildTerms) {
            this.isAllowedToHaveChildTerms = isAllowedToHaveChildTerms;
            return this;
        }

        public Builder workflowStatus(TermWorkflowStatus workflowStatus) {
            this.workflowStatus = workflowStatus;
            return this;
        }

        public Builder path(String path) {
            this.path = path;
            return this;
        }

        public Builder fields(List<Fields> fields) {
            this.fields = fields;
            return this;
        }

        public Builder sortBy(SortBy sortBy) {
            this.sortBy = sortBy;
            return this;
        }

        public Builder sortOrder(SortOrder sortOrder) {
            this.sortOrder = sortOrder;
            return this;
        }

        public Builder limit(Integer limit) {
            this.limit = limit;
            return this;
        }

        public Builder page(String page) {
            this.page = page;
            return this;
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public ListTermsRequest buildWithoutInvocationCallback() {
            return new ListTermsRequest(this.catalogId, this.glossaryKey, this.displayName, this.displayNameContains, this.lifecycleState, this.parentTermKey, this.isAllowedToHaveChildTerms, this.workflowStatus, this.path, this.fields, this.sortBy, this.sortOrder, this.limit, this.page, this.opcRequestId);
        }

        public String toString() {
            return "ListTermsRequest.Builder(catalogId=" + this.catalogId + ", glossaryKey=" + this.glossaryKey + ", displayName=" + this.displayName + ", displayNameContains=" + this.displayNameContains + ", lifecycleState=" + (Object)((Object)this.lifecycleState) + ", parentTermKey=" + this.parentTermKey + ", isAllowedToHaveChildTerms=" + this.isAllowedToHaveChildTerms + ", workflowStatus=" + (Object)((Object)this.workflowStatus) + ", path=" + this.path + ", fields=" + this.fields + ", sortBy=" + (Object)((Object)this.sortBy) + ", sortOrder=" + (Object)((Object)this.sortOrder) + ", limit=" + this.limit + ", page=" + this.page + ", opcRequestId=" + this.opcRequestId + ")";
        }
    }

    public static enum SortOrder {
        Asc("ASC"),
        Desc("DESC");

        private final String value;
        private static Map<String, SortOrder> map;

        private SortOrder(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static SortOrder create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            throw new IllegalArgumentException("Invalid SortOrder: " + key);
        }

        static {
            map = new HashMap<String, SortOrder>();
            for (SortOrder v : SortOrder.values()) {
                map.put(v.getValue(), v);
            }
        }
    }

    public static enum SortBy {
        Timecreated("TIMECREATED"),
        Displayname("DISPLAYNAME");

        private final String value;
        private static Map<String, SortBy> map;

        private SortBy(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static SortBy create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            throw new IllegalArgumentException("Invalid SortBy: " + key);
        }

        static {
            map = new HashMap<String, SortBy>();
            for (SortBy v : SortBy.values()) {
                map.put(v.getValue(), v);
            }
        }
    }

    public static enum Fields {
        Key("key"),
        DisplayName("displayName"),
        Description("description"),
        GlossaryKey("glossaryKey"),
        ParentTermKey("parentTermKey"),
        IsAllowedToHaveChildTerms("isAllowedToHaveChildTerms"),
        Path("path"),
        LifecycleState("lifecycleState"),
        TimeCreated("timeCreated"),
        WorkflowStatus("workflowStatus"),
        AssociatedObjectCount("associatedObjectCount"),
        Uri("uri");

        private final String value;
        private static Map<String, Fields> map;

        private Fields(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static Fields create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            throw new IllegalArgumentException("Invalid Fields: " + key);
        }

        static {
            map = new HashMap<String, Fields>();
            for (Fields v : Fields.values()) {
                map.put(v.getValue(), v);
            }
        }
    }
}

