/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.datacatalog.requests;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import com.oracle.bmc.datacatalog.model.LifecycleState;
import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import com.oracle.bmc.util.internal.Consumer;
import java.beans.ConstructorProperties;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.ws.rs.client.Invocation;

public class ListTypesRequest
extends BmcRequest<Void> {
    private String catalogId;
    private String name;
    private LifecycleState lifecycleState;
    private String isInternal;
    private String isTag;
    private String isApproved;
    private String externalTypeName;
    private String typeCategory;
    private List<Fields> fields;
    private SortBy sortBy;
    private SortOrder sortOrder;
    private Integer limit;
    private String page;
    private String opcRequestId;

    @ConstructorProperties(value={"catalogId", "name", "lifecycleState", "isInternal", "isTag", "isApproved", "externalTypeName", "typeCategory", "fields", "sortBy", "sortOrder", "limit", "page", "opcRequestId"})
    ListTypesRequest(String catalogId, String name, LifecycleState lifecycleState, String isInternal, String isTag, String isApproved, String externalTypeName, String typeCategory, List<Fields> fields, SortBy sortBy, SortOrder sortOrder, Integer limit, String page, String opcRequestId) {
        this.catalogId = catalogId;
        this.name = name;
        this.lifecycleState = lifecycleState;
        this.isInternal = isInternal;
        this.isTag = isTag;
        this.isApproved = isApproved;
        this.externalTypeName = externalTypeName;
        this.typeCategory = typeCategory;
        this.fields = fields;
        this.sortBy = sortBy;
        this.sortOrder = sortOrder;
        this.limit = limit;
        this.page = page;
        this.opcRequestId = opcRequestId;
    }

    public static Builder builder() {
        return new Builder();
    }

    public String getCatalogId() {
        return this.catalogId;
    }

    public String getName() {
        return this.name;
    }

    public LifecycleState getLifecycleState() {
        return this.lifecycleState;
    }

    public String getIsInternal() {
        return this.isInternal;
    }

    public String getIsTag() {
        return this.isTag;
    }

    public String getIsApproved() {
        return this.isApproved;
    }

    public String getExternalTypeName() {
        return this.externalTypeName;
    }

    public String getTypeCategory() {
        return this.typeCategory;
    }

    public List<Fields> getFields() {
        return this.fields;
    }

    public SortBy getSortBy() {
        return this.sortBy;
    }

    public SortOrder getSortOrder() {
        return this.sortOrder;
    }

    public Integer getLimit() {
        return this.limit;
    }

    public String getPage() {
        return this.page;
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    public static class Builder
    implements BmcRequest.Builder<ListTypesRequest, Void> {
        private String catalogId;
        private String name;
        private LifecycleState lifecycleState;
        private String isInternal;
        private String isTag;
        private String isApproved;
        private String externalTypeName;
        private String typeCategory;
        private List<Fields> fields;
        private SortBy sortBy;
        private SortOrder sortOrder;
        private Integer limit;
        private String page;
        private String opcRequestId;
        private Consumer<Invocation.Builder> invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;

        public Builder invocationCallback(Consumer<Invocation.Builder> invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(ListTypesRequest o) {
            this.catalogId(o.getCatalogId());
            this.name(o.getName());
            this.lifecycleState(o.getLifecycleState());
            this.isInternal(o.getIsInternal());
            this.isTag(o.getIsTag());
            this.isApproved(o.getIsApproved());
            this.externalTypeName(o.getExternalTypeName());
            this.typeCategory(o.getTypeCategory());
            this.fields(o.getFields());
            this.sortBy(o.getSortBy());
            this.sortOrder(o.getSortOrder());
            this.limit(o.getLimit());
            this.page(o.getPage());
            this.opcRequestId(o.getOpcRequestId());
            this.invocationCallback((Consumer<Invocation.Builder>)o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public ListTypesRequest build() {
            ListTypesRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        Builder() {
        }

        public Builder catalogId(String catalogId) {
            this.catalogId = catalogId;
            return this;
        }

        public Builder name(String name) {
            this.name = name;
            return this;
        }

        public Builder lifecycleState(LifecycleState lifecycleState) {
            this.lifecycleState = lifecycleState;
            return this;
        }

        public Builder isInternal(String isInternal) {
            this.isInternal = isInternal;
            return this;
        }

        public Builder isTag(String isTag) {
            this.isTag = isTag;
            return this;
        }

        public Builder isApproved(String isApproved) {
            this.isApproved = isApproved;
            return this;
        }

        public Builder externalTypeName(String externalTypeName) {
            this.externalTypeName = externalTypeName;
            return this;
        }

        public Builder typeCategory(String typeCategory) {
            this.typeCategory = typeCategory;
            return this;
        }

        public Builder fields(List<Fields> fields) {
            this.fields = fields;
            return this;
        }

        public Builder sortBy(SortBy sortBy) {
            this.sortBy = sortBy;
            return this;
        }

        public Builder sortOrder(SortOrder sortOrder) {
            this.sortOrder = sortOrder;
            return this;
        }

        public Builder limit(Integer limit) {
            this.limit = limit;
            return this;
        }

        public Builder page(String page) {
            this.page = page;
            return this;
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public ListTypesRequest buildWithoutInvocationCallback() {
            return new ListTypesRequest(this.catalogId, this.name, this.lifecycleState, this.isInternal, this.isTag, this.isApproved, this.externalTypeName, this.typeCategory, this.fields, this.sortBy, this.sortOrder, this.limit, this.page, this.opcRequestId);
        }

        public String toString() {
            return "ListTypesRequest.Builder(catalogId=" + this.catalogId + ", name=" + this.name + ", lifecycleState=" + (Object)((Object)this.lifecycleState) + ", isInternal=" + this.isInternal + ", isTag=" + this.isTag + ", isApproved=" + this.isApproved + ", externalTypeName=" + this.externalTypeName + ", typeCategory=" + this.typeCategory + ", fields=" + this.fields + ", sortBy=" + (Object)((Object)this.sortBy) + ", sortOrder=" + (Object)((Object)this.sortOrder) + ", limit=" + this.limit + ", page=" + this.page + ", opcRequestId=" + this.opcRequestId + ")";
        }
    }

    public static enum SortOrder {
        Asc("ASC"),
        Desc("DESC");

        private final String value;
        private static Map<String, SortOrder> map;

        private SortOrder(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static SortOrder create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            throw new IllegalArgumentException("Invalid SortOrder: " + key);
        }

        static {
            map = new HashMap<String, SortOrder>();
            for (SortOrder v : SortOrder.values()) {
                map.put(v.getValue(), v);
            }
        }
    }

    public static enum SortBy {
        Timecreated("TIMECREATED"),
        Displayname("DISPLAYNAME");

        private final String value;
        private static Map<String, SortBy> map;

        private SortBy(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static SortBy create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            throw new IllegalArgumentException("Invalid SortBy: " + key);
        }

        static {
            map = new HashMap<String, SortBy>();
            for (SortBy v : SortBy.values()) {
                map.put(v.getValue(), v);
            }
        }
    }

    public static enum Fields {
        Key("key"),
        Description("description"),
        Name("name"),
        CatalogId("catalogId"),
        LifecycleState("lifecycleState"),
        TypeCategory("typeCategory"),
        Uri("uri");

        private final String value;
        private static Map<String, Fields> map;

        private Fields(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static Fields create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            throw new IllegalArgumentException("Invalid Fields: " + key);
        }

        static {
            map = new HashMap<String, Fields>();
            for (Fields v : Fields.values()) {
                map.put(v.getValue(), v);
            }
        }
    }
}

