/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.datacatalog.requests;

import com.oracle.bmc.InternalSdk;
import com.oracle.bmc.datacatalog.model.ParseConnectionDetails;
import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import com.oracle.bmc.util.internal.Consumer;
import java.beans.ConstructorProperties;
import javax.ws.rs.client.Invocation;

public class ParseConnectionRequest
extends BmcRequest<ParseConnectionDetails> {
    private String catalogId;
    private String dataAssetKey;
    private ParseConnectionDetails parseConnectionDetails;
    private String connectionKey;
    private String opcRequestId;
    private String opcRetryToken;

    @InternalSdk
    public ParseConnectionDetails getBody$() {
        return this.parseConnectionDetails;
    }

    @ConstructorProperties(value={"catalogId", "dataAssetKey", "parseConnectionDetails", "connectionKey", "opcRequestId", "opcRetryToken"})
    ParseConnectionRequest(String catalogId, String dataAssetKey, ParseConnectionDetails parseConnectionDetails, String connectionKey, String opcRequestId, String opcRetryToken) {
        this.catalogId = catalogId;
        this.dataAssetKey = dataAssetKey;
        this.parseConnectionDetails = parseConnectionDetails;
        this.connectionKey = connectionKey;
        this.opcRequestId = opcRequestId;
        this.opcRetryToken = opcRetryToken;
    }

    public static Builder builder() {
        return new Builder();
    }

    public String getCatalogId() {
        return this.catalogId;
    }

    public String getDataAssetKey() {
        return this.dataAssetKey;
    }

    public ParseConnectionDetails getParseConnectionDetails() {
        return this.parseConnectionDetails;
    }

    public String getConnectionKey() {
        return this.connectionKey;
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    public String getOpcRetryToken() {
        return this.opcRetryToken;
    }

    public static class Builder
    implements BmcRequest.Builder<ParseConnectionRequest, ParseConnectionDetails> {
        private String catalogId;
        private String dataAssetKey;
        private ParseConnectionDetails parseConnectionDetails;
        private String connectionKey;
        private String opcRequestId;
        private String opcRetryToken;
        private Consumer<Invocation.Builder> invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;

        public Builder invocationCallback(Consumer<Invocation.Builder> invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(ParseConnectionRequest o) {
            this.catalogId(o.getCatalogId());
            this.dataAssetKey(o.getDataAssetKey());
            this.parseConnectionDetails(o.getParseConnectionDetails());
            this.connectionKey(o.getConnectionKey());
            this.opcRequestId(o.getOpcRequestId());
            this.opcRetryToken(o.getOpcRetryToken());
            this.invocationCallback((Consumer<Invocation.Builder>)o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public ParseConnectionRequest build() {
            ParseConnectionRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        @InternalSdk
        public Builder body$(ParseConnectionDetails body) {
            this.parseConnectionDetails(body);
            return this;
        }

        Builder() {
        }

        public Builder catalogId(String catalogId) {
            this.catalogId = catalogId;
            return this;
        }

        public Builder dataAssetKey(String dataAssetKey) {
            this.dataAssetKey = dataAssetKey;
            return this;
        }

        public Builder parseConnectionDetails(ParseConnectionDetails parseConnectionDetails) {
            this.parseConnectionDetails = parseConnectionDetails;
            return this;
        }

        public Builder connectionKey(String connectionKey) {
            this.connectionKey = connectionKey;
            return this;
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public Builder opcRetryToken(String opcRetryToken) {
            this.opcRetryToken = opcRetryToken;
            return this;
        }

        public ParseConnectionRequest buildWithoutInvocationCallback() {
            return new ParseConnectionRequest(this.catalogId, this.dataAssetKey, this.parseConnectionDetails, this.connectionKey, this.opcRequestId, this.opcRetryToken);
        }

        public String toString() {
            return "ParseConnectionRequest.Builder(catalogId=" + this.catalogId + ", dataAssetKey=" + this.dataAssetKey + ", parseConnectionDetails=" + this.parseConnectionDetails + ", connectionKey=" + this.connectionKey + ", opcRequestId=" + this.opcRequestId + ", opcRetryToken=" + this.opcRetryToken + ")";
        }
    }
}

