/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.datacatalog.requests;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import com.oracle.bmc.InternalSdk;
import com.oracle.bmc.datacatalog.model.LifecycleState;
import com.oracle.bmc.datacatalog.model.SearchCriteria;
import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import com.oracle.bmc.util.internal.Consumer;
import java.beans.ConstructorProperties;
import java.util.HashMap;
import java.util.Map;
import javax.ws.rs.client.Invocation;

public class SearchCriteriaRequest
extends BmcRequest<SearchCriteria> {
    private String catalogId;
    private SearchCriteria searchCriteriaDetails;
    private String displayName;
    private String name;
    private LifecycleState lifecycleState;
    private String timeout;
    private SortBy sortBy;
    private SortOrder sortOrder;
    private Integer limit;
    private String page;
    private String opcRequestId;

    @InternalSdk
    public SearchCriteria getBody$() {
        return this.searchCriteriaDetails;
    }

    @ConstructorProperties(value={"catalogId", "searchCriteriaDetails", "displayName", "name", "lifecycleState", "timeout", "sortBy", "sortOrder", "limit", "page", "opcRequestId"})
    SearchCriteriaRequest(String catalogId, SearchCriteria searchCriteriaDetails, String displayName, String name, LifecycleState lifecycleState, String timeout, SortBy sortBy, SortOrder sortOrder, Integer limit, String page, String opcRequestId) {
        this.catalogId = catalogId;
        this.searchCriteriaDetails = searchCriteriaDetails;
        this.displayName = displayName;
        this.name = name;
        this.lifecycleState = lifecycleState;
        this.timeout = timeout;
        this.sortBy = sortBy;
        this.sortOrder = sortOrder;
        this.limit = limit;
        this.page = page;
        this.opcRequestId = opcRequestId;
    }

    public static Builder builder() {
        return new Builder();
    }

    public String getCatalogId() {
        return this.catalogId;
    }

    public SearchCriteria getSearchCriteriaDetails() {
        return this.searchCriteriaDetails;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public String getName() {
        return this.name;
    }

    public LifecycleState getLifecycleState() {
        return this.lifecycleState;
    }

    public String getTimeout() {
        return this.timeout;
    }

    public SortBy getSortBy() {
        return this.sortBy;
    }

    public SortOrder getSortOrder() {
        return this.sortOrder;
    }

    public Integer getLimit() {
        return this.limit;
    }

    public String getPage() {
        return this.page;
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    public static class Builder
    implements BmcRequest.Builder<SearchCriteriaRequest, SearchCriteria> {
        private String catalogId;
        private SearchCriteria searchCriteriaDetails;
        private String displayName;
        private String name;
        private LifecycleState lifecycleState;
        private String timeout;
        private SortBy sortBy;
        private SortOrder sortOrder;
        private Integer limit;
        private String page;
        private String opcRequestId;
        private Consumer<Invocation.Builder> invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;

        public Builder invocationCallback(Consumer<Invocation.Builder> invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(SearchCriteriaRequest o) {
            this.catalogId(o.getCatalogId());
            this.searchCriteriaDetails(o.getSearchCriteriaDetails());
            this.displayName(o.getDisplayName());
            this.name(o.getName());
            this.lifecycleState(o.getLifecycleState());
            this.timeout(o.getTimeout());
            this.sortBy(o.getSortBy());
            this.sortOrder(o.getSortOrder());
            this.limit(o.getLimit());
            this.page(o.getPage());
            this.opcRequestId(o.getOpcRequestId());
            this.invocationCallback((Consumer<Invocation.Builder>)o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public SearchCriteriaRequest build() {
            SearchCriteriaRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        @InternalSdk
        public Builder body$(SearchCriteria body) {
            this.searchCriteriaDetails(body);
            return this;
        }

        Builder() {
        }

        public Builder catalogId(String catalogId) {
            this.catalogId = catalogId;
            return this;
        }

        public Builder searchCriteriaDetails(SearchCriteria searchCriteriaDetails) {
            this.searchCriteriaDetails = searchCriteriaDetails;
            return this;
        }

        public Builder displayName(String displayName) {
            this.displayName = displayName;
            return this;
        }

        public Builder name(String name) {
            this.name = name;
            return this;
        }

        public Builder lifecycleState(LifecycleState lifecycleState) {
            this.lifecycleState = lifecycleState;
            return this;
        }

        public Builder timeout(String timeout) {
            this.timeout = timeout;
            return this;
        }

        public Builder sortBy(SortBy sortBy) {
            this.sortBy = sortBy;
            return this;
        }

        public Builder sortOrder(SortOrder sortOrder) {
            this.sortOrder = sortOrder;
            return this;
        }

        public Builder limit(Integer limit) {
            this.limit = limit;
            return this;
        }

        public Builder page(String page) {
            this.page = page;
            return this;
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public SearchCriteriaRequest buildWithoutInvocationCallback() {
            return new SearchCriteriaRequest(this.catalogId, this.searchCriteriaDetails, this.displayName, this.name, this.lifecycleState, this.timeout, this.sortBy, this.sortOrder, this.limit, this.page, this.opcRequestId);
        }

        public String toString() {
            return "SearchCriteriaRequest.Builder(catalogId=" + this.catalogId + ", searchCriteriaDetails=" + this.searchCriteriaDetails + ", displayName=" + this.displayName + ", name=" + this.name + ", lifecycleState=" + (Object)((Object)this.lifecycleState) + ", timeout=" + this.timeout + ", sortBy=" + (Object)((Object)this.sortBy) + ", sortOrder=" + (Object)((Object)this.sortOrder) + ", limit=" + this.limit + ", page=" + this.page + ", opcRequestId=" + this.opcRequestId + ")";
        }
    }

    public static enum SortOrder {
        Asc("ASC"),
        Desc("DESC");

        private final String value;
        private static Map<String, SortOrder> map;

        private SortOrder(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static SortOrder create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            throw new IllegalArgumentException("Invalid SortOrder: " + key);
        }

        static {
            map = new HashMap<String, SortOrder>();
            for (SortOrder v : SortOrder.values()) {
                map.put(v.getValue(), v);
            }
        }
    }

    public static enum SortBy {
        Timecreated("TIMECREATED"),
        Displayname("DISPLAYNAME");

        private final String value;
        private static Map<String, SortBy> map;

        private SortBy(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static SortBy create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            throw new IllegalArgumentException("Invalid SortBy: " + key);
        }

        static {
            map = new HashMap<String, SortBy>();
            for (SortBy v : SortBy.values()) {
                map.put(v.getValue(), v);
            }
        }
    }
}

