/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.datacatalog.requests;

import com.oracle.bmc.InternalSdk;
import com.oracle.bmc.datacatalog.model.UpdateConnectionDetails;
import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import com.oracle.bmc.util.internal.Consumer;
import java.beans.ConstructorProperties;
import javax.ws.rs.client.Invocation;

public class UpdateConnectionRequest
extends BmcRequest<UpdateConnectionDetails> {
    private String catalogId;
    private String dataAssetKey;
    private String connectionKey;
    private UpdateConnectionDetails updateConnectionDetails;
    private String ifMatch;
    private String opcRequestId;

    @InternalSdk
    public UpdateConnectionDetails getBody$() {
        return this.updateConnectionDetails;
    }

    @ConstructorProperties(value={"catalogId", "dataAssetKey", "connectionKey", "updateConnectionDetails", "ifMatch", "opcRequestId"})
    UpdateConnectionRequest(String catalogId, String dataAssetKey, String connectionKey, UpdateConnectionDetails updateConnectionDetails, String ifMatch, String opcRequestId) {
        this.catalogId = catalogId;
        this.dataAssetKey = dataAssetKey;
        this.connectionKey = connectionKey;
        this.updateConnectionDetails = updateConnectionDetails;
        this.ifMatch = ifMatch;
        this.opcRequestId = opcRequestId;
    }

    public static Builder builder() {
        return new Builder();
    }

    public String getCatalogId() {
        return this.catalogId;
    }

    public String getDataAssetKey() {
        return this.dataAssetKey;
    }

    public String getConnectionKey() {
        return this.connectionKey;
    }

    public UpdateConnectionDetails getUpdateConnectionDetails() {
        return this.updateConnectionDetails;
    }

    public String getIfMatch() {
        return this.ifMatch;
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    public static class Builder
    implements BmcRequest.Builder<UpdateConnectionRequest, UpdateConnectionDetails> {
        private String catalogId;
        private String dataAssetKey;
        private String connectionKey;
        private UpdateConnectionDetails updateConnectionDetails;
        private String ifMatch;
        private String opcRequestId;
        private Consumer<Invocation.Builder> invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;

        public Builder invocationCallback(Consumer<Invocation.Builder> invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(UpdateConnectionRequest o) {
            this.catalogId(o.getCatalogId());
            this.dataAssetKey(o.getDataAssetKey());
            this.connectionKey(o.getConnectionKey());
            this.updateConnectionDetails(o.getUpdateConnectionDetails());
            this.ifMatch(o.getIfMatch());
            this.opcRequestId(o.getOpcRequestId());
            this.invocationCallback((Consumer<Invocation.Builder>)o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public UpdateConnectionRequest build() {
            UpdateConnectionRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        @InternalSdk
        public Builder body$(UpdateConnectionDetails body) {
            this.updateConnectionDetails(body);
            return this;
        }

        Builder() {
        }

        public Builder catalogId(String catalogId) {
            this.catalogId = catalogId;
            return this;
        }

        public Builder dataAssetKey(String dataAssetKey) {
            this.dataAssetKey = dataAssetKey;
            return this;
        }

        public Builder connectionKey(String connectionKey) {
            this.connectionKey = connectionKey;
            return this;
        }

        public Builder updateConnectionDetails(UpdateConnectionDetails updateConnectionDetails) {
            this.updateConnectionDetails = updateConnectionDetails;
            return this;
        }

        public Builder ifMatch(String ifMatch) {
            this.ifMatch = ifMatch;
            return this;
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public UpdateConnectionRequest buildWithoutInvocationCallback() {
            return new UpdateConnectionRequest(this.catalogId, this.dataAssetKey, this.connectionKey, this.updateConnectionDetails, this.ifMatch, this.opcRequestId);
        }

        public String toString() {
            return "UpdateConnectionRequest.Builder(catalogId=" + this.catalogId + ", dataAssetKey=" + this.dataAssetKey + ", connectionKey=" + this.connectionKey + ", updateConnectionDetails=" + this.updateConnectionDetails + ", ifMatch=" + this.ifMatch + ", opcRequestId=" + this.opcRequestId + ")";
        }
    }
}

