/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.datacatalog.requests;

import com.oracle.bmc.InternalSdk;
import com.oracle.bmc.datacatalog.model.UpdateJobDetails;
import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import com.oracle.bmc.util.internal.Consumer;
import java.beans.ConstructorProperties;
import javax.ws.rs.client.Invocation;

public class UpdateJobRequest
extends BmcRequest<UpdateJobDetails> {
    private String catalogId;
    private String jobKey;
    private UpdateJobDetails updateJobDetails;
    private String ifMatch;
    private String opcRequestId;

    @InternalSdk
    public UpdateJobDetails getBody$() {
        return this.updateJobDetails;
    }

    @ConstructorProperties(value={"catalogId", "jobKey", "updateJobDetails", "ifMatch", "opcRequestId"})
    UpdateJobRequest(String catalogId, String jobKey, UpdateJobDetails updateJobDetails, String ifMatch, String opcRequestId) {
        this.catalogId = catalogId;
        this.jobKey = jobKey;
        this.updateJobDetails = updateJobDetails;
        this.ifMatch = ifMatch;
        this.opcRequestId = opcRequestId;
    }

    public static Builder builder() {
        return new Builder();
    }

    public String getCatalogId() {
        return this.catalogId;
    }

    public String getJobKey() {
        return this.jobKey;
    }

    public UpdateJobDetails getUpdateJobDetails() {
        return this.updateJobDetails;
    }

    public String getIfMatch() {
        return this.ifMatch;
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    public static class Builder
    implements BmcRequest.Builder<UpdateJobRequest, UpdateJobDetails> {
        private String catalogId;
        private String jobKey;
        private UpdateJobDetails updateJobDetails;
        private String ifMatch;
        private String opcRequestId;
        private Consumer<Invocation.Builder> invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;

        public Builder invocationCallback(Consumer<Invocation.Builder> invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(UpdateJobRequest o) {
            this.catalogId(o.getCatalogId());
            this.jobKey(o.getJobKey());
            this.updateJobDetails(o.getUpdateJobDetails());
            this.ifMatch(o.getIfMatch());
            this.opcRequestId(o.getOpcRequestId());
            this.invocationCallback((Consumer<Invocation.Builder>)o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public UpdateJobRequest build() {
            UpdateJobRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        @InternalSdk
        public Builder body$(UpdateJobDetails body) {
            this.updateJobDetails(body);
            return this;
        }

        Builder() {
        }

        public Builder catalogId(String catalogId) {
            this.catalogId = catalogId;
            return this;
        }

        public Builder jobKey(String jobKey) {
            this.jobKey = jobKey;
            return this;
        }

        public Builder updateJobDetails(UpdateJobDetails updateJobDetails) {
            this.updateJobDetails = updateJobDetails;
            return this;
        }

        public Builder ifMatch(String ifMatch) {
            this.ifMatch = ifMatch;
            return this;
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public UpdateJobRequest buildWithoutInvocationCallback() {
            return new UpdateJobRequest(this.catalogId, this.jobKey, this.updateJobDetails, this.ifMatch, this.opcRequestId);
        }

        public String toString() {
            return "UpdateJobRequest.Builder(catalogId=" + this.catalogId + ", jobKey=" + this.jobKey + ", updateJobDetails=" + this.updateJobDetails + ", ifMatch=" + this.ifMatch + ", opcRequestId=" + this.opcRequestId + ")";
        }
    }
}

