/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.datacatalog.requests;

import com.oracle.bmc.InternalSdk;
import com.oracle.bmc.datacatalog.model.ValidateConnectionDetails;
import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import com.oracle.bmc.util.internal.Consumer;
import java.beans.ConstructorProperties;
import javax.ws.rs.client.Invocation;

public class ValidateConnectionRequest
extends BmcRequest<ValidateConnectionDetails> {
    private String catalogId;
    private String dataAssetKey;
    private ValidateConnectionDetails validateConnectionDetails;
    private String opcRequestId;
    private String opcRetryToken;

    @InternalSdk
    public ValidateConnectionDetails getBody$() {
        return this.validateConnectionDetails;
    }

    @ConstructorProperties(value={"catalogId", "dataAssetKey", "validateConnectionDetails", "opcRequestId", "opcRetryToken"})
    ValidateConnectionRequest(String catalogId, String dataAssetKey, ValidateConnectionDetails validateConnectionDetails, String opcRequestId, String opcRetryToken) {
        this.catalogId = catalogId;
        this.dataAssetKey = dataAssetKey;
        this.validateConnectionDetails = validateConnectionDetails;
        this.opcRequestId = opcRequestId;
        this.opcRetryToken = opcRetryToken;
    }

    public static Builder builder() {
        return new Builder();
    }

    public String getCatalogId() {
        return this.catalogId;
    }

    public String getDataAssetKey() {
        return this.dataAssetKey;
    }

    public ValidateConnectionDetails getValidateConnectionDetails() {
        return this.validateConnectionDetails;
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    public String getOpcRetryToken() {
        return this.opcRetryToken;
    }

    public static class Builder
    implements BmcRequest.Builder<ValidateConnectionRequest, ValidateConnectionDetails> {
        private String catalogId;
        private String dataAssetKey;
        private ValidateConnectionDetails validateConnectionDetails;
        private String opcRequestId;
        private String opcRetryToken;
        private Consumer<Invocation.Builder> invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;

        public Builder invocationCallback(Consumer<Invocation.Builder> invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(ValidateConnectionRequest o) {
            this.catalogId(o.getCatalogId());
            this.dataAssetKey(o.getDataAssetKey());
            this.validateConnectionDetails(o.getValidateConnectionDetails());
            this.opcRequestId(o.getOpcRequestId());
            this.opcRetryToken(o.getOpcRetryToken());
            this.invocationCallback((Consumer<Invocation.Builder>)o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public ValidateConnectionRequest build() {
            ValidateConnectionRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        @InternalSdk
        public Builder body$(ValidateConnectionDetails body) {
            this.validateConnectionDetails(body);
            return this;
        }

        Builder() {
        }

        public Builder catalogId(String catalogId) {
            this.catalogId = catalogId;
            return this;
        }

        public Builder dataAssetKey(String dataAssetKey) {
            this.dataAssetKey = dataAssetKey;
            return this;
        }

        public Builder validateConnectionDetails(ValidateConnectionDetails validateConnectionDetails) {
            this.validateConnectionDetails = validateConnectionDetails;
            return this;
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public Builder opcRetryToken(String opcRetryToken) {
            this.opcRetryToken = opcRetryToken;
            return this;
        }

        public ValidateConnectionRequest buildWithoutInvocationCallback() {
            return new ValidateConnectionRequest(this.catalogId, this.dataAssetKey, this.validateConnectionDetails, this.opcRequestId, this.opcRetryToken);
        }

        public String toString() {
            return "ValidateConnectionRequest.Builder(catalogId=" + this.catalogId + ", dataAssetKey=" + this.dataAssetKey + ", validateConnectionDetails=" + this.validateConnectionDetails + ", opcRequestId=" + this.opcRequestId + ", opcRetryToken=" + this.opcRetryToken + ")";
        }
    }
}

