/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.datacatalog.requests;

import com.oracle.bmc.InternalSdk;
import com.oracle.bmc.datacatalog.model.ValidatePatternDetails;
import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import com.oracle.bmc.util.internal.Consumer;
import java.beans.ConstructorProperties;
import javax.ws.rs.client.Invocation;

public class ValidatePatternRequest
extends BmcRequest<ValidatePatternDetails> {
    private String catalogId;
    private String patternKey;
    private ValidatePatternDetails validatePatternDetails;
    private String opcRequestId;
    private String opcRetryToken;

    @InternalSdk
    public ValidatePatternDetails getBody$() {
        return this.validatePatternDetails;
    }

    @ConstructorProperties(value={"catalogId", "patternKey", "validatePatternDetails", "opcRequestId", "opcRetryToken"})
    ValidatePatternRequest(String catalogId, String patternKey, ValidatePatternDetails validatePatternDetails, String opcRequestId, String opcRetryToken) {
        this.catalogId = catalogId;
        this.patternKey = patternKey;
        this.validatePatternDetails = validatePatternDetails;
        this.opcRequestId = opcRequestId;
        this.opcRetryToken = opcRetryToken;
    }

    public static Builder builder() {
        return new Builder();
    }

    public String getCatalogId() {
        return this.catalogId;
    }

    public String getPatternKey() {
        return this.patternKey;
    }

    public ValidatePatternDetails getValidatePatternDetails() {
        return this.validatePatternDetails;
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    public String getOpcRetryToken() {
        return this.opcRetryToken;
    }

    public static class Builder
    implements BmcRequest.Builder<ValidatePatternRequest, ValidatePatternDetails> {
        private String catalogId;
        private String patternKey;
        private ValidatePatternDetails validatePatternDetails;
        private String opcRequestId;
        private String opcRetryToken;
        private Consumer<Invocation.Builder> invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;

        public Builder invocationCallback(Consumer<Invocation.Builder> invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(ValidatePatternRequest o) {
            this.catalogId(o.getCatalogId());
            this.patternKey(o.getPatternKey());
            this.validatePatternDetails(o.getValidatePatternDetails());
            this.opcRequestId(o.getOpcRequestId());
            this.opcRetryToken(o.getOpcRetryToken());
            this.invocationCallback((Consumer<Invocation.Builder>)o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public ValidatePatternRequest build() {
            ValidatePatternRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        @InternalSdk
        public Builder body$(ValidatePatternDetails body) {
            this.validatePatternDetails(body);
            return this;
        }

        Builder() {
        }

        public Builder catalogId(String catalogId) {
            this.catalogId = catalogId;
            return this;
        }

        public Builder patternKey(String patternKey) {
            this.patternKey = patternKey;
            return this;
        }

        public Builder validatePatternDetails(ValidatePatternDetails validatePatternDetails) {
            this.validatePatternDetails = validatePatternDetails;
            return this;
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public Builder opcRetryToken(String opcRetryToken) {
            this.opcRetryToken = opcRetryToken;
            return this;
        }

        public ValidatePatternRequest buildWithoutInvocationCallback() {
            return new ValidatePatternRequest(this.catalogId, this.patternKey, this.validatePatternDetails, this.opcRequestId, this.opcRetryToken);
        }

        public String toString() {
            return "ValidatePatternRequest.Builder(catalogId=" + this.catalogId + ", patternKey=" + this.patternKey + ", validatePatternDetails=" + this.validatePatternDetails + ", opcRequestId=" + this.opcRequestId + ", opcRetryToken=" + this.opcRetryToken + ")";
        }
    }
}

