/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.dataintegration;

import com.google.common.base.Optional;
import com.oracle.bmc.ClientConfiguration;
import com.oracle.bmc.Region;
import com.oracle.bmc.Service;
import com.oracle.bmc.Services;
import com.oracle.bmc.auth.AbstractAuthenticationDetailsProvider;
import com.oracle.bmc.auth.BasicAuthenticationDetailsProvider;
import com.oracle.bmc.auth.ProvidesClientConfigurators;
import com.oracle.bmc.auth.RefreshableOnNotAuthenticatedProvider;
import com.oracle.bmc.auth.RegionProvider;
import com.oracle.bmc.common.RegionalClientBuilder;
import com.oracle.bmc.dataintegration.DataIntegrationAsync;
import com.oracle.bmc.dataintegration.internal.http.ChangeCompartmentConverter;
import com.oracle.bmc.dataintegration.internal.http.CreateApplicationConverter;
import com.oracle.bmc.dataintegration.internal.http.CreateConnectionConverter;
import com.oracle.bmc.dataintegration.internal.http.CreateConnectionValidationConverter;
import com.oracle.bmc.dataintegration.internal.http.CreateDataAssetConverter;
import com.oracle.bmc.dataintegration.internal.http.CreateDataFlowConverter;
import com.oracle.bmc.dataintegration.internal.http.CreateDataFlowValidationConverter;
import com.oracle.bmc.dataintegration.internal.http.CreateEntityShapeConverter;
import com.oracle.bmc.dataintegration.internal.http.CreateExternalPublicationConverter;
import com.oracle.bmc.dataintegration.internal.http.CreateExternalPublicationValidationConverter;
import com.oracle.bmc.dataintegration.internal.http.CreateFolderConverter;
import com.oracle.bmc.dataintegration.internal.http.CreatePatchConverter;
import com.oracle.bmc.dataintegration.internal.http.CreatePipelineConverter;
import com.oracle.bmc.dataintegration.internal.http.CreatePipelineValidationConverter;
import com.oracle.bmc.dataintegration.internal.http.CreateProjectConverter;
import com.oracle.bmc.dataintegration.internal.http.CreateTaskConverter;
import com.oracle.bmc.dataintegration.internal.http.CreateTaskRunConverter;
import com.oracle.bmc.dataintegration.internal.http.CreateTaskValidationConverter;
import com.oracle.bmc.dataintegration.internal.http.CreateWorkspaceConverter;
import com.oracle.bmc.dataintegration.internal.http.DeleteApplicationConverter;
import com.oracle.bmc.dataintegration.internal.http.DeleteConnectionConverter;
import com.oracle.bmc.dataintegration.internal.http.DeleteConnectionValidationConverter;
import com.oracle.bmc.dataintegration.internal.http.DeleteDataAssetConverter;
import com.oracle.bmc.dataintegration.internal.http.DeleteDataFlowConverter;
import com.oracle.bmc.dataintegration.internal.http.DeleteDataFlowValidationConverter;
import com.oracle.bmc.dataintegration.internal.http.DeleteExternalPublicationConverter;
import com.oracle.bmc.dataintegration.internal.http.DeleteExternalPublicationValidationConverter;
import com.oracle.bmc.dataintegration.internal.http.DeleteFolderConverter;
import com.oracle.bmc.dataintegration.internal.http.DeletePatchConverter;
import com.oracle.bmc.dataintegration.internal.http.DeletePipelineConverter;
import com.oracle.bmc.dataintegration.internal.http.DeletePipelineValidationConverter;
import com.oracle.bmc.dataintegration.internal.http.DeleteProjectConverter;
import com.oracle.bmc.dataintegration.internal.http.DeleteTaskConverter;
import com.oracle.bmc.dataintegration.internal.http.DeleteTaskRunConverter;
import com.oracle.bmc.dataintegration.internal.http.DeleteTaskValidationConverter;
import com.oracle.bmc.dataintegration.internal.http.DeleteWorkspaceConverter;
import com.oracle.bmc.dataintegration.internal.http.GetApplicationConverter;
import com.oracle.bmc.dataintegration.internal.http.GetConnectionConverter;
import com.oracle.bmc.dataintegration.internal.http.GetConnectionValidationConverter;
import com.oracle.bmc.dataintegration.internal.http.GetCountStatisticConverter;
import com.oracle.bmc.dataintegration.internal.http.GetDataAssetConverter;
import com.oracle.bmc.dataintegration.internal.http.GetDataEntityConverter;
import com.oracle.bmc.dataintegration.internal.http.GetDataFlowConverter;
import com.oracle.bmc.dataintegration.internal.http.GetDataFlowValidationConverter;
import com.oracle.bmc.dataintegration.internal.http.GetDependentObjectConverter;
import com.oracle.bmc.dataintegration.internal.http.GetExternalPublicationConverter;
import com.oracle.bmc.dataintegration.internal.http.GetExternalPublicationValidationConverter;
import com.oracle.bmc.dataintegration.internal.http.GetFolderConverter;
import com.oracle.bmc.dataintegration.internal.http.GetPatchConverter;
import com.oracle.bmc.dataintegration.internal.http.GetPipelineConverter;
import com.oracle.bmc.dataintegration.internal.http.GetPipelineValidationConverter;
import com.oracle.bmc.dataintegration.internal.http.GetProjectConverter;
import com.oracle.bmc.dataintegration.internal.http.GetPublishedObjectConverter;
import com.oracle.bmc.dataintegration.internal.http.GetReferenceConverter;
import com.oracle.bmc.dataintegration.internal.http.GetSchemaConverter;
import com.oracle.bmc.dataintegration.internal.http.GetTaskConverter;
import com.oracle.bmc.dataintegration.internal.http.GetTaskRunConverter;
import com.oracle.bmc.dataintegration.internal.http.GetTaskValidationConverter;
import com.oracle.bmc.dataintegration.internal.http.GetWorkRequestConverter;
import com.oracle.bmc.dataintegration.internal.http.GetWorkspaceConverter;
import com.oracle.bmc.dataintegration.internal.http.ListApplicationsConverter;
import com.oracle.bmc.dataintegration.internal.http.ListConnectionValidationsConverter;
import com.oracle.bmc.dataintegration.internal.http.ListConnectionsConverter;
import com.oracle.bmc.dataintegration.internal.http.ListDataAssetsConverter;
import com.oracle.bmc.dataintegration.internal.http.ListDataEntitiesConverter;
import com.oracle.bmc.dataintegration.internal.http.ListDataFlowValidationsConverter;
import com.oracle.bmc.dataintegration.internal.http.ListDataFlowsConverter;
import com.oracle.bmc.dataintegration.internal.http.ListDependentObjectsConverter;
import com.oracle.bmc.dataintegration.internal.http.ListExternalPublicationValidationsConverter;
import com.oracle.bmc.dataintegration.internal.http.ListExternalPublicationsConverter;
import com.oracle.bmc.dataintegration.internal.http.ListFoldersConverter;
import com.oracle.bmc.dataintegration.internal.http.ListPatchChangesConverter;
import com.oracle.bmc.dataintegration.internal.http.ListPatchesConverter;
import com.oracle.bmc.dataintegration.internal.http.ListPipelineValidationsConverter;
import com.oracle.bmc.dataintegration.internal.http.ListPipelinesConverter;
import com.oracle.bmc.dataintegration.internal.http.ListProjectsConverter;
import com.oracle.bmc.dataintegration.internal.http.ListPublishedObjectsConverter;
import com.oracle.bmc.dataintegration.internal.http.ListReferencesConverter;
import com.oracle.bmc.dataintegration.internal.http.ListSchemasConverter;
import com.oracle.bmc.dataintegration.internal.http.ListTaskRunLogsConverter;
import com.oracle.bmc.dataintegration.internal.http.ListTaskRunsConverter;
import com.oracle.bmc.dataintegration.internal.http.ListTaskValidationsConverter;
import com.oracle.bmc.dataintegration.internal.http.ListTasksConverter;
import com.oracle.bmc.dataintegration.internal.http.ListWorkRequestErrorsConverter;
import com.oracle.bmc.dataintegration.internal.http.ListWorkRequestLogsConverter;
import com.oracle.bmc.dataintegration.internal.http.ListWorkRequestsConverter;
import com.oracle.bmc.dataintegration.internal.http.ListWorkspacesConverter;
import com.oracle.bmc.dataintegration.internal.http.StartWorkspaceConverter;
import com.oracle.bmc.dataintegration.internal.http.StopWorkspaceConverter;
import com.oracle.bmc.dataintegration.internal.http.UpdateApplicationConverter;
import com.oracle.bmc.dataintegration.internal.http.UpdateConnectionConverter;
import com.oracle.bmc.dataintegration.internal.http.UpdateDataAssetConverter;
import com.oracle.bmc.dataintegration.internal.http.UpdateDataFlowConverter;
import com.oracle.bmc.dataintegration.internal.http.UpdateExternalPublicationConverter;
import com.oracle.bmc.dataintegration.internal.http.UpdateFolderConverter;
import com.oracle.bmc.dataintegration.internal.http.UpdatePipelineConverter;
import com.oracle.bmc.dataintegration.internal.http.UpdateProjectConverter;
import com.oracle.bmc.dataintegration.internal.http.UpdateReferenceConverter;
import com.oracle.bmc.dataintegration.internal.http.UpdateTaskConverter;
import com.oracle.bmc.dataintegration.internal.http.UpdateTaskRunConverter;
import com.oracle.bmc.dataintegration.internal.http.UpdateWorkspaceConverter;
import com.oracle.bmc.dataintegration.requests.ChangeCompartmentRequest;
import com.oracle.bmc.dataintegration.requests.CreateApplicationRequest;
import com.oracle.bmc.dataintegration.requests.CreateConnectionRequest;
import com.oracle.bmc.dataintegration.requests.CreateConnectionValidationRequest;
import com.oracle.bmc.dataintegration.requests.CreateDataAssetRequest;
import com.oracle.bmc.dataintegration.requests.CreateDataFlowRequest;
import com.oracle.bmc.dataintegration.requests.CreateDataFlowValidationRequest;
import com.oracle.bmc.dataintegration.requests.CreateEntityShapeRequest;
import com.oracle.bmc.dataintegration.requests.CreateExternalPublicationRequest;
import com.oracle.bmc.dataintegration.requests.CreateExternalPublicationValidationRequest;
import com.oracle.bmc.dataintegration.requests.CreateFolderRequest;
import com.oracle.bmc.dataintegration.requests.CreatePatchRequest;
import com.oracle.bmc.dataintegration.requests.CreatePipelineRequest;
import com.oracle.bmc.dataintegration.requests.CreatePipelineValidationRequest;
import com.oracle.bmc.dataintegration.requests.CreateProjectRequest;
import com.oracle.bmc.dataintegration.requests.CreateTaskRequest;
import com.oracle.bmc.dataintegration.requests.CreateTaskRunRequest;
import com.oracle.bmc.dataintegration.requests.CreateTaskValidationRequest;
import com.oracle.bmc.dataintegration.requests.CreateWorkspaceRequest;
import com.oracle.bmc.dataintegration.requests.DeleteApplicationRequest;
import com.oracle.bmc.dataintegration.requests.DeleteConnectionRequest;
import com.oracle.bmc.dataintegration.requests.DeleteConnectionValidationRequest;
import com.oracle.bmc.dataintegration.requests.DeleteDataAssetRequest;
import com.oracle.bmc.dataintegration.requests.DeleteDataFlowRequest;
import com.oracle.bmc.dataintegration.requests.DeleteDataFlowValidationRequest;
import com.oracle.bmc.dataintegration.requests.DeleteExternalPublicationRequest;
import com.oracle.bmc.dataintegration.requests.DeleteExternalPublicationValidationRequest;
import com.oracle.bmc.dataintegration.requests.DeleteFolderRequest;
import com.oracle.bmc.dataintegration.requests.DeletePatchRequest;
import com.oracle.bmc.dataintegration.requests.DeletePipelineRequest;
import com.oracle.bmc.dataintegration.requests.DeletePipelineValidationRequest;
import com.oracle.bmc.dataintegration.requests.DeleteProjectRequest;
import com.oracle.bmc.dataintegration.requests.DeleteTaskRequest;
import com.oracle.bmc.dataintegration.requests.DeleteTaskRunRequest;
import com.oracle.bmc.dataintegration.requests.DeleteTaskValidationRequest;
import com.oracle.bmc.dataintegration.requests.DeleteWorkspaceRequest;
import com.oracle.bmc.dataintegration.requests.GetApplicationRequest;
import com.oracle.bmc.dataintegration.requests.GetConnectionRequest;
import com.oracle.bmc.dataintegration.requests.GetConnectionValidationRequest;
import com.oracle.bmc.dataintegration.requests.GetCountStatisticRequest;
import com.oracle.bmc.dataintegration.requests.GetDataAssetRequest;
import com.oracle.bmc.dataintegration.requests.GetDataEntityRequest;
import com.oracle.bmc.dataintegration.requests.GetDataFlowRequest;
import com.oracle.bmc.dataintegration.requests.GetDataFlowValidationRequest;
import com.oracle.bmc.dataintegration.requests.GetDependentObjectRequest;
import com.oracle.bmc.dataintegration.requests.GetExternalPublicationRequest;
import com.oracle.bmc.dataintegration.requests.GetExternalPublicationValidationRequest;
import com.oracle.bmc.dataintegration.requests.GetFolderRequest;
import com.oracle.bmc.dataintegration.requests.GetPatchRequest;
import com.oracle.bmc.dataintegration.requests.GetPipelineRequest;
import com.oracle.bmc.dataintegration.requests.GetPipelineValidationRequest;
import com.oracle.bmc.dataintegration.requests.GetProjectRequest;
import com.oracle.bmc.dataintegration.requests.GetPublishedObjectRequest;
import com.oracle.bmc.dataintegration.requests.GetReferenceRequest;
import com.oracle.bmc.dataintegration.requests.GetSchemaRequest;
import com.oracle.bmc.dataintegration.requests.GetTaskRequest;
import com.oracle.bmc.dataintegration.requests.GetTaskRunRequest;
import com.oracle.bmc.dataintegration.requests.GetTaskValidationRequest;
import com.oracle.bmc.dataintegration.requests.GetWorkRequestRequest;
import com.oracle.bmc.dataintegration.requests.GetWorkspaceRequest;
import com.oracle.bmc.dataintegration.requests.ListApplicationsRequest;
import com.oracle.bmc.dataintegration.requests.ListConnectionValidationsRequest;
import com.oracle.bmc.dataintegration.requests.ListConnectionsRequest;
import com.oracle.bmc.dataintegration.requests.ListDataAssetsRequest;
import com.oracle.bmc.dataintegration.requests.ListDataEntitiesRequest;
import com.oracle.bmc.dataintegration.requests.ListDataFlowValidationsRequest;
import com.oracle.bmc.dataintegration.requests.ListDataFlowsRequest;
import com.oracle.bmc.dataintegration.requests.ListDependentObjectsRequest;
import com.oracle.bmc.dataintegration.requests.ListExternalPublicationValidationsRequest;
import com.oracle.bmc.dataintegration.requests.ListExternalPublicationsRequest;
import com.oracle.bmc.dataintegration.requests.ListFoldersRequest;
import com.oracle.bmc.dataintegration.requests.ListPatchChangesRequest;
import com.oracle.bmc.dataintegration.requests.ListPatchesRequest;
import com.oracle.bmc.dataintegration.requests.ListPipelineValidationsRequest;
import com.oracle.bmc.dataintegration.requests.ListPipelinesRequest;
import com.oracle.bmc.dataintegration.requests.ListProjectsRequest;
import com.oracle.bmc.dataintegration.requests.ListPublishedObjectsRequest;
import com.oracle.bmc.dataintegration.requests.ListReferencesRequest;
import com.oracle.bmc.dataintegration.requests.ListSchemasRequest;
import com.oracle.bmc.dataintegration.requests.ListTaskRunLogsRequest;
import com.oracle.bmc.dataintegration.requests.ListTaskRunsRequest;
import com.oracle.bmc.dataintegration.requests.ListTaskValidationsRequest;
import com.oracle.bmc.dataintegration.requests.ListTasksRequest;
import com.oracle.bmc.dataintegration.requests.ListWorkRequestErrorsRequest;
import com.oracle.bmc.dataintegration.requests.ListWorkRequestLogsRequest;
import com.oracle.bmc.dataintegration.requests.ListWorkRequestsRequest;
import com.oracle.bmc.dataintegration.requests.ListWorkspacesRequest;
import com.oracle.bmc.dataintegration.requests.StartWorkspaceRequest;
import com.oracle.bmc.dataintegration.requests.StopWorkspaceRequest;
import com.oracle.bmc.dataintegration.requests.UpdateApplicationRequest;
import com.oracle.bmc.dataintegration.requests.UpdateConnectionRequest;
import com.oracle.bmc.dataintegration.requests.UpdateDataAssetRequest;
import com.oracle.bmc.dataintegration.requests.UpdateDataFlowRequest;
import com.oracle.bmc.dataintegration.requests.UpdateExternalPublicationRequest;
import com.oracle.bmc.dataintegration.requests.UpdateFolderRequest;
import com.oracle.bmc.dataintegration.requests.UpdatePipelineRequest;
import com.oracle.bmc.dataintegration.requests.UpdateProjectRequest;
import com.oracle.bmc.dataintegration.requests.UpdateReferenceRequest;
import com.oracle.bmc.dataintegration.requests.UpdateTaskRequest;
import com.oracle.bmc.dataintegration.requests.UpdateTaskRunRequest;
import com.oracle.bmc.dataintegration.requests.UpdateWorkspaceRequest;
import com.oracle.bmc.dataintegration.responses.ChangeCompartmentResponse;
import com.oracle.bmc.dataintegration.responses.CreateApplicationResponse;
import com.oracle.bmc.dataintegration.responses.CreateConnectionResponse;
import com.oracle.bmc.dataintegration.responses.CreateConnectionValidationResponse;
import com.oracle.bmc.dataintegration.responses.CreateDataAssetResponse;
import com.oracle.bmc.dataintegration.responses.CreateDataFlowResponse;
import com.oracle.bmc.dataintegration.responses.CreateDataFlowValidationResponse;
import com.oracle.bmc.dataintegration.responses.CreateEntityShapeResponse;
import com.oracle.bmc.dataintegration.responses.CreateExternalPublicationResponse;
import com.oracle.bmc.dataintegration.responses.CreateExternalPublicationValidationResponse;
import com.oracle.bmc.dataintegration.responses.CreateFolderResponse;
import com.oracle.bmc.dataintegration.responses.CreatePatchResponse;
import com.oracle.bmc.dataintegration.responses.CreatePipelineResponse;
import com.oracle.bmc.dataintegration.responses.CreatePipelineValidationResponse;
import com.oracle.bmc.dataintegration.responses.CreateProjectResponse;
import com.oracle.bmc.dataintegration.responses.CreateTaskResponse;
import com.oracle.bmc.dataintegration.responses.CreateTaskRunResponse;
import com.oracle.bmc.dataintegration.responses.CreateTaskValidationResponse;
import com.oracle.bmc.dataintegration.responses.CreateWorkspaceResponse;
import com.oracle.bmc.dataintegration.responses.DeleteApplicationResponse;
import com.oracle.bmc.dataintegration.responses.DeleteConnectionResponse;
import com.oracle.bmc.dataintegration.responses.DeleteConnectionValidationResponse;
import com.oracle.bmc.dataintegration.responses.DeleteDataAssetResponse;
import com.oracle.bmc.dataintegration.responses.DeleteDataFlowResponse;
import com.oracle.bmc.dataintegration.responses.DeleteDataFlowValidationResponse;
import com.oracle.bmc.dataintegration.responses.DeleteExternalPublicationResponse;
import com.oracle.bmc.dataintegration.responses.DeleteExternalPublicationValidationResponse;
import com.oracle.bmc.dataintegration.responses.DeleteFolderResponse;
import com.oracle.bmc.dataintegration.responses.DeletePatchResponse;
import com.oracle.bmc.dataintegration.responses.DeletePipelineResponse;
import com.oracle.bmc.dataintegration.responses.DeletePipelineValidationResponse;
import com.oracle.bmc.dataintegration.responses.DeleteProjectResponse;
import com.oracle.bmc.dataintegration.responses.DeleteTaskResponse;
import com.oracle.bmc.dataintegration.responses.DeleteTaskRunResponse;
import com.oracle.bmc.dataintegration.responses.DeleteTaskValidationResponse;
import com.oracle.bmc.dataintegration.responses.DeleteWorkspaceResponse;
import com.oracle.bmc.dataintegration.responses.GetApplicationResponse;
import com.oracle.bmc.dataintegration.responses.GetConnectionResponse;
import com.oracle.bmc.dataintegration.responses.GetConnectionValidationResponse;
import com.oracle.bmc.dataintegration.responses.GetCountStatisticResponse;
import com.oracle.bmc.dataintegration.responses.GetDataAssetResponse;
import com.oracle.bmc.dataintegration.responses.GetDataEntityResponse;
import com.oracle.bmc.dataintegration.responses.GetDataFlowResponse;
import com.oracle.bmc.dataintegration.responses.GetDataFlowValidationResponse;
import com.oracle.bmc.dataintegration.responses.GetDependentObjectResponse;
import com.oracle.bmc.dataintegration.responses.GetExternalPublicationResponse;
import com.oracle.bmc.dataintegration.responses.GetExternalPublicationValidationResponse;
import com.oracle.bmc.dataintegration.responses.GetFolderResponse;
import com.oracle.bmc.dataintegration.responses.GetPatchResponse;
import com.oracle.bmc.dataintegration.responses.GetPipelineResponse;
import com.oracle.bmc.dataintegration.responses.GetPipelineValidationResponse;
import com.oracle.bmc.dataintegration.responses.GetProjectResponse;
import com.oracle.bmc.dataintegration.responses.GetPublishedObjectResponse;
import com.oracle.bmc.dataintegration.responses.GetReferenceResponse;
import com.oracle.bmc.dataintegration.responses.GetSchemaResponse;
import com.oracle.bmc.dataintegration.responses.GetTaskResponse;
import com.oracle.bmc.dataintegration.responses.GetTaskRunResponse;
import com.oracle.bmc.dataintegration.responses.GetTaskValidationResponse;
import com.oracle.bmc.dataintegration.responses.GetWorkRequestResponse;
import com.oracle.bmc.dataintegration.responses.GetWorkspaceResponse;
import com.oracle.bmc.dataintegration.responses.ListApplicationsResponse;
import com.oracle.bmc.dataintegration.responses.ListConnectionValidationsResponse;
import com.oracle.bmc.dataintegration.responses.ListConnectionsResponse;
import com.oracle.bmc.dataintegration.responses.ListDataAssetsResponse;
import com.oracle.bmc.dataintegration.responses.ListDataEntitiesResponse;
import com.oracle.bmc.dataintegration.responses.ListDataFlowValidationsResponse;
import com.oracle.bmc.dataintegration.responses.ListDataFlowsResponse;
import com.oracle.bmc.dataintegration.responses.ListDependentObjectsResponse;
import com.oracle.bmc.dataintegration.responses.ListExternalPublicationValidationsResponse;
import com.oracle.bmc.dataintegration.responses.ListExternalPublicationsResponse;
import com.oracle.bmc.dataintegration.responses.ListFoldersResponse;
import com.oracle.bmc.dataintegration.responses.ListPatchChangesResponse;
import com.oracle.bmc.dataintegration.responses.ListPatchesResponse;
import com.oracle.bmc.dataintegration.responses.ListPipelineValidationsResponse;
import com.oracle.bmc.dataintegration.responses.ListPipelinesResponse;
import com.oracle.bmc.dataintegration.responses.ListProjectsResponse;
import com.oracle.bmc.dataintegration.responses.ListPublishedObjectsResponse;
import com.oracle.bmc.dataintegration.responses.ListReferencesResponse;
import com.oracle.bmc.dataintegration.responses.ListSchemasResponse;
import com.oracle.bmc.dataintegration.responses.ListTaskRunLogsResponse;
import com.oracle.bmc.dataintegration.responses.ListTaskRunsResponse;
import com.oracle.bmc.dataintegration.responses.ListTaskValidationsResponse;
import com.oracle.bmc.dataintegration.responses.ListTasksResponse;
import com.oracle.bmc.dataintegration.responses.ListWorkRequestErrorsResponse;
import com.oracle.bmc.dataintegration.responses.ListWorkRequestLogsResponse;
import com.oracle.bmc.dataintegration.responses.ListWorkRequestsResponse;
import com.oracle.bmc.dataintegration.responses.ListWorkspacesResponse;
import com.oracle.bmc.dataintegration.responses.StartWorkspaceResponse;
import com.oracle.bmc.dataintegration.responses.StopWorkspaceResponse;
import com.oracle.bmc.dataintegration.responses.UpdateApplicationResponse;
import com.oracle.bmc.dataintegration.responses.UpdateConnectionResponse;
import com.oracle.bmc.dataintegration.responses.UpdateDataAssetResponse;
import com.oracle.bmc.dataintegration.responses.UpdateDataFlowResponse;
import com.oracle.bmc.dataintegration.responses.UpdateExternalPublicationResponse;
import com.oracle.bmc.dataintegration.responses.UpdateFolderResponse;
import com.oracle.bmc.dataintegration.responses.UpdatePipelineResponse;
import com.oracle.bmc.dataintegration.responses.UpdateProjectResponse;
import com.oracle.bmc.dataintegration.responses.UpdateReferenceResponse;
import com.oracle.bmc.dataintegration.responses.UpdateTaskResponse;
import com.oracle.bmc.dataintegration.responses.UpdateTaskRunResponse;
import com.oracle.bmc.dataintegration.responses.UpdateWorkspaceResponse;
import com.oracle.bmc.http.ClientConfigurator;
import com.oracle.bmc.http.internal.RestClient;
import com.oracle.bmc.http.internal.RestClientFactory;
import com.oracle.bmc.http.internal.RestClientFactoryBuilder;
import com.oracle.bmc.http.internal.RetryTokenUtils;
import com.oracle.bmc.http.internal.WrappedInvocationBuilder;
import com.oracle.bmc.http.signing.RequestSigner;
import com.oracle.bmc.http.signing.RequestSignerFactory;
import com.oracle.bmc.http.signing.SigningStrategy;
import com.oracle.bmc.http.signing.internal.DefaultRequestSignerFactory;
import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.responses.AsyncHandler;
import com.oracle.bmc.util.internal.RefreshAuthTokenWrapper;
import java.net.URI;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.Future;
import java.util.function.Function;
import javax.ws.rs.core.Response;
import lombok.NonNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DataIntegrationAsyncClient
implements DataIntegrationAsync {
    private static final Logger LOG = LoggerFactory.getLogger(DataIntegrationAsyncClient.class);
    public static final Service SERVICE = Services.serviceBuilder().serviceName("DATAINTEGRATION").serviceEndpointPrefix("").serviceEndpointTemplate("https://dataintegration.{region}.oci.{secondLevelDomain}").build();
    private final RestClient client;
    private final AbstractAuthenticationDetailsProvider authenticationDetailsProvider;

    public DataIntegrationAsyncClient(BasicAuthenticationDetailsProvider authenticationDetailsProvider) {
        this(authenticationDetailsProvider, null);
    }

    public DataIntegrationAsyncClient(BasicAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration) {
        this(authenticationDetailsProvider, configuration, null);
    }

    public DataIntegrationAsyncClient(BasicAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator) {
        this((AbstractAuthenticationDetailsProvider)authenticationDetailsProvider, configuration, clientConfigurator, (RequestSignerFactory)new DefaultRequestSignerFactory(SigningStrategy.STANDARD));
    }

    public DataIntegrationAsyncClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory) {
        this(authenticationDetailsProvider, configuration, clientConfigurator, defaultRequestSignerFactory, new ArrayList<ClientConfigurator>());
    }

    public DataIntegrationAsyncClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory, List<ClientConfigurator> additionalClientConfigurators) {
        this(authenticationDetailsProvider, configuration, clientConfigurator, defaultRequestSignerFactory, additionalClientConfigurators, null);
    }

    public DataIntegrationAsyncClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory, List<ClientConfigurator> additionalClientConfigurators, String endpoint) {
        this(authenticationDetailsProvider, configuration, clientConfigurator, defaultRequestSignerFactory, DefaultRequestSignerFactory.createDefaultRequestSignerFactories(), additionalClientConfigurators, endpoint);
    }

    public DataIntegrationAsyncClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory, Map<SigningStrategy, RequestSignerFactory> signingStrategyRequestSignerFactories, List<ClientConfigurator> additionalClientConfigurators, String endpoint) {
        this(authenticationDetailsProvider, configuration, clientConfigurator, defaultRequestSignerFactory, signingStrategyRequestSignerFactories, additionalClientConfigurators, endpoint, RestClientFactoryBuilder.builder());
    }

    public DataIntegrationAsyncClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory, Map<SigningStrategy, RequestSignerFactory> signingStrategyRequestSignerFactories, List<ClientConfigurator> additionalClientConfigurators, String endpoint, RestClientFactoryBuilder restClientFactoryBuilder) {
        RegionProvider provider;
        this.authenticationDetailsProvider = authenticationDetailsProvider;
        ArrayList authenticationDetailsConfigurators = new ArrayList();
        if (this.authenticationDetailsProvider instanceof ProvidesClientConfigurators) {
            authenticationDetailsConfigurators.addAll(((ProvidesClientConfigurators)this.authenticationDetailsProvider).getClientConfigurators());
        }
        ArrayList<ClientConfigurator> allConfigurators = new ArrayList<ClientConfigurator>(additionalClientConfigurators);
        allConfigurators.addAll(authenticationDetailsConfigurators);
        RestClientFactory restClientFactory = restClientFactoryBuilder.clientConfigurator(clientConfigurator).additionalClientConfigurators(allConfigurators).build();
        RequestSigner defaultRequestSigner = defaultRequestSignerFactory.createRequestSigner(SERVICE, this.authenticationDetailsProvider);
        HashMap<SigningStrategy, RequestSigner> requestSigners = new HashMap<SigningStrategy, RequestSigner>();
        if (this.authenticationDetailsProvider instanceof BasicAuthenticationDetailsProvider) {
            for (SigningStrategy s : SigningStrategy.values()) {
                requestSigners.put(s, signingStrategyRequestSignerFactories.get(s).createRequestSigner(SERVICE, authenticationDetailsProvider));
            }
        }
        this.client = restClientFactory.create(defaultRequestSigner, requestSigners, configuration);
        if (this.authenticationDetailsProvider instanceof RegionProvider && (provider = (RegionProvider)this.authenticationDetailsProvider).getRegion() != null) {
            this.setRegion(provider.getRegion());
            if (endpoint != null) {
                LOG.info("Authentication details provider configured for region '{}', but endpoint specifically set to '{}'. Using endpoint setting instead of region.", (Object)provider.getRegion(), (Object)endpoint);
            }
        }
        if (endpoint != null) {
            this.setEndpoint(endpoint);
        }
    }

    public static Builder builder() {
        return new Builder(SERVICE);
    }

    @Override
    public void setEndpoint(String endpoint) {
        LOG.info("Setting endpoint to {}", (Object)endpoint);
        this.client.setEndpoint(endpoint);
    }

    @Override
    public String getEndpoint() {
        String endpoint = null;
        URI uri = this.client.getBaseTarget().getUri();
        if (uri != null) {
            endpoint = uri.toString();
        }
        return endpoint;
    }

    @Override
    public void setRegion(Region region) {
        Optional endpoint = region.getEndpoint(SERVICE);
        if (!endpoint.isPresent()) {
            throw new IllegalArgumentException("Endpoint for " + SERVICE + " is not known in region " + region);
        }
        this.setEndpoint((String)endpoint.get());
    }

    @Override
    public void setRegion(String regionId) {
        regionId = regionId.toLowerCase(Locale.ENGLISH);
        try {
            Region region = Region.fromRegionId((String)regionId);
            this.setRegion(region);
        }
        catch (IllegalArgumentException e) {
            LOG.info("Unknown regionId '{}', falling back to default endpoint format", (Object)regionId);
            String endpoint = Region.formatDefaultRegionEndpoint((Service)SERVICE, (String)regionId);
            this.setEndpoint(endpoint);
        }
    }

    @Override
    public void close() {
        this.client.close();
    }

    @Override
    public Future<ChangeCompartmentResponse> changeCompartment(ChangeCompartmentRequest request, AsyncHandler<ChangeCompartmentRequest, ChangeCompartmentResponse> handler) {
        LOG.trace("Called async changeCompartment");
        ChangeCompartmentRequest interceptedRequest = ChangeCompartmentConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = ChangeCompartmentConverter.fromRequest(this.client, interceptedRequest);
        com.google.common.base.Function<Response, ChangeCompartmentResponse> transformer = ChangeCompartmentConverter.fromResponse();
        RetryTokenUtils.addRetryToken((WrappedInvocationBuilder)ib);
        AsyncHandler<ChangeCompartmentRequest, ChangeCompartmentResponse> handlerToUse = handler;
        Function futureSupplier = this.client.postFutureSupplier((BmcRequest)interceptedRequest, ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<ChangeCompartmentRequest, ChangeCompartmentResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<CreateApplicationResponse> createApplication(CreateApplicationRequest request, AsyncHandler<CreateApplicationRequest, CreateApplicationResponse> handler) {
        LOG.trace("Called async createApplication");
        CreateApplicationRequest interceptedRequest = CreateApplicationConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = CreateApplicationConverter.fromRequest(this.client, interceptedRequest);
        com.google.common.base.Function<Response, CreateApplicationResponse> transformer = CreateApplicationConverter.fromResponse();
        RetryTokenUtils.addRetryToken((WrappedInvocationBuilder)ib);
        AsyncHandler<CreateApplicationRequest, CreateApplicationResponse> handlerToUse = handler;
        Function futureSupplier = this.client.postFutureSupplier((BmcRequest)interceptedRequest, ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<CreateApplicationRequest, CreateApplicationResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<CreateConnectionResponse> createConnection(CreateConnectionRequest request, AsyncHandler<CreateConnectionRequest, CreateConnectionResponse> handler) {
        LOG.trace("Called async createConnection");
        CreateConnectionRequest interceptedRequest = CreateConnectionConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = CreateConnectionConverter.fromRequest(this.client, interceptedRequest);
        com.google.common.base.Function<Response, CreateConnectionResponse> transformer = CreateConnectionConverter.fromResponse();
        RetryTokenUtils.addRetryToken((WrappedInvocationBuilder)ib);
        AsyncHandler<CreateConnectionRequest, CreateConnectionResponse> handlerToUse = handler;
        Function futureSupplier = this.client.postFutureSupplier((BmcRequest)interceptedRequest, ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<CreateConnectionRequest, CreateConnectionResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<CreateConnectionValidationResponse> createConnectionValidation(CreateConnectionValidationRequest request, AsyncHandler<CreateConnectionValidationRequest, CreateConnectionValidationResponse> handler) {
        LOG.trace("Called async createConnectionValidation");
        CreateConnectionValidationRequest interceptedRequest = CreateConnectionValidationConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = CreateConnectionValidationConverter.fromRequest(this.client, interceptedRequest);
        com.google.common.base.Function<Response, CreateConnectionValidationResponse> transformer = CreateConnectionValidationConverter.fromResponse();
        RetryTokenUtils.addRetryToken((WrappedInvocationBuilder)ib);
        AsyncHandler<CreateConnectionValidationRequest, CreateConnectionValidationResponse> handlerToUse = handler;
        Function futureSupplier = this.client.postFutureSupplier((BmcRequest)interceptedRequest, ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<CreateConnectionValidationRequest, CreateConnectionValidationResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<CreateDataAssetResponse> createDataAsset(CreateDataAssetRequest request, AsyncHandler<CreateDataAssetRequest, CreateDataAssetResponse> handler) {
        LOG.trace("Called async createDataAsset");
        CreateDataAssetRequest interceptedRequest = CreateDataAssetConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = CreateDataAssetConverter.fromRequest(this.client, interceptedRequest);
        com.google.common.base.Function<Response, CreateDataAssetResponse> transformer = CreateDataAssetConverter.fromResponse();
        RetryTokenUtils.addRetryToken((WrappedInvocationBuilder)ib);
        AsyncHandler<CreateDataAssetRequest, CreateDataAssetResponse> handlerToUse = handler;
        Function futureSupplier = this.client.postFutureSupplier((BmcRequest)interceptedRequest, ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<CreateDataAssetRequest, CreateDataAssetResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<CreateDataFlowResponse> createDataFlow(CreateDataFlowRequest request, AsyncHandler<CreateDataFlowRequest, CreateDataFlowResponse> handler) {
        LOG.trace("Called async createDataFlow");
        CreateDataFlowRequest interceptedRequest = CreateDataFlowConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = CreateDataFlowConverter.fromRequest(this.client, interceptedRequest);
        com.google.common.base.Function<Response, CreateDataFlowResponse> transformer = CreateDataFlowConverter.fromResponse();
        RetryTokenUtils.addRetryToken((WrappedInvocationBuilder)ib);
        AsyncHandler<CreateDataFlowRequest, CreateDataFlowResponse> handlerToUse = handler;
        Function futureSupplier = this.client.postFutureSupplier((BmcRequest)interceptedRequest, ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<CreateDataFlowRequest, CreateDataFlowResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<CreateDataFlowValidationResponse> createDataFlowValidation(CreateDataFlowValidationRequest request, AsyncHandler<CreateDataFlowValidationRequest, CreateDataFlowValidationResponse> handler) {
        LOG.trace("Called async createDataFlowValidation");
        CreateDataFlowValidationRequest interceptedRequest = CreateDataFlowValidationConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = CreateDataFlowValidationConverter.fromRequest(this.client, interceptedRequest);
        com.google.common.base.Function<Response, CreateDataFlowValidationResponse> transformer = CreateDataFlowValidationConverter.fromResponse();
        RetryTokenUtils.addRetryToken((WrappedInvocationBuilder)ib);
        AsyncHandler<CreateDataFlowValidationRequest, CreateDataFlowValidationResponse> handlerToUse = handler;
        Function futureSupplier = this.client.postFutureSupplier((BmcRequest)interceptedRequest, ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<CreateDataFlowValidationRequest, CreateDataFlowValidationResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<CreateEntityShapeResponse> createEntityShape(CreateEntityShapeRequest request, AsyncHandler<CreateEntityShapeRequest, CreateEntityShapeResponse> handler) {
        LOG.trace("Called async createEntityShape");
        CreateEntityShapeRequest interceptedRequest = CreateEntityShapeConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = CreateEntityShapeConverter.fromRequest(this.client, interceptedRequest);
        com.google.common.base.Function<Response, CreateEntityShapeResponse> transformer = CreateEntityShapeConverter.fromResponse();
        RetryTokenUtils.addRetryToken((WrappedInvocationBuilder)ib);
        AsyncHandler<CreateEntityShapeRequest, CreateEntityShapeResponse> handlerToUse = handler;
        Function futureSupplier = this.client.postFutureSupplier((BmcRequest)interceptedRequest, ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<CreateEntityShapeRequest, CreateEntityShapeResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<CreateExternalPublicationResponse> createExternalPublication(CreateExternalPublicationRequest request, AsyncHandler<CreateExternalPublicationRequest, CreateExternalPublicationResponse> handler) {
        LOG.trace("Called async createExternalPublication");
        CreateExternalPublicationRequest interceptedRequest = CreateExternalPublicationConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = CreateExternalPublicationConverter.fromRequest(this.client, interceptedRequest);
        com.google.common.base.Function<Response, CreateExternalPublicationResponse> transformer = CreateExternalPublicationConverter.fromResponse();
        RetryTokenUtils.addRetryToken((WrappedInvocationBuilder)ib);
        AsyncHandler<CreateExternalPublicationRequest, CreateExternalPublicationResponse> handlerToUse = handler;
        Function futureSupplier = this.client.postFutureSupplier((BmcRequest)interceptedRequest, ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<CreateExternalPublicationRequest, CreateExternalPublicationResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<CreateExternalPublicationValidationResponse> createExternalPublicationValidation(CreateExternalPublicationValidationRequest request, AsyncHandler<CreateExternalPublicationValidationRequest, CreateExternalPublicationValidationResponse> handler) {
        LOG.trace("Called async createExternalPublicationValidation");
        CreateExternalPublicationValidationRequest interceptedRequest = CreateExternalPublicationValidationConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = CreateExternalPublicationValidationConverter.fromRequest(this.client, interceptedRequest);
        com.google.common.base.Function<Response, CreateExternalPublicationValidationResponse> transformer = CreateExternalPublicationValidationConverter.fromResponse();
        RetryTokenUtils.addRetryToken((WrappedInvocationBuilder)ib);
        AsyncHandler<CreateExternalPublicationValidationRequest, CreateExternalPublicationValidationResponse> handlerToUse = handler;
        Function futureSupplier = this.client.postFutureSupplier((BmcRequest)interceptedRequest, ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<CreateExternalPublicationValidationRequest, CreateExternalPublicationValidationResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<CreateFolderResponse> createFolder(CreateFolderRequest request, AsyncHandler<CreateFolderRequest, CreateFolderResponse> handler) {
        LOG.trace("Called async createFolder");
        CreateFolderRequest interceptedRequest = CreateFolderConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = CreateFolderConverter.fromRequest(this.client, interceptedRequest);
        com.google.common.base.Function<Response, CreateFolderResponse> transformer = CreateFolderConverter.fromResponse();
        RetryTokenUtils.addRetryToken((WrappedInvocationBuilder)ib);
        AsyncHandler<CreateFolderRequest, CreateFolderResponse> handlerToUse = handler;
        Function futureSupplier = this.client.postFutureSupplier((BmcRequest)interceptedRequest, ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<CreateFolderRequest, CreateFolderResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<CreatePatchResponse> createPatch(CreatePatchRequest request, AsyncHandler<CreatePatchRequest, CreatePatchResponse> handler) {
        LOG.trace("Called async createPatch");
        CreatePatchRequest interceptedRequest = CreatePatchConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = CreatePatchConverter.fromRequest(this.client, interceptedRequest);
        com.google.common.base.Function<Response, CreatePatchResponse> transformer = CreatePatchConverter.fromResponse();
        RetryTokenUtils.addRetryToken((WrappedInvocationBuilder)ib);
        AsyncHandler<CreatePatchRequest, CreatePatchResponse> handlerToUse = handler;
        Function futureSupplier = this.client.postFutureSupplier((BmcRequest)interceptedRequest, ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<CreatePatchRequest, CreatePatchResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<CreatePipelineResponse> createPipeline(CreatePipelineRequest request, AsyncHandler<CreatePipelineRequest, CreatePipelineResponse> handler) {
        LOG.trace("Called async createPipeline");
        CreatePipelineRequest interceptedRequest = CreatePipelineConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = CreatePipelineConverter.fromRequest(this.client, interceptedRequest);
        com.google.common.base.Function<Response, CreatePipelineResponse> transformer = CreatePipelineConverter.fromResponse();
        RetryTokenUtils.addRetryToken((WrappedInvocationBuilder)ib);
        AsyncHandler<CreatePipelineRequest, CreatePipelineResponse> handlerToUse = handler;
        Function futureSupplier = this.client.postFutureSupplier((BmcRequest)interceptedRequest, ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<CreatePipelineRequest, CreatePipelineResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<CreatePipelineValidationResponse> createPipelineValidation(CreatePipelineValidationRequest request, AsyncHandler<CreatePipelineValidationRequest, CreatePipelineValidationResponse> handler) {
        LOG.trace("Called async createPipelineValidation");
        CreatePipelineValidationRequest interceptedRequest = CreatePipelineValidationConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = CreatePipelineValidationConverter.fromRequest(this.client, interceptedRequest);
        com.google.common.base.Function<Response, CreatePipelineValidationResponse> transformer = CreatePipelineValidationConverter.fromResponse();
        RetryTokenUtils.addRetryToken((WrappedInvocationBuilder)ib);
        AsyncHandler<CreatePipelineValidationRequest, CreatePipelineValidationResponse> handlerToUse = handler;
        Function futureSupplier = this.client.postFutureSupplier((BmcRequest)interceptedRequest, ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<CreatePipelineValidationRequest, CreatePipelineValidationResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<CreateProjectResponse> createProject(CreateProjectRequest request, AsyncHandler<CreateProjectRequest, CreateProjectResponse> handler) {
        LOG.trace("Called async createProject");
        CreateProjectRequest interceptedRequest = CreateProjectConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = CreateProjectConverter.fromRequest(this.client, interceptedRequest);
        com.google.common.base.Function<Response, CreateProjectResponse> transformer = CreateProjectConverter.fromResponse();
        RetryTokenUtils.addRetryToken((WrappedInvocationBuilder)ib);
        AsyncHandler<CreateProjectRequest, CreateProjectResponse> handlerToUse = handler;
        Function futureSupplier = this.client.postFutureSupplier((BmcRequest)interceptedRequest, ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<CreateProjectRequest, CreateProjectResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<CreateTaskResponse> createTask(CreateTaskRequest request, AsyncHandler<CreateTaskRequest, CreateTaskResponse> handler) {
        LOG.trace("Called async createTask");
        CreateTaskRequest interceptedRequest = CreateTaskConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = CreateTaskConverter.fromRequest(this.client, interceptedRequest);
        com.google.common.base.Function<Response, CreateTaskResponse> transformer = CreateTaskConverter.fromResponse();
        RetryTokenUtils.addRetryToken((WrappedInvocationBuilder)ib);
        AsyncHandler<CreateTaskRequest, CreateTaskResponse> handlerToUse = handler;
        Function futureSupplier = this.client.postFutureSupplier((BmcRequest)interceptedRequest, ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<CreateTaskRequest, CreateTaskResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<CreateTaskRunResponse> createTaskRun(CreateTaskRunRequest request, AsyncHandler<CreateTaskRunRequest, CreateTaskRunResponse> handler) {
        LOG.trace("Called async createTaskRun");
        CreateTaskRunRequest interceptedRequest = CreateTaskRunConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = CreateTaskRunConverter.fromRequest(this.client, interceptedRequest);
        com.google.common.base.Function<Response, CreateTaskRunResponse> transformer = CreateTaskRunConverter.fromResponse();
        RetryTokenUtils.addRetryToken((WrappedInvocationBuilder)ib);
        AsyncHandler<CreateTaskRunRequest, CreateTaskRunResponse> handlerToUse = handler;
        Function futureSupplier = this.client.postFutureSupplier((BmcRequest)interceptedRequest, ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<CreateTaskRunRequest, CreateTaskRunResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<CreateTaskValidationResponse> createTaskValidation(CreateTaskValidationRequest request, AsyncHandler<CreateTaskValidationRequest, CreateTaskValidationResponse> handler) {
        LOG.trace("Called async createTaskValidation");
        CreateTaskValidationRequest interceptedRequest = CreateTaskValidationConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = CreateTaskValidationConverter.fromRequest(this.client, interceptedRequest);
        com.google.common.base.Function<Response, CreateTaskValidationResponse> transformer = CreateTaskValidationConverter.fromResponse();
        RetryTokenUtils.addRetryToken((WrappedInvocationBuilder)ib);
        AsyncHandler<CreateTaskValidationRequest, CreateTaskValidationResponse> handlerToUse = handler;
        Function futureSupplier = this.client.postFutureSupplier((BmcRequest)interceptedRequest, ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<CreateTaskValidationRequest, CreateTaskValidationResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<CreateWorkspaceResponse> createWorkspace(CreateWorkspaceRequest request, AsyncHandler<CreateWorkspaceRequest, CreateWorkspaceResponse> handler) {
        LOG.trace("Called async createWorkspace");
        CreateWorkspaceRequest interceptedRequest = CreateWorkspaceConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = CreateWorkspaceConverter.fromRequest(this.client, interceptedRequest);
        com.google.common.base.Function<Response, CreateWorkspaceResponse> transformer = CreateWorkspaceConverter.fromResponse();
        RetryTokenUtils.addRetryToken((WrappedInvocationBuilder)ib);
        AsyncHandler<CreateWorkspaceRequest, CreateWorkspaceResponse> handlerToUse = handler;
        Function futureSupplier = this.client.postFutureSupplier((BmcRequest)interceptedRequest, ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<CreateWorkspaceRequest, CreateWorkspaceResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<DeleteApplicationResponse> deleteApplication(DeleteApplicationRequest request, AsyncHandler<DeleteApplicationRequest, DeleteApplicationResponse> handler) {
        LOG.trace("Called async deleteApplication");
        DeleteApplicationRequest interceptedRequest = DeleteApplicationConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = DeleteApplicationConverter.fromRequest(this.client, interceptedRequest);
        com.google.common.base.Function<Response, DeleteApplicationResponse> transformer = DeleteApplicationConverter.fromResponse();
        AsyncHandler<DeleteApplicationRequest, DeleteApplicationResponse> handlerToUse = handler;
        Function futureSupplier = this.client.deleteFutureSupplier((BmcRequest)interceptedRequest, ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<DeleteApplicationRequest, DeleteApplicationResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<DeleteConnectionResponse> deleteConnection(DeleteConnectionRequest request, AsyncHandler<DeleteConnectionRequest, DeleteConnectionResponse> handler) {
        LOG.trace("Called async deleteConnection");
        DeleteConnectionRequest interceptedRequest = DeleteConnectionConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = DeleteConnectionConverter.fromRequest(this.client, interceptedRequest);
        com.google.common.base.Function<Response, DeleteConnectionResponse> transformer = DeleteConnectionConverter.fromResponse();
        AsyncHandler<DeleteConnectionRequest, DeleteConnectionResponse> handlerToUse = handler;
        Function futureSupplier = this.client.deleteFutureSupplier((BmcRequest)interceptedRequest, ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<DeleteConnectionRequest, DeleteConnectionResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<DeleteConnectionValidationResponse> deleteConnectionValidation(DeleteConnectionValidationRequest request, AsyncHandler<DeleteConnectionValidationRequest, DeleteConnectionValidationResponse> handler) {
        LOG.trace("Called async deleteConnectionValidation");
        DeleteConnectionValidationRequest interceptedRequest = DeleteConnectionValidationConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = DeleteConnectionValidationConverter.fromRequest(this.client, interceptedRequest);
        com.google.common.base.Function<Response, DeleteConnectionValidationResponse> transformer = DeleteConnectionValidationConverter.fromResponse();
        AsyncHandler<DeleteConnectionValidationRequest, DeleteConnectionValidationResponse> handlerToUse = handler;
        Function futureSupplier = this.client.deleteFutureSupplier((BmcRequest)interceptedRequest, ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<DeleteConnectionValidationRequest, DeleteConnectionValidationResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<DeleteDataAssetResponse> deleteDataAsset(DeleteDataAssetRequest request, AsyncHandler<DeleteDataAssetRequest, DeleteDataAssetResponse> handler) {
        LOG.trace("Called async deleteDataAsset");
        DeleteDataAssetRequest interceptedRequest = DeleteDataAssetConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = DeleteDataAssetConverter.fromRequest(this.client, interceptedRequest);
        com.google.common.base.Function<Response, DeleteDataAssetResponse> transformer = DeleteDataAssetConverter.fromResponse();
        AsyncHandler<DeleteDataAssetRequest, DeleteDataAssetResponse> handlerToUse = handler;
        Function futureSupplier = this.client.deleteFutureSupplier((BmcRequest)interceptedRequest, ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<DeleteDataAssetRequest, DeleteDataAssetResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<DeleteDataFlowResponse> deleteDataFlow(DeleteDataFlowRequest request, AsyncHandler<DeleteDataFlowRequest, DeleteDataFlowResponse> handler) {
        LOG.trace("Called async deleteDataFlow");
        DeleteDataFlowRequest interceptedRequest = DeleteDataFlowConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = DeleteDataFlowConverter.fromRequest(this.client, interceptedRequest);
        com.google.common.base.Function<Response, DeleteDataFlowResponse> transformer = DeleteDataFlowConverter.fromResponse();
        AsyncHandler<DeleteDataFlowRequest, DeleteDataFlowResponse> handlerToUse = handler;
        Function futureSupplier = this.client.deleteFutureSupplier((BmcRequest)interceptedRequest, ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<DeleteDataFlowRequest, DeleteDataFlowResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<DeleteDataFlowValidationResponse> deleteDataFlowValidation(DeleteDataFlowValidationRequest request, AsyncHandler<DeleteDataFlowValidationRequest, DeleteDataFlowValidationResponse> handler) {
        LOG.trace("Called async deleteDataFlowValidation");
        DeleteDataFlowValidationRequest interceptedRequest = DeleteDataFlowValidationConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = DeleteDataFlowValidationConverter.fromRequest(this.client, interceptedRequest);
        com.google.common.base.Function<Response, DeleteDataFlowValidationResponse> transformer = DeleteDataFlowValidationConverter.fromResponse();
        AsyncHandler<DeleteDataFlowValidationRequest, DeleteDataFlowValidationResponse> handlerToUse = handler;
        Function futureSupplier = this.client.deleteFutureSupplier((BmcRequest)interceptedRequest, ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<DeleteDataFlowValidationRequest, DeleteDataFlowValidationResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<DeleteExternalPublicationResponse> deleteExternalPublication(DeleteExternalPublicationRequest request, AsyncHandler<DeleteExternalPublicationRequest, DeleteExternalPublicationResponse> handler) {
        LOG.trace("Called async deleteExternalPublication");
        DeleteExternalPublicationRequest interceptedRequest = DeleteExternalPublicationConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = DeleteExternalPublicationConverter.fromRequest(this.client, interceptedRequest);
        com.google.common.base.Function<Response, DeleteExternalPublicationResponse> transformer = DeleteExternalPublicationConverter.fromResponse();
        AsyncHandler<DeleteExternalPublicationRequest, DeleteExternalPublicationResponse> handlerToUse = handler;
        Function futureSupplier = this.client.deleteFutureSupplier((BmcRequest)interceptedRequest, ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<DeleteExternalPublicationRequest, DeleteExternalPublicationResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<DeleteExternalPublicationValidationResponse> deleteExternalPublicationValidation(DeleteExternalPublicationValidationRequest request, AsyncHandler<DeleteExternalPublicationValidationRequest, DeleteExternalPublicationValidationResponse> handler) {
        LOG.trace("Called async deleteExternalPublicationValidation");
        DeleteExternalPublicationValidationRequest interceptedRequest = DeleteExternalPublicationValidationConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = DeleteExternalPublicationValidationConverter.fromRequest(this.client, interceptedRequest);
        com.google.common.base.Function<Response, DeleteExternalPublicationValidationResponse> transformer = DeleteExternalPublicationValidationConverter.fromResponse();
        AsyncHandler<DeleteExternalPublicationValidationRequest, DeleteExternalPublicationValidationResponse> handlerToUse = handler;
        Function futureSupplier = this.client.deleteFutureSupplier((BmcRequest)interceptedRequest, ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<DeleteExternalPublicationValidationRequest, DeleteExternalPublicationValidationResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<DeleteFolderResponse> deleteFolder(DeleteFolderRequest request, AsyncHandler<DeleteFolderRequest, DeleteFolderResponse> handler) {
        LOG.trace("Called async deleteFolder");
        DeleteFolderRequest interceptedRequest = DeleteFolderConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = DeleteFolderConverter.fromRequest(this.client, interceptedRequest);
        com.google.common.base.Function<Response, DeleteFolderResponse> transformer = DeleteFolderConverter.fromResponse();
        AsyncHandler<DeleteFolderRequest, DeleteFolderResponse> handlerToUse = handler;
        Function futureSupplier = this.client.deleteFutureSupplier((BmcRequest)interceptedRequest, ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<DeleteFolderRequest, DeleteFolderResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<DeletePatchResponse> deletePatch(DeletePatchRequest request, AsyncHandler<DeletePatchRequest, DeletePatchResponse> handler) {
        LOG.trace("Called async deletePatch");
        DeletePatchRequest interceptedRequest = DeletePatchConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = DeletePatchConverter.fromRequest(this.client, interceptedRequest);
        com.google.common.base.Function<Response, DeletePatchResponse> transformer = DeletePatchConverter.fromResponse();
        AsyncHandler<DeletePatchRequest, DeletePatchResponse> handlerToUse = handler;
        Function futureSupplier = this.client.deleteFutureSupplier((BmcRequest)interceptedRequest, ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<DeletePatchRequest, DeletePatchResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<DeletePipelineResponse> deletePipeline(DeletePipelineRequest request, AsyncHandler<DeletePipelineRequest, DeletePipelineResponse> handler) {
        LOG.trace("Called async deletePipeline");
        DeletePipelineRequest interceptedRequest = DeletePipelineConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = DeletePipelineConverter.fromRequest(this.client, interceptedRequest);
        com.google.common.base.Function<Response, DeletePipelineResponse> transformer = DeletePipelineConverter.fromResponse();
        AsyncHandler<DeletePipelineRequest, DeletePipelineResponse> handlerToUse = handler;
        Function futureSupplier = this.client.deleteFutureSupplier((BmcRequest)interceptedRequest, ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<DeletePipelineRequest, DeletePipelineResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<DeletePipelineValidationResponse> deletePipelineValidation(DeletePipelineValidationRequest request, AsyncHandler<DeletePipelineValidationRequest, DeletePipelineValidationResponse> handler) {
        LOG.trace("Called async deletePipelineValidation");
        DeletePipelineValidationRequest interceptedRequest = DeletePipelineValidationConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = DeletePipelineValidationConverter.fromRequest(this.client, interceptedRequest);
        com.google.common.base.Function<Response, DeletePipelineValidationResponse> transformer = DeletePipelineValidationConverter.fromResponse();
        AsyncHandler<DeletePipelineValidationRequest, DeletePipelineValidationResponse> handlerToUse = handler;
        Function futureSupplier = this.client.deleteFutureSupplier((BmcRequest)interceptedRequest, ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<DeletePipelineValidationRequest, DeletePipelineValidationResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<DeleteProjectResponse> deleteProject(DeleteProjectRequest request, AsyncHandler<DeleteProjectRequest, DeleteProjectResponse> handler) {
        LOG.trace("Called async deleteProject");
        DeleteProjectRequest interceptedRequest = DeleteProjectConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = DeleteProjectConverter.fromRequest(this.client, interceptedRequest);
        com.google.common.base.Function<Response, DeleteProjectResponse> transformer = DeleteProjectConverter.fromResponse();
        AsyncHandler<DeleteProjectRequest, DeleteProjectResponse> handlerToUse = handler;
        Function futureSupplier = this.client.deleteFutureSupplier((BmcRequest)interceptedRequest, ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<DeleteProjectRequest, DeleteProjectResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<DeleteTaskResponse> deleteTask(DeleteTaskRequest request, AsyncHandler<DeleteTaskRequest, DeleteTaskResponse> handler) {
        LOG.trace("Called async deleteTask");
        DeleteTaskRequest interceptedRequest = DeleteTaskConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = DeleteTaskConverter.fromRequest(this.client, interceptedRequest);
        com.google.common.base.Function<Response, DeleteTaskResponse> transformer = DeleteTaskConverter.fromResponse();
        AsyncHandler<DeleteTaskRequest, DeleteTaskResponse> handlerToUse = handler;
        Function futureSupplier = this.client.deleteFutureSupplier((BmcRequest)interceptedRequest, ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<DeleteTaskRequest, DeleteTaskResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<DeleteTaskRunResponse> deleteTaskRun(DeleteTaskRunRequest request, AsyncHandler<DeleteTaskRunRequest, DeleteTaskRunResponse> handler) {
        LOG.trace("Called async deleteTaskRun");
        DeleteTaskRunRequest interceptedRequest = DeleteTaskRunConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = DeleteTaskRunConverter.fromRequest(this.client, interceptedRequest);
        com.google.common.base.Function<Response, DeleteTaskRunResponse> transformer = DeleteTaskRunConverter.fromResponse();
        AsyncHandler<DeleteTaskRunRequest, DeleteTaskRunResponse> handlerToUse = handler;
        Function futureSupplier = this.client.deleteFutureSupplier((BmcRequest)interceptedRequest, ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<DeleteTaskRunRequest, DeleteTaskRunResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<DeleteTaskValidationResponse> deleteTaskValidation(DeleteTaskValidationRequest request, AsyncHandler<DeleteTaskValidationRequest, DeleteTaskValidationResponse> handler) {
        LOG.trace("Called async deleteTaskValidation");
        DeleteTaskValidationRequest interceptedRequest = DeleteTaskValidationConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = DeleteTaskValidationConverter.fromRequest(this.client, interceptedRequest);
        com.google.common.base.Function<Response, DeleteTaskValidationResponse> transformer = DeleteTaskValidationConverter.fromResponse();
        AsyncHandler<DeleteTaskValidationRequest, DeleteTaskValidationResponse> handlerToUse = handler;
        Function futureSupplier = this.client.deleteFutureSupplier((BmcRequest)interceptedRequest, ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<DeleteTaskValidationRequest, DeleteTaskValidationResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<DeleteWorkspaceResponse> deleteWorkspace(DeleteWorkspaceRequest request, AsyncHandler<DeleteWorkspaceRequest, DeleteWorkspaceResponse> handler) {
        LOG.trace("Called async deleteWorkspace");
        DeleteWorkspaceRequest interceptedRequest = DeleteWorkspaceConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = DeleteWorkspaceConverter.fromRequest(this.client, interceptedRequest);
        com.google.common.base.Function<Response, DeleteWorkspaceResponse> transformer = DeleteWorkspaceConverter.fromResponse();
        AsyncHandler<DeleteWorkspaceRequest, DeleteWorkspaceResponse> handlerToUse = handler;
        Function futureSupplier = this.client.deleteFutureSupplier((BmcRequest)interceptedRequest, ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<DeleteWorkspaceRequest, DeleteWorkspaceResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<GetApplicationResponse> getApplication(GetApplicationRequest request, AsyncHandler<GetApplicationRequest, GetApplicationResponse> handler) {
        LOG.trace("Called async getApplication");
        GetApplicationRequest interceptedRequest = GetApplicationConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = GetApplicationConverter.fromRequest(this.client, interceptedRequest);
        com.google.common.base.Function<Response, GetApplicationResponse> transformer = GetApplicationConverter.fromResponse();
        AsyncHandler<GetApplicationRequest, GetApplicationResponse> handlerToUse = handler;
        Function futureSupplier = this.client.getFutureSupplier((BmcRequest)interceptedRequest, ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<GetApplicationRequest, GetApplicationResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<GetConnectionResponse> getConnection(GetConnectionRequest request, AsyncHandler<GetConnectionRequest, GetConnectionResponse> handler) {
        LOG.trace("Called async getConnection");
        GetConnectionRequest interceptedRequest = GetConnectionConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = GetConnectionConverter.fromRequest(this.client, interceptedRequest);
        com.google.common.base.Function<Response, GetConnectionResponse> transformer = GetConnectionConverter.fromResponse();
        AsyncHandler<GetConnectionRequest, GetConnectionResponse> handlerToUse = handler;
        Function futureSupplier = this.client.getFutureSupplier((BmcRequest)interceptedRequest, ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<GetConnectionRequest, GetConnectionResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<GetConnectionValidationResponse> getConnectionValidation(GetConnectionValidationRequest request, AsyncHandler<GetConnectionValidationRequest, GetConnectionValidationResponse> handler) {
        LOG.trace("Called async getConnectionValidation");
        GetConnectionValidationRequest interceptedRequest = GetConnectionValidationConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = GetConnectionValidationConverter.fromRequest(this.client, interceptedRequest);
        com.google.common.base.Function<Response, GetConnectionValidationResponse> transformer = GetConnectionValidationConverter.fromResponse();
        AsyncHandler<GetConnectionValidationRequest, GetConnectionValidationResponse> handlerToUse = handler;
        Function futureSupplier = this.client.getFutureSupplier((BmcRequest)interceptedRequest, ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<GetConnectionValidationRequest, GetConnectionValidationResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<GetCountStatisticResponse> getCountStatistic(GetCountStatisticRequest request, AsyncHandler<GetCountStatisticRequest, GetCountStatisticResponse> handler) {
        LOG.trace("Called async getCountStatistic");
        GetCountStatisticRequest interceptedRequest = GetCountStatisticConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = GetCountStatisticConverter.fromRequest(this.client, interceptedRequest);
        com.google.common.base.Function<Response, GetCountStatisticResponse> transformer = GetCountStatisticConverter.fromResponse();
        AsyncHandler<GetCountStatisticRequest, GetCountStatisticResponse> handlerToUse = handler;
        Function futureSupplier = this.client.getFutureSupplier((BmcRequest)interceptedRequest, ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<GetCountStatisticRequest, GetCountStatisticResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<GetDataAssetResponse> getDataAsset(GetDataAssetRequest request, AsyncHandler<GetDataAssetRequest, GetDataAssetResponse> handler) {
        LOG.trace("Called async getDataAsset");
        GetDataAssetRequest interceptedRequest = GetDataAssetConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = GetDataAssetConverter.fromRequest(this.client, interceptedRequest);
        com.google.common.base.Function<Response, GetDataAssetResponse> transformer = GetDataAssetConverter.fromResponse();
        AsyncHandler<GetDataAssetRequest, GetDataAssetResponse> handlerToUse = handler;
        Function futureSupplier = this.client.getFutureSupplier((BmcRequest)interceptedRequest, ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<GetDataAssetRequest, GetDataAssetResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<GetDataEntityResponse> getDataEntity(GetDataEntityRequest request, AsyncHandler<GetDataEntityRequest, GetDataEntityResponse> handler) {
        LOG.trace("Called async getDataEntity");
        GetDataEntityRequest interceptedRequest = GetDataEntityConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = GetDataEntityConverter.fromRequest(this.client, interceptedRequest);
        com.google.common.base.Function<Response, GetDataEntityResponse> transformer = GetDataEntityConverter.fromResponse();
        AsyncHandler<GetDataEntityRequest, GetDataEntityResponse> handlerToUse = handler;
        Function futureSupplier = this.client.getFutureSupplier((BmcRequest)interceptedRequest, ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<GetDataEntityRequest, GetDataEntityResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<GetDataFlowResponse> getDataFlow(GetDataFlowRequest request, AsyncHandler<GetDataFlowRequest, GetDataFlowResponse> handler) {
        LOG.trace("Called async getDataFlow");
        GetDataFlowRequest interceptedRequest = GetDataFlowConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = GetDataFlowConverter.fromRequest(this.client, interceptedRequest);
        com.google.common.base.Function<Response, GetDataFlowResponse> transformer = GetDataFlowConverter.fromResponse();
        AsyncHandler<GetDataFlowRequest, GetDataFlowResponse> handlerToUse = handler;
        Function futureSupplier = this.client.getFutureSupplier((BmcRequest)interceptedRequest, ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<GetDataFlowRequest, GetDataFlowResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<GetDataFlowValidationResponse> getDataFlowValidation(GetDataFlowValidationRequest request, AsyncHandler<GetDataFlowValidationRequest, GetDataFlowValidationResponse> handler) {
        LOG.trace("Called async getDataFlowValidation");
        GetDataFlowValidationRequest interceptedRequest = GetDataFlowValidationConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = GetDataFlowValidationConverter.fromRequest(this.client, interceptedRequest);
        com.google.common.base.Function<Response, GetDataFlowValidationResponse> transformer = GetDataFlowValidationConverter.fromResponse();
        AsyncHandler<GetDataFlowValidationRequest, GetDataFlowValidationResponse> handlerToUse = handler;
        Function futureSupplier = this.client.getFutureSupplier((BmcRequest)interceptedRequest, ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<GetDataFlowValidationRequest, GetDataFlowValidationResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<GetDependentObjectResponse> getDependentObject(GetDependentObjectRequest request, AsyncHandler<GetDependentObjectRequest, GetDependentObjectResponse> handler) {
        LOG.trace("Called async getDependentObject");
        GetDependentObjectRequest interceptedRequest = GetDependentObjectConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = GetDependentObjectConverter.fromRequest(this.client, interceptedRequest);
        com.google.common.base.Function<Response, GetDependentObjectResponse> transformer = GetDependentObjectConverter.fromResponse();
        AsyncHandler<GetDependentObjectRequest, GetDependentObjectResponse> handlerToUse = handler;
        Function futureSupplier = this.client.getFutureSupplier((BmcRequest)interceptedRequest, ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<GetDependentObjectRequest, GetDependentObjectResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<GetExternalPublicationResponse> getExternalPublication(GetExternalPublicationRequest request, AsyncHandler<GetExternalPublicationRequest, GetExternalPublicationResponse> handler) {
        LOG.trace("Called async getExternalPublication");
        GetExternalPublicationRequest interceptedRequest = GetExternalPublicationConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = GetExternalPublicationConverter.fromRequest(this.client, interceptedRequest);
        com.google.common.base.Function<Response, GetExternalPublicationResponse> transformer = GetExternalPublicationConverter.fromResponse();
        AsyncHandler<GetExternalPublicationRequest, GetExternalPublicationResponse> handlerToUse = handler;
        Function futureSupplier = this.client.getFutureSupplier((BmcRequest)interceptedRequest, ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<GetExternalPublicationRequest, GetExternalPublicationResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<GetExternalPublicationValidationResponse> getExternalPublicationValidation(GetExternalPublicationValidationRequest request, AsyncHandler<GetExternalPublicationValidationRequest, GetExternalPublicationValidationResponse> handler) {
        LOG.trace("Called async getExternalPublicationValidation");
        GetExternalPublicationValidationRequest interceptedRequest = GetExternalPublicationValidationConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = GetExternalPublicationValidationConverter.fromRequest(this.client, interceptedRequest);
        com.google.common.base.Function<Response, GetExternalPublicationValidationResponse> transformer = GetExternalPublicationValidationConverter.fromResponse();
        AsyncHandler<GetExternalPublicationValidationRequest, GetExternalPublicationValidationResponse> handlerToUse = handler;
        Function futureSupplier = this.client.getFutureSupplier((BmcRequest)interceptedRequest, ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<GetExternalPublicationValidationRequest, GetExternalPublicationValidationResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<GetFolderResponse> getFolder(GetFolderRequest request, AsyncHandler<GetFolderRequest, GetFolderResponse> handler) {
        LOG.trace("Called async getFolder");
        GetFolderRequest interceptedRequest = GetFolderConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = GetFolderConverter.fromRequest(this.client, interceptedRequest);
        com.google.common.base.Function<Response, GetFolderResponse> transformer = GetFolderConverter.fromResponse();
        AsyncHandler<GetFolderRequest, GetFolderResponse> handlerToUse = handler;
        Function futureSupplier = this.client.getFutureSupplier((BmcRequest)interceptedRequest, ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<GetFolderRequest, GetFolderResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<GetPatchResponse> getPatch(GetPatchRequest request, AsyncHandler<GetPatchRequest, GetPatchResponse> handler) {
        LOG.trace("Called async getPatch");
        GetPatchRequest interceptedRequest = GetPatchConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = GetPatchConverter.fromRequest(this.client, interceptedRequest);
        com.google.common.base.Function<Response, GetPatchResponse> transformer = GetPatchConverter.fromResponse();
        AsyncHandler<GetPatchRequest, GetPatchResponse> handlerToUse = handler;
        Function futureSupplier = this.client.getFutureSupplier((BmcRequest)interceptedRequest, ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<GetPatchRequest, GetPatchResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<GetPipelineResponse> getPipeline(GetPipelineRequest request, AsyncHandler<GetPipelineRequest, GetPipelineResponse> handler) {
        LOG.trace("Called async getPipeline");
        GetPipelineRequest interceptedRequest = GetPipelineConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = GetPipelineConverter.fromRequest(this.client, interceptedRequest);
        com.google.common.base.Function<Response, GetPipelineResponse> transformer = GetPipelineConverter.fromResponse();
        AsyncHandler<GetPipelineRequest, GetPipelineResponse> handlerToUse = handler;
        Function futureSupplier = this.client.getFutureSupplier((BmcRequest)interceptedRequest, ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<GetPipelineRequest, GetPipelineResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<GetPipelineValidationResponse> getPipelineValidation(GetPipelineValidationRequest request, AsyncHandler<GetPipelineValidationRequest, GetPipelineValidationResponse> handler) {
        LOG.trace("Called async getPipelineValidation");
        GetPipelineValidationRequest interceptedRequest = GetPipelineValidationConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = GetPipelineValidationConverter.fromRequest(this.client, interceptedRequest);
        com.google.common.base.Function<Response, GetPipelineValidationResponse> transformer = GetPipelineValidationConverter.fromResponse();
        AsyncHandler<GetPipelineValidationRequest, GetPipelineValidationResponse> handlerToUse = handler;
        Function futureSupplier = this.client.getFutureSupplier((BmcRequest)interceptedRequest, ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<GetPipelineValidationRequest, GetPipelineValidationResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<GetProjectResponse> getProject(GetProjectRequest request, AsyncHandler<GetProjectRequest, GetProjectResponse> handler) {
        LOG.trace("Called async getProject");
        GetProjectRequest interceptedRequest = GetProjectConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = GetProjectConverter.fromRequest(this.client, interceptedRequest);
        com.google.common.base.Function<Response, GetProjectResponse> transformer = GetProjectConverter.fromResponse();
        AsyncHandler<GetProjectRequest, GetProjectResponse> handlerToUse = handler;
        Function futureSupplier = this.client.getFutureSupplier((BmcRequest)interceptedRequest, ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<GetProjectRequest, GetProjectResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<GetPublishedObjectResponse> getPublishedObject(GetPublishedObjectRequest request, AsyncHandler<GetPublishedObjectRequest, GetPublishedObjectResponse> handler) {
        LOG.trace("Called async getPublishedObject");
        GetPublishedObjectRequest interceptedRequest = GetPublishedObjectConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = GetPublishedObjectConverter.fromRequest(this.client, interceptedRequest);
        com.google.common.base.Function<Response, GetPublishedObjectResponse> transformer = GetPublishedObjectConverter.fromResponse();
        AsyncHandler<GetPublishedObjectRequest, GetPublishedObjectResponse> handlerToUse = handler;
        Function futureSupplier = this.client.getFutureSupplier((BmcRequest)interceptedRequest, ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<GetPublishedObjectRequest, GetPublishedObjectResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<GetReferenceResponse> getReference(GetReferenceRequest request, AsyncHandler<GetReferenceRequest, GetReferenceResponse> handler) {
        LOG.trace("Called async getReference");
        GetReferenceRequest interceptedRequest = GetReferenceConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = GetReferenceConverter.fromRequest(this.client, interceptedRequest);
        com.google.common.base.Function<Response, GetReferenceResponse> transformer = GetReferenceConverter.fromResponse();
        AsyncHandler<GetReferenceRequest, GetReferenceResponse> handlerToUse = handler;
        Function futureSupplier = this.client.getFutureSupplier((BmcRequest)interceptedRequest, ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<GetReferenceRequest, GetReferenceResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<GetSchemaResponse> getSchema(GetSchemaRequest request, AsyncHandler<GetSchemaRequest, GetSchemaResponse> handler) {
        LOG.trace("Called async getSchema");
        GetSchemaRequest interceptedRequest = GetSchemaConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = GetSchemaConverter.fromRequest(this.client, interceptedRequest);
        com.google.common.base.Function<Response, GetSchemaResponse> transformer = GetSchemaConverter.fromResponse();
        AsyncHandler<GetSchemaRequest, GetSchemaResponse> handlerToUse = handler;
        Function futureSupplier = this.client.getFutureSupplier((BmcRequest)interceptedRequest, ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<GetSchemaRequest, GetSchemaResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<GetTaskResponse> getTask(GetTaskRequest request, AsyncHandler<GetTaskRequest, GetTaskResponse> handler) {
        LOG.trace("Called async getTask");
        GetTaskRequest interceptedRequest = GetTaskConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = GetTaskConverter.fromRequest(this.client, interceptedRequest);
        com.google.common.base.Function<Response, GetTaskResponse> transformer = GetTaskConverter.fromResponse();
        AsyncHandler<GetTaskRequest, GetTaskResponse> handlerToUse = handler;
        Function futureSupplier = this.client.getFutureSupplier((BmcRequest)interceptedRequest, ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<GetTaskRequest, GetTaskResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<GetTaskRunResponse> getTaskRun(GetTaskRunRequest request, AsyncHandler<GetTaskRunRequest, GetTaskRunResponse> handler) {
        LOG.trace("Called async getTaskRun");
        GetTaskRunRequest interceptedRequest = GetTaskRunConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = GetTaskRunConverter.fromRequest(this.client, interceptedRequest);
        com.google.common.base.Function<Response, GetTaskRunResponse> transformer = GetTaskRunConverter.fromResponse();
        AsyncHandler<GetTaskRunRequest, GetTaskRunResponse> handlerToUse = handler;
        Function futureSupplier = this.client.getFutureSupplier((BmcRequest)interceptedRequest, ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<GetTaskRunRequest, GetTaskRunResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<GetTaskValidationResponse> getTaskValidation(GetTaskValidationRequest request, AsyncHandler<GetTaskValidationRequest, GetTaskValidationResponse> handler) {
        LOG.trace("Called async getTaskValidation");
        GetTaskValidationRequest interceptedRequest = GetTaskValidationConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = GetTaskValidationConverter.fromRequest(this.client, interceptedRequest);
        com.google.common.base.Function<Response, GetTaskValidationResponse> transformer = GetTaskValidationConverter.fromResponse();
        AsyncHandler<GetTaskValidationRequest, GetTaskValidationResponse> handlerToUse = handler;
        Function futureSupplier = this.client.getFutureSupplier((BmcRequest)interceptedRequest, ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<GetTaskValidationRequest, GetTaskValidationResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<GetWorkRequestResponse> getWorkRequest(GetWorkRequestRequest request, AsyncHandler<GetWorkRequestRequest, GetWorkRequestResponse> handler) {
        LOG.trace("Called async getWorkRequest");
        GetWorkRequestRequest interceptedRequest = GetWorkRequestConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = GetWorkRequestConverter.fromRequest(this.client, interceptedRequest);
        com.google.common.base.Function<Response, GetWorkRequestResponse> transformer = GetWorkRequestConverter.fromResponse();
        AsyncHandler<GetWorkRequestRequest, GetWorkRequestResponse> handlerToUse = handler;
        Function futureSupplier = this.client.getFutureSupplier((BmcRequest)interceptedRequest, ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<GetWorkRequestRequest, GetWorkRequestResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<GetWorkspaceResponse> getWorkspace(GetWorkspaceRequest request, AsyncHandler<GetWorkspaceRequest, GetWorkspaceResponse> handler) {
        LOG.trace("Called async getWorkspace");
        GetWorkspaceRequest interceptedRequest = GetWorkspaceConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = GetWorkspaceConverter.fromRequest(this.client, interceptedRequest);
        com.google.common.base.Function<Response, GetWorkspaceResponse> transformer = GetWorkspaceConverter.fromResponse();
        AsyncHandler<GetWorkspaceRequest, GetWorkspaceResponse> handlerToUse = handler;
        Function futureSupplier = this.client.getFutureSupplier((BmcRequest)interceptedRequest, ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<GetWorkspaceRequest, GetWorkspaceResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<ListApplicationsResponse> listApplications(ListApplicationsRequest request, AsyncHandler<ListApplicationsRequest, ListApplicationsResponse> handler) {
        LOG.trace("Called async listApplications");
        ListApplicationsRequest interceptedRequest = ListApplicationsConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = ListApplicationsConverter.fromRequest(this.client, interceptedRequest);
        com.google.common.base.Function<Response, ListApplicationsResponse> transformer = ListApplicationsConverter.fromResponse();
        AsyncHandler<ListApplicationsRequest, ListApplicationsResponse> handlerToUse = handler;
        Function futureSupplier = this.client.getFutureSupplier((BmcRequest)interceptedRequest, ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<ListApplicationsRequest, ListApplicationsResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<ListConnectionValidationsResponse> listConnectionValidations(ListConnectionValidationsRequest request, AsyncHandler<ListConnectionValidationsRequest, ListConnectionValidationsResponse> handler) {
        LOG.trace("Called async listConnectionValidations");
        ListConnectionValidationsRequest interceptedRequest = ListConnectionValidationsConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = ListConnectionValidationsConverter.fromRequest(this.client, interceptedRequest);
        com.google.common.base.Function<Response, ListConnectionValidationsResponse> transformer = ListConnectionValidationsConverter.fromResponse();
        AsyncHandler<ListConnectionValidationsRequest, ListConnectionValidationsResponse> handlerToUse = handler;
        Function futureSupplier = this.client.getFutureSupplier((BmcRequest)interceptedRequest, ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<ListConnectionValidationsRequest, ListConnectionValidationsResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<ListConnectionsResponse> listConnections(ListConnectionsRequest request, AsyncHandler<ListConnectionsRequest, ListConnectionsResponse> handler) {
        LOG.trace("Called async listConnections");
        ListConnectionsRequest interceptedRequest = ListConnectionsConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = ListConnectionsConverter.fromRequest(this.client, interceptedRequest);
        com.google.common.base.Function<Response, ListConnectionsResponse> transformer = ListConnectionsConverter.fromResponse();
        AsyncHandler<ListConnectionsRequest, ListConnectionsResponse> handlerToUse = handler;
        Function futureSupplier = this.client.getFutureSupplier((BmcRequest)interceptedRequest, ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<ListConnectionsRequest, ListConnectionsResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<ListDataAssetsResponse> listDataAssets(ListDataAssetsRequest request, AsyncHandler<ListDataAssetsRequest, ListDataAssetsResponse> handler) {
        LOG.trace("Called async listDataAssets");
        ListDataAssetsRequest interceptedRequest = ListDataAssetsConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = ListDataAssetsConverter.fromRequest(this.client, interceptedRequest);
        com.google.common.base.Function<Response, ListDataAssetsResponse> transformer = ListDataAssetsConverter.fromResponse();
        AsyncHandler<ListDataAssetsRequest, ListDataAssetsResponse> handlerToUse = handler;
        Function futureSupplier = this.client.getFutureSupplier((BmcRequest)interceptedRequest, ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<ListDataAssetsRequest, ListDataAssetsResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<ListDataEntitiesResponse> listDataEntities(ListDataEntitiesRequest request, AsyncHandler<ListDataEntitiesRequest, ListDataEntitiesResponse> handler) {
        LOG.trace("Called async listDataEntities");
        ListDataEntitiesRequest interceptedRequest = ListDataEntitiesConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = ListDataEntitiesConverter.fromRequest(this.client, interceptedRequest);
        com.google.common.base.Function<Response, ListDataEntitiesResponse> transformer = ListDataEntitiesConverter.fromResponse();
        AsyncHandler<ListDataEntitiesRequest, ListDataEntitiesResponse> handlerToUse = handler;
        Function futureSupplier = this.client.getFutureSupplier((BmcRequest)interceptedRequest, ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<ListDataEntitiesRequest, ListDataEntitiesResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<ListDataFlowValidationsResponse> listDataFlowValidations(ListDataFlowValidationsRequest request, AsyncHandler<ListDataFlowValidationsRequest, ListDataFlowValidationsResponse> handler) {
        LOG.trace("Called async listDataFlowValidations");
        ListDataFlowValidationsRequest interceptedRequest = ListDataFlowValidationsConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = ListDataFlowValidationsConverter.fromRequest(this.client, interceptedRequest);
        com.google.common.base.Function<Response, ListDataFlowValidationsResponse> transformer = ListDataFlowValidationsConverter.fromResponse();
        AsyncHandler<ListDataFlowValidationsRequest, ListDataFlowValidationsResponse> handlerToUse = handler;
        Function futureSupplier = this.client.getFutureSupplier((BmcRequest)interceptedRequest, ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<ListDataFlowValidationsRequest, ListDataFlowValidationsResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<ListDataFlowsResponse> listDataFlows(ListDataFlowsRequest request, AsyncHandler<ListDataFlowsRequest, ListDataFlowsResponse> handler) {
        LOG.trace("Called async listDataFlows");
        ListDataFlowsRequest interceptedRequest = ListDataFlowsConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = ListDataFlowsConverter.fromRequest(this.client, interceptedRequest);
        com.google.common.base.Function<Response, ListDataFlowsResponse> transformer = ListDataFlowsConverter.fromResponse();
        AsyncHandler<ListDataFlowsRequest, ListDataFlowsResponse> handlerToUse = handler;
        Function futureSupplier = this.client.getFutureSupplier((BmcRequest)interceptedRequest, ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<ListDataFlowsRequest, ListDataFlowsResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<ListDependentObjectsResponse> listDependentObjects(ListDependentObjectsRequest request, AsyncHandler<ListDependentObjectsRequest, ListDependentObjectsResponse> handler) {
        LOG.trace("Called async listDependentObjects");
        ListDependentObjectsRequest interceptedRequest = ListDependentObjectsConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = ListDependentObjectsConverter.fromRequest(this.client, interceptedRequest);
        com.google.common.base.Function<Response, ListDependentObjectsResponse> transformer = ListDependentObjectsConverter.fromResponse();
        AsyncHandler<ListDependentObjectsRequest, ListDependentObjectsResponse> handlerToUse = handler;
        Function futureSupplier = this.client.getFutureSupplier((BmcRequest)interceptedRequest, ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<ListDependentObjectsRequest, ListDependentObjectsResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<ListExternalPublicationValidationsResponse> listExternalPublicationValidations(ListExternalPublicationValidationsRequest request, AsyncHandler<ListExternalPublicationValidationsRequest, ListExternalPublicationValidationsResponse> handler) {
        LOG.trace("Called async listExternalPublicationValidations");
        ListExternalPublicationValidationsRequest interceptedRequest = ListExternalPublicationValidationsConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = ListExternalPublicationValidationsConverter.fromRequest(this.client, interceptedRequest);
        com.google.common.base.Function<Response, ListExternalPublicationValidationsResponse> transformer = ListExternalPublicationValidationsConverter.fromResponse();
        AsyncHandler<ListExternalPublicationValidationsRequest, ListExternalPublicationValidationsResponse> handlerToUse = handler;
        Function futureSupplier = this.client.getFutureSupplier((BmcRequest)interceptedRequest, ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<ListExternalPublicationValidationsRequest, ListExternalPublicationValidationsResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<ListExternalPublicationsResponse> listExternalPublications(ListExternalPublicationsRequest request, AsyncHandler<ListExternalPublicationsRequest, ListExternalPublicationsResponse> handler) {
        LOG.trace("Called async listExternalPublications");
        ListExternalPublicationsRequest interceptedRequest = ListExternalPublicationsConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = ListExternalPublicationsConverter.fromRequest(this.client, interceptedRequest);
        com.google.common.base.Function<Response, ListExternalPublicationsResponse> transformer = ListExternalPublicationsConverter.fromResponse();
        AsyncHandler<ListExternalPublicationsRequest, ListExternalPublicationsResponse> handlerToUse = handler;
        Function futureSupplier = this.client.getFutureSupplier((BmcRequest)interceptedRequest, ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<ListExternalPublicationsRequest, ListExternalPublicationsResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<ListFoldersResponse> listFolders(ListFoldersRequest request, AsyncHandler<ListFoldersRequest, ListFoldersResponse> handler) {
        LOG.trace("Called async listFolders");
        ListFoldersRequest interceptedRequest = ListFoldersConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = ListFoldersConverter.fromRequest(this.client, interceptedRequest);
        com.google.common.base.Function<Response, ListFoldersResponse> transformer = ListFoldersConverter.fromResponse();
        AsyncHandler<ListFoldersRequest, ListFoldersResponse> handlerToUse = handler;
        Function futureSupplier = this.client.getFutureSupplier((BmcRequest)interceptedRequest, ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<ListFoldersRequest, ListFoldersResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<ListPatchChangesResponse> listPatchChanges(ListPatchChangesRequest request, AsyncHandler<ListPatchChangesRequest, ListPatchChangesResponse> handler) {
        LOG.trace("Called async listPatchChanges");
        ListPatchChangesRequest interceptedRequest = ListPatchChangesConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = ListPatchChangesConverter.fromRequest(this.client, interceptedRequest);
        com.google.common.base.Function<Response, ListPatchChangesResponse> transformer = ListPatchChangesConverter.fromResponse();
        AsyncHandler<ListPatchChangesRequest, ListPatchChangesResponse> handlerToUse = handler;
        Function futureSupplier = this.client.getFutureSupplier((BmcRequest)interceptedRequest, ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<ListPatchChangesRequest, ListPatchChangesResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<ListPatchesResponse> listPatches(ListPatchesRequest request, AsyncHandler<ListPatchesRequest, ListPatchesResponse> handler) {
        LOG.trace("Called async listPatches");
        ListPatchesRequest interceptedRequest = ListPatchesConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = ListPatchesConverter.fromRequest(this.client, interceptedRequest);
        com.google.common.base.Function<Response, ListPatchesResponse> transformer = ListPatchesConverter.fromResponse();
        AsyncHandler<ListPatchesRequest, ListPatchesResponse> handlerToUse = handler;
        Function futureSupplier = this.client.getFutureSupplier((BmcRequest)interceptedRequest, ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<ListPatchesRequest, ListPatchesResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<ListPipelineValidationsResponse> listPipelineValidations(ListPipelineValidationsRequest request, AsyncHandler<ListPipelineValidationsRequest, ListPipelineValidationsResponse> handler) {
        LOG.trace("Called async listPipelineValidations");
        ListPipelineValidationsRequest interceptedRequest = ListPipelineValidationsConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = ListPipelineValidationsConverter.fromRequest(this.client, interceptedRequest);
        com.google.common.base.Function<Response, ListPipelineValidationsResponse> transformer = ListPipelineValidationsConverter.fromResponse();
        AsyncHandler<ListPipelineValidationsRequest, ListPipelineValidationsResponse> handlerToUse = handler;
        Function futureSupplier = this.client.getFutureSupplier((BmcRequest)interceptedRequest, ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<ListPipelineValidationsRequest, ListPipelineValidationsResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<ListPipelinesResponse> listPipelines(ListPipelinesRequest request, AsyncHandler<ListPipelinesRequest, ListPipelinesResponse> handler) {
        LOG.trace("Called async listPipelines");
        ListPipelinesRequest interceptedRequest = ListPipelinesConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = ListPipelinesConverter.fromRequest(this.client, interceptedRequest);
        com.google.common.base.Function<Response, ListPipelinesResponse> transformer = ListPipelinesConverter.fromResponse();
        AsyncHandler<ListPipelinesRequest, ListPipelinesResponse> handlerToUse = handler;
        Function futureSupplier = this.client.getFutureSupplier((BmcRequest)interceptedRequest, ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<ListPipelinesRequest, ListPipelinesResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<ListProjectsResponse> listProjects(ListProjectsRequest request, AsyncHandler<ListProjectsRequest, ListProjectsResponse> handler) {
        LOG.trace("Called async listProjects");
        ListProjectsRequest interceptedRequest = ListProjectsConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = ListProjectsConverter.fromRequest(this.client, interceptedRequest);
        com.google.common.base.Function<Response, ListProjectsResponse> transformer = ListProjectsConverter.fromResponse();
        AsyncHandler<ListProjectsRequest, ListProjectsResponse> handlerToUse = handler;
        Function futureSupplier = this.client.getFutureSupplier((BmcRequest)interceptedRequest, ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<ListProjectsRequest, ListProjectsResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<ListPublishedObjectsResponse> listPublishedObjects(ListPublishedObjectsRequest request, AsyncHandler<ListPublishedObjectsRequest, ListPublishedObjectsResponse> handler) {
        LOG.trace("Called async listPublishedObjects");
        ListPublishedObjectsRequest interceptedRequest = ListPublishedObjectsConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = ListPublishedObjectsConverter.fromRequest(this.client, interceptedRequest);
        com.google.common.base.Function<Response, ListPublishedObjectsResponse> transformer = ListPublishedObjectsConverter.fromResponse();
        AsyncHandler<ListPublishedObjectsRequest, ListPublishedObjectsResponse> handlerToUse = handler;
        Function futureSupplier = this.client.getFutureSupplier((BmcRequest)interceptedRequest, ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<ListPublishedObjectsRequest, ListPublishedObjectsResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<ListReferencesResponse> listReferences(ListReferencesRequest request, AsyncHandler<ListReferencesRequest, ListReferencesResponse> handler) {
        LOG.trace("Called async listReferences");
        ListReferencesRequest interceptedRequest = ListReferencesConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = ListReferencesConverter.fromRequest(this.client, interceptedRequest);
        com.google.common.base.Function<Response, ListReferencesResponse> transformer = ListReferencesConverter.fromResponse();
        AsyncHandler<ListReferencesRequest, ListReferencesResponse> handlerToUse = handler;
        Function futureSupplier = this.client.getFutureSupplier((BmcRequest)interceptedRequest, ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<ListReferencesRequest, ListReferencesResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<ListSchemasResponse> listSchemas(ListSchemasRequest request, AsyncHandler<ListSchemasRequest, ListSchemasResponse> handler) {
        LOG.trace("Called async listSchemas");
        ListSchemasRequest interceptedRequest = ListSchemasConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = ListSchemasConverter.fromRequest(this.client, interceptedRequest);
        com.google.common.base.Function<Response, ListSchemasResponse> transformer = ListSchemasConverter.fromResponse();
        AsyncHandler<ListSchemasRequest, ListSchemasResponse> handlerToUse = handler;
        Function futureSupplier = this.client.getFutureSupplier((BmcRequest)interceptedRequest, ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<ListSchemasRequest, ListSchemasResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<ListTaskRunLogsResponse> listTaskRunLogs(ListTaskRunLogsRequest request, AsyncHandler<ListTaskRunLogsRequest, ListTaskRunLogsResponse> handler) {
        LOG.trace("Called async listTaskRunLogs");
        ListTaskRunLogsRequest interceptedRequest = ListTaskRunLogsConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = ListTaskRunLogsConverter.fromRequest(this.client, interceptedRequest);
        com.google.common.base.Function<Response, ListTaskRunLogsResponse> transformer = ListTaskRunLogsConverter.fromResponse();
        AsyncHandler<ListTaskRunLogsRequest, ListTaskRunLogsResponse> handlerToUse = handler;
        Function futureSupplier = this.client.getFutureSupplier((BmcRequest)interceptedRequest, ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<ListTaskRunLogsRequest, ListTaskRunLogsResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<ListTaskRunsResponse> listTaskRuns(ListTaskRunsRequest request, AsyncHandler<ListTaskRunsRequest, ListTaskRunsResponse> handler) {
        LOG.trace("Called async listTaskRuns");
        ListTaskRunsRequest interceptedRequest = ListTaskRunsConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = ListTaskRunsConverter.fromRequest(this.client, interceptedRequest);
        com.google.common.base.Function<Response, ListTaskRunsResponse> transformer = ListTaskRunsConverter.fromResponse();
        AsyncHandler<ListTaskRunsRequest, ListTaskRunsResponse> handlerToUse = handler;
        Function futureSupplier = this.client.getFutureSupplier((BmcRequest)interceptedRequest, ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<ListTaskRunsRequest, ListTaskRunsResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<ListTaskValidationsResponse> listTaskValidations(ListTaskValidationsRequest request, AsyncHandler<ListTaskValidationsRequest, ListTaskValidationsResponse> handler) {
        LOG.trace("Called async listTaskValidations");
        ListTaskValidationsRequest interceptedRequest = ListTaskValidationsConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = ListTaskValidationsConverter.fromRequest(this.client, interceptedRequest);
        com.google.common.base.Function<Response, ListTaskValidationsResponse> transformer = ListTaskValidationsConverter.fromResponse();
        AsyncHandler<ListTaskValidationsRequest, ListTaskValidationsResponse> handlerToUse = handler;
        Function futureSupplier = this.client.getFutureSupplier((BmcRequest)interceptedRequest, ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<ListTaskValidationsRequest, ListTaskValidationsResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<ListTasksResponse> listTasks(ListTasksRequest request, AsyncHandler<ListTasksRequest, ListTasksResponse> handler) {
        LOG.trace("Called async listTasks");
        ListTasksRequest interceptedRequest = ListTasksConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = ListTasksConverter.fromRequest(this.client, interceptedRequest);
        com.google.common.base.Function<Response, ListTasksResponse> transformer = ListTasksConverter.fromResponse();
        AsyncHandler<ListTasksRequest, ListTasksResponse> handlerToUse = handler;
        Function futureSupplier = this.client.getFutureSupplier((BmcRequest)interceptedRequest, ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<ListTasksRequest, ListTasksResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<ListWorkRequestErrorsResponse> listWorkRequestErrors(ListWorkRequestErrorsRequest request, AsyncHandler<ListWorkRequestErrorsRequest, ListWorkRequestErrorsResponse> handler) {
        LOG.trace("Called async listWorkRequestErrors");
        ListWorkRequestErrorsRequest interceptedRequest = ListWorkRequestErrorsConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = ListWorkRequestErrorsConverter.fromRequest(this.client, interceptedRequest);
        com.google.common.base.Function<Response, ListWorkRequestErrorsResponse> transformer = ListWorkRequestErrorsConverter.fromResponse();
        AsyncHandler<ListWorkRequestErrorsRequest, ListWorkRequestErrorsResponse> handlerToUse = handler;
        Function futureSupplier = this.client.getFutureSupplier((BmcRequest)interceptedRequest, ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<ListWorkRequestErrorsRequest, ListWorkRequestErrorsResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<ListWorkRequestLogsResponse> listWorkRequestLogs(ListWorkRequestLogsRequest request, AsyncHandler<ListWorkRequestLogsRequest, ListWorkRequestLogsResponse> handler) {
        LOG.trace("Called async listWorkRequestLogs");
        ListWorkRequestLogsRequest interceptedRequest = ListWorkRequestLogsConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = ListWorkRequestLogsConverter.fromRequest(this.client, interceptedRequest);
        com.google.common.base.Function<Response, ListWorkRequestLogsResponse> transformer = ListWorkRequestLogsConverter.fromResponse();
        AsyncHandler<ListWorkRequestLogsRequest, ListWorkRequestLogsResponse> handlerToUse = handler;
        Function futureSupplier = this.client.getFutureSupplier((BmcRequest)interceptedRequest, ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<ListWorkRequestLogsRequest, ListWorkRequestLogsResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<ListWorkRequestsResponse> listWorkRequests(ListWorkRequestsRequest request, AsyncHandler<ListWorkRequestsRequest, ListWorkRequestsResponse> handler) {
        LOG.trace("Called async listWorkRequests");
        ListWorkRequestsRequest interceptedRequest = ListWorkRequestsConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = ListWorkRequestsConverter.fromRequest(this.client, interceptedRequest);
        com.google.common.base.Function<Response, ListWorkRequestsResponse> transformer = ListWorkRequestsConverter.fromResponse();
        AsyncHandler<ListWorkRequestsRequest, ListWorkRequestsResponse> handlerToUse = handler;
        Function futureSupplier = this.client.getFutureSupplier((BmcRequest)interceptedRequest, ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<ListWorkRequestsRequest, ListWorkRequestsResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<ListWorkspacesResponse> listWorkspaces(ListWorkspacesRequest request, AsyncHandler<ListWorkspacesRequest, ListWorkspacesResponse> handler) {
        LOG.trace("Called async listWorkspaces");
        ListWorkspacesRequest interceptedRequest = ListWorkspacesConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = ListWorkspacesConverter.fromRequest(this.client, interceptedRequest);
        com.google.common.base.Function<Response, ListWorkspacesResponse> transformer = ListWorkspacesConverter.fromResponse();
        AsyncHandler<ListWorkspacesRequest, ListWorkspacesResponse> handlerToUse = handler;
        Function futureSupplier = this.client.getFutureSupplier((BmcRequest)interceptedRequest, ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<ListWorkspacesRequest, ListWorkspacesResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<StartWorkspaceResponse> startWorkspace(StartWorkspaceRequest request, AsyncHandler<StartWorkspaceRequest, StartWorkspaceResponse> handler) {
        LOG.trace("Called async startWorkspace");
        StartWorkspaceRequest interceptedRequest = StartWorkspaceConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = StartWorkspaceConverter.fromRequest(this.client, interceptedRequest);
        com.google.common.base.Function<Response, StartWorkspaceResponse> transformer = StartWorkspaceConverter.fromResponse();
        RetryTokenUtils.addRetryToken((WrappedInvocationBuilder)ib);
        AsyncHandler<StartWorkspaceRequest, StartWorkspaceResponse> handlerToUse = handler;
        Function futureSupplier = this.client.postFutureSupplier((BmcRequest)interceptedRequest, ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<StartWorkspaceRequest, StartWorkspaceResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<StopWorkspaceResponse> stopWorkspace(StopWorkspaceRequest request, AsyncHandler<StopWorkspaceRequest, StopWorkspaceResponse> handler) {
        LOG.trace("Called async stopWorkspace");
        StopWorkspaceRequest interceptedRequest = StopWorkspaceConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = StopWorkspaceConverter.fromRequest(this.client, interceptedRequest);
        com.google.common.base.Function<Response, StopWorkspaceResponse> transformer = StopWorkspaceConverter.fromResponse();
        RetryTokenUtils.addRetryToken((WrappedInvocationBuilder)ib);
        AsyncHandler<StopWorkspaceRequest, StopWorkspaceResponse> handlerToUse = handler;
        Function futureSupplier = this.client.postFutureSupplier((BmcRequest)interceptedRequest, ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<StopWorkspaceRequest, StopWorkspaceResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<UpdateApplicationResponse> updateApplication(UpdateApplicationRequest request, AsyncHandler<UpdateApplicationRequest, UpdateApplicationResponse> handler) {
        LOG.trace("Called async updateApplication");
        UpdateApplicationRequest interceptedRequest = UpdateApplicationConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = UpdateApplicationConverter.fromRequest(this.client, interceptedRequest);
        com.google.common.base.Function<Response, UpdateApplicationResponse> transformer = UpdateApplicationConverter.fromResponse();
        AsyncHandler<UpdateApplicationRequest, UpdateApplicationResponse> handlerToUse = handler;
        Function futureSupplier = this.client.putFutureSupplier((BmcRequest)interceptedRequest, ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<UpdateApplicationRequest, UpdateApplicationResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<UpdateConnectionResponse> updateConnection(UpdateConnectionRequest request, AsyncHandler<UpdateConnectionRequest, UpdateConnectionResponse> handler) {
        LOG.trace("Called async updateConnection");
        UpdateConnectionRequest interceptedRequest = UpdateConnectionConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = UpdateConnectionConverter.fromRequest(this.client, interceptedRequest);
        com.google.common.base.Function<Response, UpdateConnectionResponse> transformer = UpdateConnectionConverter.fromResponse();
        AsyncHandler<UpdateConnectionRequest, UpdateConnectionResponse> handlerToUse = handler;
        Function futureSupplier = this.client.putFutureSupplier((BmcRequest)interceptedRequest, ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<UpdateConnectionRequest, UpdateConnectionResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<UpdateDataAssetResponse> updateDataAsset(UpdateDataAssetRequest request, AsyncHandler<UpdateDataAssetRequest, UpdateDataAssetResponse> handler) {
        LOG.trace("Called async updateDataAsset");
        UpdateDataAssetRequest interceptedRequest = UpdateDataAssetConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = UpdateDataAssetConverter.fromRequest(this.client, interceptedRequest);
        com.google.common.base.Function<Response, UpdateDataAssetResponse> transformer = UpdateDataAssetConverter.fromResponse();
        AsyncHandler<UpdateDataAssetRequest, UpdateDataAssetResponse> handlerToUse = handler;
        Function futureSupplier = this.client.putFutureSupplier((BmcRequest)interceptedRequest, ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<UpdateDataAssetRequest, UpdateDataAssetResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<UpdateDataFlowResponse> updateDataFlow(UpdateDataFlowRequest request, AsyncHandler<UpdateDataFlowRequest, UpdateDataFlowResponse> handler) {
        LOG.trace("Called async updateDataFlow");
        UpdateDataFlowRequest interceptedRequest = UpdateDataFlowConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = UpdateDataFlowConverter.fromRequest(this.client, interceptedRequest);
        com.google.common.base.Function<Response, UpdateDataFlowResponse> transformer = UpdateDataFlowConverter.fromResponse();
        AsyncHandler<UpdateDataFlowRequest, UpdateDataFlowResponse> handlerToUse = handler;
        Function futureSupplier = this.client.putFutureSupplier((BmcRequest)interceptedRequest, ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<UpdateDataFlowRequest, UpdateDataFlowResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<UpdateExternalPublicationResponse> updateExternalPublication(UpdateExternalPublicationRequest request, AsyncHandler<UpdateExternalPublicationRequest, UpdateExternalPublicationResponse> handler) {
        LOG.trace("Called async updateExternalPublication");
        UpdateExternalPublicationRequest interceptedRequest = UpdateExternalPublicationConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = UpdateExternalPublicationConverter.fromRequest(this.client, interceptedRequest);
        com.google.common.base.Function<Response, UpdateExternalPublicationResponse> transformer = UpdateExternalPublicationConverter.fromResponse();
        AsyncHandler<UpdateExternalPublicationRequest, UpdateExternalPublicationResponse> handlerToUse = handler;
        Function futureSupplier = this.client.putFutureSupplier((BmcRequest)interceptedRequest, ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<UpdateExternalPublicationRequest, UpdateExternalPublicationResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<UpdateFolderResponse> updateFolder(UpdateFolderRequest request, AsyncHandler<UpdateFolderRequest, UpdateFolderResponse> handler) {
        LOG.trace("Called async updateFolder");
        UpdateFolderRequest interceptedRequest = UpdateFolderConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = UpdateFolderConverter.fromRequest(this.client, interceptedRequest);
        com.google.common.base.Function<Response, UpdateFolderResponse> transformer = UpdateFolderConverter.fromResponse();
        AsyncHandler<UpdateFolderRequest, UpdateFolderResponse> handlerToUse = handler;
        Function futureSupplier = this.client.putFutureSupplier((BmcRequest)interceptedRequest, ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<UpdateFolderRequest, UpdateFolderResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<UpdatePipelineResponse> updatePipeline(UpdatePipelineRequest request, AsyncHandler<UpdatePipelineRequest, UpdatePipelineResponse> handler) {
        LOG.trace("Called async updatePipeline");
        UpdatePipelineRequest interceptedRequest = UpdatePipelineConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = UpdatePipelineConverter.fromRequest(this.client, interceptedRequest);
        com.google.common.base.Function<Response, UpdatePipelineResponse> transformer = UpdatePipelineConverter.fromResponse();
        AsyncHandler<UpdatePipelineRequest, UpdatePipelineResponse> handlerToUse = handler;
        Function futureSupplier = this.client.putFutureSupplier((BmcRequest)interceptedRequest, ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<UpdatePipelineRequest, UpdatePipelineResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<UpdateProjectResponse> updateProject(UpdateProjectRequest request, AsyncHandler<UpdateProjectRequest, UpdateProjectResponse> handler) {
        LOG.trace("Called async updateProject");
        UpdateProjectRequest interceptedRequest = UpdateProjectConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = UpdateProjectConverter.fromRequest(this.client, interceptedRequest);
        com.google.common.base.Function<Response, UpdateProjectResponse> transformer = UpdateProjectConverter.fromResponse();
        AsyncHandler<UpdateProjectRequest, UpdateProjectResponse> handlerToUse = handler;
        Function futureSupplier = this.client.putFutureSupplier((BmcRequest)interceptedRequest, ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<UpdateProjectRequest, UpdateProjectResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<UpdateReferenceResponse> updateReference(UpdateReferenceRequest request, AsyncHandler<UpdateReferenceRequest, UpdateReferenceResponse> handler) {
        LOG.trace("Called async updateReference");
        UpdateReferenceRequest interceptedRequest = UpdateReferenceConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = UpdateReferenceConverter.fromRequest(this.client, interceptedRequest);
        com.google.common.base.Function<Response, UpdateReferenceResponse> transformer = UpdateReferenceConverter.fromResponse();
        RetryTokenUtils.addRetryToken((WrappedInvocationBuilder)ib);
        AsyncHandler<UpdateReferenceRequest, UpdateReferenceResponse> handlerToUse = handler;
        Function futureSupplier = this.client.putFutureSupplier((BmcRequest)interceptedRequest, ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<UpdateReferenceRequest, UpdateReferenceResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<UpdateTaskResponse> updateTask(UpdateTaskRequest request, AsyncHandler<UpdateTaskRequest, UpdateTaskResponse> handler) {
        LOG.trace("Called async updateTask");
        UpdateTaskRequest interceptedRequest = UpdateTaskConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = UpdateTaskConverter.fromRequest(this.client, interceptedRequest);
        com.google.common.base.Function<Response, UpdateTaskResponse> transformer = UpdateTaskConverter.fromResponse();
        AsyncHandler<UpdateTaskRequest, UpdateTaskResponse> handlerToUse = handler;
        Function futureSupplier = this.client.putFutureSupplier((BmcRequest)interceptedRequest, ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<UpdateTaskRequest, UpdateTaskResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<UpdateTaskRunResponse> updateTaskRun(UpdateTaskRunRequest request, AsyncHandler<UpdateTaskRunRequest, UpdateTaskRunResponse> handler) {
        LOG.trace("Called async updateTaskRun");
        UpdateTaskRunRequest interceptedRequest = UpdateTaskRunConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = UpdateTaskRunConverter.fromRequest(this.client, interceptedRequest);
        com.google.common.base.Function<Response, UpdateTaskRunResponse> transformer = UpdateTaskRunConverter.fromResponse();
        AsyncHandler<UpdateTaskRunRequest, UpdateTaskRunResponse> handlerToUse = handler;
        Function futureSupplier = this.client.putFutureSupplier((BmcRequest)interceptedRequest, ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<UpdateTaskRunRequest, UpdateTaskRunResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<UpdateWorkspaceResponse> updateWorkspace(UpdateWorkspaceRequest request, AsyncHandler<UpdateWorkspaceRequest, UpdateWorkspaceResponse> handler) {
        LOG.trace("Called async updateWorkspace");
        UpdateWorkspaceRequest interceptedRequest = UpdateWorkspaceConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = UpdateWorkspaceConverter.fromRequest(this.client, interceptedRequest);
        com.google.common.base.Function<Response, UpdateWorkspaceResponse> transformer = UpdateWorkspaceConverter.fromResponse();
        AsyncHandler<UpdateWorkspaceRequest, UpdateWorkspaceResponse> handlerToUse = handler;
        Function futureSupplier = this.client.putFutureSupplier((BmcRequest)interceptedRequest, ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<UpdateWorkspaceRequest, UpdateWorkspaceResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    RestClient getClient() {
        return this.client;
    }

    public static class Builder
    extends RegionalClientBuilder<Builder, DataIntegrationAsyncClient> {
        private Builder(Service service) {
            super(service);
            this.requestSignerFactory = new DefaultRequestSignerFactory(SigningStrategy.STANDARD);
        }

        public DataIntegrationAsyncClient build(@NonNull AbstractAuthenticationDetailsProvider authenticationDetailsProvider) {
            if (authenticationDetailsProvider == null) {
                throw new NullPointerException("authenticationDetailsProvider is marked non-null but is null");
            }
            return new DataIntegrationAsyncClient(authenticationDetailsProvider, this.configuration, this.clientConfigurator, this.requestSignerFactory, this.signingStrategyRequestSignerFactories, this.additionalClientConfigurators, this.endpoint);
        }
    }
}

