/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.dataintegration;

import com.google.common.base.Function;
import com.google.common.base.Predicate;
import com.google.common.base.Suppliers;
import com.oracle.bmc.dataintegration.DataIntegration;
import com.oracle.bmc.dataintegration.model.Workspace;
import com.oracle.bmc.dataintegration.requests.GetWorkRequestRequest;
import com.oracle.bmc.dataintegration.requests.GetWorkspaceRequest;
import com.oracle.bmc.dataintegration.responses.GetWorkRequestResponse;
import com.oracle.bmc.dataintegration.responses.GetWorkspaceResponse;
import com.oracle.bmc.waiter.BmcGenericWaiter;
import com.oracle.bmc.waiter.DelayStrategy;
import com.oracle.bmc.waiter.TerminationStrategy;
import com.oracle.bmc.waiter.Waiter;
import com.oracle.bmc.waiter.Waiters;
import com.oracle.bmc.waiter.internal.SimpleWaiterImpl;
import java.beans.ConstructorProperties;
import java.util.Arrays;
import java.util.HashSet;
import java.util.concurrent.ExecutorService;
import org.apache.commons.lang3.Validate;

public class DataIntegrationWaiters {
    private final ExecutorService executorService;
    private final DataIntegration client;

    public Waiter<GetWorkRequestRequest, GetWorkRequestResponse> forWorkRequest(GetWorkRequestRequest request) {
        return this.forWorkRequest(Waiters.DEFAULT_POLLING_WAITER, request);
    }

    public Waiter<GetWorkRequestRequest, GetWorkRequestResponse> forWorkRequest(GetWorkRequestRequest request, TerminationStrategy terminationStrategy, DelayStrategy delayStrategy) {
        return this.forWorkRequest(Waiters.newWaiter((TerminationStrategy)terminationStrategy, (DelayStrategy)delayStrategy), request);
    }

    private Waiter<GetWorkRequestRequest, GetWorkRequestResponse> forWorkRequest(BmcGenericWaiter waiter, GetWorkRequestRequest request) {
        return new SimpleWaiterImpl(this.executorService, waiter.toCallable(Suppliers.ofInstance((Object)((Object)request)), (Function)new Function<GetWorkRequestRequest, GetWorkRequestResponse>(){

            public GetWorkRequestResponse apply(GetWorkRequestRequest request) {
                return DataIntegrationWaiters.this.client.getWorkRequest(request);
            }
        }, (Predicate)new Predicate<GetWorkRequestResponse>(){

            public boolean apply(GetWorkRequestResponse response) {
                return response.getWorkRequest().getTimeFinished() != null;
            }
        }, false), (Object)request);
    }

    public Waiter<GetWorkspaceRequest, GetWorkspaceResponse> forWorkspace(GetWorkspaceRequest request, Workspace.LifecycleState ... targetStates) {
        Validate.notEmpty((Object[])targetStates, (String)"At least one targetState must be provided", (Object[])new Object[0]);
        Validate.noNullElements((Object[])targetStates, (String)"Null targetState values are not permitted", (Object[])new Object[0]);
        return this.forWorkspace(Waiters.DEFAULT_POLLING_WAITER, request, targetStates);
    }

    public Waiter<GetWorkspaceRequest, GetWorkspaceResponse> forWorkspace(GetWorkspaceRequest request, Workspace.LifecycleState targetState, TerminationStrategy terminationStrategy, DelayStrategy delayStrategy) {
        Validate.notNull((Object)((Object)targetState), (String)"The targetState cannot be null", (Object[])new Object[0]);
        return this.forWorkspace(Waiters.newWaiter((TerminationStrategy)terminationStrategy, (DelayStrategy)delayStrategy), request, targetState);
    }

    public Waiter<GetWorkspaceRequest, GetWorkspaceResponse> forWorkspace(GetWorkspaceRequest request, TerminationStrategy terminationStrategy, DelayStrategy delayStrategy, Workspace.LifecycleState ... targetStates) {
        Validate.notEmpty((Object[])targetStates, (String)"At least one target state must be provided", (Object[])new Object[0]);
        Validate.noNullElements((Object[])targetStates, (String)"Null target states are not permitted", (Object[])new Object[0]);
        return this.forWorkspace(Waiters.newWaiter((TerminationStrategy)terminationStrategy, (DelayStrategy)delayStrategy), request, targetStates);
    }

    private Waiter<GetWorkspaceRequest, GetWorkspaceResponse> forWorkspace(BmcGenericWaiter waiter, GetWorkspaceRequest request, Workspace.LifecycleState ... targetStates) {
        final HashSet<Workspace.LifecycleState> targetStatesSet = new HashSet<Workspace.LifecycleState>(Arrays.asList(targetStates));
        return new SimpleWaiterImpl(this.executorService, waiter.toCallable(Suppliers.ofInstance((Object)((Object)request)), (Function)new Function<GetWorkspaceRequest, GetWorkspaceResponse>(){

            public GetWorkspaceResponse apply(GetWorkspaceRequest request) {
                return DataIntegrationWaiters.this.client.getWorkspace(request);
            }
        }, (Predicate)new Predicate<GetWorkspaceResponse>(){

            public boolean apply(GetWorkspaceResponse response) {
                return targetStatesSet.contains((Object)response.getWorkspace().getLifecycleState());
            }
        }, targetStatesSet.contains((Object)Workspace.LifecycleState.Deleted)), (Object)request);
    }

    @ConstructorProperties(value={"executorService", "client"})
    public DataIntegrationWaiters(ExecutorService executorService, DataIntegration client) {
        this.executorService = executorService;
        this.client = client;
    }
}

